#
#' StrathE2E2 Package
#'
#' @name StrathE2E2
#' @rdname StrathE2E2-package
#'
#' @description
#' StrathE2E2 is a dynamic model of the 'big-picture', whole ecosystem effects of hydrodynamics, temperature, nutrient additions, and fishing on continental shelf marine food webs
#'
#' @details
#' The StrathE2E2 model has two linked parts - a fishing fleet model and an ecology model. The fishing model integrates harvesting, discarding and seabed 
#'   disturbance rates across a range of gears and passes the results into the ecology model.
#'
#' The ecology model is a network of coupled ordinary differential equations representing the rates of change in organic detritus, dissolved inorganic 
#'   nutrient, and coarse guilds of living biomass spanning microbes to megafauna. The equations include representations of feeding, metabolism, reproduction, 
#'   active migrations, advection and mixing. Environmental driving data include temperature, irradiance, hydrodynamics, and nutrient inputs from rivers, atmosphere and ocean boundaries.
#'
#' The package includes functions for parameter optimisation, global sensitivity analysis, and Monte Carlo estimation of credible intervals for model outputs
#' 
#' A fully developed and documented implementation for the North Sea is included in the package.
#'
#' User community \cr
#' We plan to develop a repository of open access implementations of StrathE2E for shelf sea regions. Users developing implementations which they are willing to share are encouraged to contact us to discuss inclusion in the repository.
#'
#' Funding \cr
#' Development of the StrathE2E2 package was supported by the UK NERC Marine Ecosystems Research Programme (grant NE/L003120/1) \url{https://www.marine-ecosystems.org.uk/Home} \cr
#' Other projects which have supported aspects of the model development are: \cr
#' EU-Horizon 2020 (DISCARDLESS project) \url{http://www.discardless.eu/} \cr
#' Fisheries Innovation Scotland (project FIS003) \url{https://https://fiscot.org/fis-projects/} \cr
#'
#' Information on how to cite the package ... from an R session ... citation("StrathE2E2")
#'
#' List of all vignettes and documentation supplied with the package: \cr
#'   \url{../doc/index.html} \cr
#'
#' Access the User Manual ... \url{../doc/StrathE2E2_User_Manual.html} \cr
#'   or ... from an R session ... vignette("StrathE2E2_User_Manual")
#'
#' Technical Manual - documentation on the structure of input and output R-objects and files: \cr
#'   \url{../doc/StrathE2E2_Technical_Manual.pdf} \cr
#'
#' Additional documentation: \cr
#'   \url{../doc/StrathE2E2_Model_origin.html}: Origin of the model (previous versions) \cr
#'   \url{../doc/StrathE2E2_Model_overview.html}: Overview of the model concepts and design \cr
#'   \url{../doc/StrathE2E2_Ecology_model.pdf}: Ecology model description \cr
#'   \url{../doc/StrathE2E2_Fishing_fleet_model.pdf}: Fishing fleet model description \cr
#'   \url{../doc/StrathE2E2_Optimisation_sensitivity_Monte_Carlo_methodology.pdf}: Optimisation, sensitivity and Monte Carlo methods \cr
#'   \url{../doc/StrathE2E2_North_Sea_model.pdf}: Documentation on the North Sea implementation \cr
#'
#' @seealso {Model management family of functions} \cr
#' \itemize{
#'   \item \code{\link{list_models}}: List the available models in a designated workspace
#'   \item \code{\link{copy_model}}: Make a copy of a named model/variant in a user defined workspace
#'   \item \code{\link{read_model}}: Read a model setup from a given workspace - this is a core function in the package
#' }
#'
#' @seealso {Basic model run family of functions} \cr
#' \itemize{
#'   \item \code{\link{StrathE2E}}: Run the model for a prescribed number of years
#'   \item \code{\link{extract_new_initial_cond_from_end_of_run}}: Create a new initial values file from the end-state of a model run
#'   \item \code{\link{plot_full_length_timeseries}}: Plot time series of state variables for the full duration of a model run
#'   \item \code{\link{plot_final_year}}: Plot whole domian data for the final year of a run
#'   \item \code{\link{plot_final_year_LTL_inshore_vs_offshore}}: Plot inshore and offshore lower trophic level data for the final year
#'   \item \code{\link{plot_final_year_HTL_inshore_vs_offshore}}: Plot inshore and offshore upper trophic level data for the final year
#'   \item \code{\link{plot_sediment_habitats_final_year}}: Plot sediment nutrients and detritus for the final year
#'   \item \code{\link{box_and_whisker_annual_plots}}: Plot comparison of observed annual data and derived model results
#'   \item \code{\link{box_and_whisker_monthly_plots}}: Plot comparison of observed monthly data with derived model results
#'   \item \code{\link{plot_time_series_annual_land_disc}}: Plot time series of annual landings and discards for a full run
#'   \item \code{\link{plot_for_each_gear_catch_by_guild}}: Plot annual catch composition of each gear for the final year of a run
#'   \item \code{\link{plot_for_each_guild_catch_by_gear}}: Plot distribution of catches across gear for each guild in the final yea
#' }
#'
#' @seealso {Model comparison family of functions} \cr
#' \itemize{
#'   \item \code{\link{compare_two_runs_aam}}: Plot a tornado diagram comparing annual average mass data from two model runs
#'   \item \code{\link{compare_two_runs_catch}}: Plot a tornado diagram comparing annual landings and discards data from two model runs
#' }
#'
#' @seealso {Parameter estimation family of functions} \cr
#' \itemize{
#'   \item \code{\link{annealing_find_ecology_parameters}}: Find ecology model parameters maximising the likelihood of observed ecosystem data
#'   \item \code{\link{annealing_find_harvest_ratio_mult}}: Find harvest ratio multipliers maximising the likelihood of observed ecosystem data
#'   \item \code{\link{calculate_hr_scale_values}}: Calculate fishing fleet model parameters which link effort to harvest ratios
#'   \item \code{\link{annealing_find_gear_activity_mult_ecosystem_target}}: Find gear activity multipliers maximising the likelihood of observed ecosystem data
#'   \item \code{\link{annealing_find_gear_activity_mult_HR_target}}: Find gear activity multipliers maximising the likelihood of known harvest ratios
#' }
#'
#' @seealso {Sensitivity analysis family of functions} \cr
#' \itemize{
#'   \item \code{\link{Sensitivity_analysis_StrathE2E}}: Run a Morris Method global sensitivity analysis
#'   \item \code{\link{concatenate_raw_sensitivity_analysis_results}}: Merge raw analysis data from parallel runs into a single file
#'   \item \code{\link{process_sensitivity_analysis_results_offline}}: Process raw data offline to create final outputs
#'   \item \code{\link{plot_sensitivity_analysis_results}}: Plot sensitivity analysis results
#' }
#'
#' @seealso {Monte Carlo analysis family of functions} \cr
#' \itemize{
#'   \item \code{\link{Monte_Carlo_StrathE2E}}: Monte Carlo simulation to generate credible intervals of model outputs
#'   \item \code{\link{plot_Monte_Carlo_parameter_distributions}}: Plot credible intervals of model parameters
#'   \item \code{\link{plot_final_year_time_series_data_with_credible_intervals}}: Plot time series of state variables for the final year of a model run
#'   \item \code{\link{plot_final_year_migration_data_with_credible_intervals}}: Plot migration fluxes between offshore and inshore zones
#'   \item \code{\link{plot_final_year_trophic_data_with_credible_intervals}}: Plot annual mean trophic level and omnivory indices for model guilds
#'   \item \code{\link{plot_inshore_vs_offshore_anavmass_with_credible_intervals}}: Plot inshore and offshore annual average mass densities for the final year
#'   \item \code{\link{box_and_whisker_annual_plots_with_credible_intervals}}: Plot comparison of observed ecosystem data with equivalent model outputs
#'   \item \code{\link{box_and_whisker_monthly_plots_with_credible_intervals}}: Plot comparison of observed nutrient and plankton data with model outputs
#' }
NULL


