#
# derive_annual_results_offshore.R
#
#' derive set of results for offshore only and write to files
#'
#' @param model model object
#' @param build model build object
#' @param output  model output
#' @param aggregates  aggregated model output
#'
#
derive_annual_results_offshore <- function(model, build, output, aggregates) {

	# Unpack:
	setup		<- elt(model, "setup")
	identifier	<- elt(setup, "model.ident")
	resultsdir	<- elt(setup, "resultsdir")

	run		<- elt(build, "run")
	ndays		<- elt(run, "ndays")
	nyears		<- elt(run, "nyears")

	data		<- elt(model, "data")
	physical.parms  <- elt(data, "physical.parameters")

	# extract physical parameters:
	so_depth	<- elt(physical.parms, "so_depth")
	d_depth		<- elt(physical.parms, "d_depth")
	si_depth	<- elt(physical.parms, "si_depth")
	x_depth_s1	<- elt(physical.parms, "x_depth_s1")
	x_depth_s2	<- elt(physical.parms, "x_depth_s2")
	x_depth_s3	<- elt(physical.parms, "x_depth_s3")
	x_depth_d1	<- elt(physical.parms, "x_depth_d1")
	x_depth_d2	<- elt(physical.parms, "x_depth_d2")
	x_depth_d3	<- elt(physical.parms, "x_depth_d3")
	x_area_s0	<- elt(physical.parms, "x_area_s0")
	x_area_s1	<- elt(physical.parms, "x_area_s1")
	x_area_s2	<- elt(physical.parms, "x_area_s2")
	x_area_s3	<- elt(physical.parms, "x_area_s3")
	x_area_d0	<- elt(physical.parms, "x_area_d0")
	x_area_d1	<- elt(physical.parms, "x_area_d1")
	x_area_d2	<- elt(physical.parms, "x_area_d2")
	x_area_d3	<- elt(physical.parms, "x_area_d3")
	x_poros_s1	<- elt(physical.parms, "x_poros_s1")
	x_poros_s2	<- elt(physical.parms, "x_poros_s2")
	x_poros_s3	<- elt(physical.parms, "x_poros_s3")
	x_poros_d1	<- elt(physical.parms, "x_poros_d1")
	x_poros_d2	<- elt(physical.parms, "x_poros_d2")
	x_poros_d3	<- elt(physical.parms, "x_poros_d3")
	x_shallowprop	<- elt(physical.parms, "x_shallowprop")

	# extract output:
	detritus_so		<- elt(output, "detritus_so")
	detritus_d		<- elt(output, "detritus_d")
	xR_detritus_d1		<- elt(output, "xR_detritus_d1")
	xR_detritus_d2		<- elt(output, "xR_detritus_d2")
	xR_detritus_d3		<- elt(output, "xR_detritus_d3")
	discard_o		<- elt(output, "discard_o")
	ammonia_so		<- elt(output, "ammonia_so")
	ammonia_d		<- elt(output, "ammonia_d")
	nitrate_so		<- elt(output, "nitrate_so")
	nitrate_d		<- elt(output, "nitrate_d")
	phyt_so			<- elt(output, "phyt_so")
	phyt_d			<- elt(output, "phyt_d")
	herb_o			<- elt(output, "herb_o")
	carn_o			<- elt(output, "carn_o")
	benthslar_o		<- elt(output, "benthslar_o")
	benths_o		<- elt(output, "benths_o")
	benthclar_o		<- elt(output, "benthclar_o")
	benthc_o		<- elt(output, "benthc_o")
	fishplar_o		<- elt(output, "fishplar_o")
	fishp_o			<- elt(output, "fishp_o")
	fishm_o			<- elt(output, "fishm_o")
	fishdlar_o		<- elt(output, "fishdlar_o")
	fishd_o			<- elt(output, "fishd_o")
	bird_o			<- elt(output, "bird_o")
	seal_o			<- elt(output, "seal_o")
	ceta_o			<- elt(output, "ceta_o")
	fluxAMMinflow_o		<- elt(output, "fluxAMMinflow_o")
	fluxNITinflow_o		<- elt(output, "fluxNITinflow_o")
	fluxAMMoutflow_o	<- elt(output, "fluxAMMoutflow_o")
	fluxNIToutflow_o	<- elt(output, "fluxNIToutflow_o")
	fluxPHYTinflow_o	<- elt(output, "fluxPHYTinflow_o")
	fluxDETinflow_o		<- elt(output, "fluxDETinflow_o")
	fluxPHYToutflow_o	<- elt(output, "fluxPHYToutflow_o")
	fluxDEToutflow_o	<- elt(output, "fluxDEToutflow_o")
	atmosAMMinput_o		<- elt(output, "atmosAMMinput_o")
	atmosNITinput_o		<- elt(output, "atmosNITinput_o")
	vertnitflux		<- elt(output, "vertnitflux")
	fluxsedboundary_o	<- elt(output, "fluxsedboundary_o")
	mfish_imigration	<- elt(output, "mfish_imigration")
	mfish_emigration	<- elt(output, "mfish_emigration")
	netpprod_o		<- elt(output, "netpprod_o")
	PNP_o			<- elt(output, "PNP_o")
	fluxwcnit_phyt_o	<- elt(output, "fluxwcnit_phyt_o")
	fluxwcamm_phyt_o	<- elt(output, "fluxwcamm_phyt_o")
	phytgrossprod_o		<- elt(output, "phytgrossprod_o")
	herbgrossprod_o		<- elt(output, "herbgrossprod_o")
	carngrossprod_o		<- elt(output, "carngrossprod_o")
	pfishlargrossprod_o	<- elt(output, "pfishlargrossprod_o")
	dfishlargrossprod_o	<- elt(output, "dfishlargrossprod_o")
	pfishgrossprod_o	<- elt(output, "pfishgrossprod_o")
	mfishgrossprod_o	<- elt(output, "mfishgrossprod_o")
	dfishgrossprod_o	<- elt(output, "dfishgrossprod_o")
	benthslargrossprod_o	<- elt(output, "benthslargrossprod_o")
	benthclargrossprod_o	<- elt(output, "benthclargrossprod_o")
	benthsgrossprod_o	<- elt(output, "benthsgrossprod_o")
	benthcgrossprod_o	<- elt(output, "benthcgrossprod_o")
	birdgrossprod_o		<- elt(output, "birdgrossprod_o")
	sealgrossprod_o		<- elt(output, "sealgrossprod_o")
	cetagrossprod_o		<- elt(output, "cetagrossprod_o")
	herbnetprod_o		<- elt(output, "herbnetprod_o")
	carnnetprod_o		<- elt(output, "carnnetprod_o")
	pfishlarnetprod_o	<- elt(output, "pfishlarnetprod_o")
	dfishlarnetprod_o	<- elt(output, "dfishlarnetprod_o")
	pfishnetprod_o		<- elt(output, "pfishnetprod_o")
	mfishnetprod_o		<- elt(output, "mfishnetprod_o")
	dfishnetprod_o		<- elt(output, "dfishnetprod_o")
	benthslarnetprod_o	<- elt(output, "benthslarnetprod_o")
	benthclarnetprod_o	<- elt(output, "benthclarnetprod_o")
	benthsnetprod_o		<- elt(output, "benthsnetprod_o")
	benthcnetprod_o		<- elt(output, "benthcnetprod_o")
	birdnetprod_o		<- elt(output, "birdnetprod_o")
	sealnetprod_o		<- elt(output, "sealnetprod_o")
	cetanetprod_o		<- elt(output, "cetanetprod_o")
	landp_o			<- elt(output, "landp_o")
	landm_o			<- elt(output, "landm_o")
	landd_quota_o		<- elt(output, "landd_quota_o")
	landd_nonquota_o	<- elt(output, "landd_nonquota_o")
	landsb_o		<- elt(output, "landsb_o")
	landcb_o		<- elt(output, "landcb_o")
	landcz_o		<- elt(output, "landcz_o")
	landbd_o		<- elt(output, "landbd_o")
	landsl_o		<- elt(output, "landsl_o")
	landct_o		<- elt(output, "landct_o")
	discpel_o		<- elt(output, "discpel_o")
	discmig_o		<- elt(output, "discmig_o")
	discdem_quota_o		<- elt(output, "discdem_quota_o")
	discdem_nonquota_o	<- elt(output, "discdem_nonquota_o")
	discsb_o		<- elt(output, "discsb_o")
	disccb_o		<- elt(output, "disccb_o")
	disccz_o		<- elt(output, "disccz_o")
	discbd_o		<- elt(output, "discbd_o")
	discsl_o		<- elt(output, "discsl_o")
	discct_o		<- elt(output, "discct_o")
	offalpel_o		<- elt(output, "offalpel_o")
	offalmig_o		<- elt(output, "offalmig_o")
	offaldem_quota_o	<- elt(output, "offaldem_quota_o")
	offaldem_nonquota_o	<- elt(output, "offaldem_nonquota_o")
	offalsb_o		<- elt(output, "offalsb_o")
	offalcb_o		<- elt(output, "offalcb_o")
	offalcz_o		<- elt(output, "offalcz_o")
	offalbd_o		<- elt(output, "offalbd_o")
	offalsl_o		<- elt(output, "offalsl_o")
	offalct_o		<- elt(output, "offalct_o")

	# unpack aggregates:
	x_detritus_o		<- elt(aggregates, "x_detritus_o")
	corpse_o		<- elt(aggregates, "corpse_o")
	x_ammonia_o		<- elt(aggregates, "x_ammonia_o")
	x_nitrate_o		<- elt(aggregates, "x_nitrate_o")
	totalN_o		<- elt(aggregates, "totalN_o")
	DIN_NET_flux_o_i	<- elt(aggregates, "DIN_NET_flux_o_i")
	PART_NET_flux_o_i	<- elt(aggregates, "PART_NET_flux_o_i")
	NET_activemigpelfish_o_i<- elt(aggregates, "NET_activemigpelfish_o_i")
	NET_activemigmigfish_o_i<- elt(aggregates, "NET_activemigmigfish_o_i")
	NET_activemigdemfish_o_i<- elt(aggregates, "NET_activemigdemfish_o_i")
	NET_activemigbird_o_i	<- elt(aggregates, "NET_activemigbird_o_i")
	NET_activemigseal_o_i	<- elt(aggregates, "NET_activemigseal_o_i")
	NET_activemigceta_o_i	<- elt(aggregates, "NET_activemigceta_o_i")
	NET_mfish_ext_o		<- elt(aggregates, "NET_mfish_ext_o")
	landd_o			<- elt(aggregates, "landd_o")
	discdem_o		<- elt(aggregates, "discdem_o")
	offaldem_o		<- elt(aggregates, "offaldem_o")

#Derive a load of  stuff from the output and write to a file



#Extract annual average biomass in the final year for the OFFSHORE model domain

aamass_s_detritus<-mean(detritus_so[((nyears-1)*360+1):ndays])
aamass_d_detritus<-mean(detritus_d[((nyears-1)*360+1):ndays])
aamass_x_detritus<-mean(x_detritus_o[((nyears-1)*360+1):ndays]) #Includes both labile and refractory detritus
aamass_xR_detritus<-mean(xR_detritus_d1[((nyears-1)*360+1):ndays]
                       + xR_detritus_d2[((nyears-1)*360+1):ndays]
                       + xR_detritus_d3[((nyears-1)*360+1):ndays])
aamass_discard<-mean(discard_o[((nyears-1)*360+1):ndays])
aamass_corpse<-mean(corpse_o[((nyears-1)*360+1):ndays])

#aamass_kelpdebris<-mean(kelpdebris[((nyears-1)*360+1):ndays])
aamass_kelpdebris<-NA

aamass_s_ammonia<-mean(ammonia_so[((nyears-1)*360+1):ndays])
aamass_d_ammonia<-mean(ammonia_d[((nyears-1)*360+1):ndays])
aamass_x_ammonia<-mean(x_ammonia_o[((nyears-1)*360+1):ndays])
aamass_s_nitrate<-mean(nitrate_so[((nyears-1)*360+1):ndays])
aamass_d_nitrate<-mean(nitrate_d[((nyears-1)*360+1):ndays])
aamass_x_nitrate<-mean(x_nitrate_o[((nyears-1)*360+1):ndays])

#aamass_kelpN<-mean(kelpN[((nyears-1)*360+1):ndays])
aamass_kelpN<-NA

aamass_s_phyt<-mean(phyt_so[((nyears-1)*360+1):ndays])
aamass_d_phyt<-mean(phyt_d[((nyears-1)*360+1):ndays])
aamass_herb<-mean(herb_o[((nyears-1)*360+1):ndays])
aamass_carn<-mean(carn_o[((nyears-1)*360+1):ndays])
aamass_benthslar<-mean(benthslar_o[((nyears-1)*360+1):ndays])
aamass_benths<-mean(benths_o[((nyears-1)*360+1):ndays])
aamass_benthclar<-mean(benthclar_o[((nyears-1)*360+1):ndays])
aamass_benthc<-mean(benthc_o[((nyears-1)*360+1):ndays])
aamass_fishplar<-mean(fishplar_o[((nyears-1)*360+1):ndays])
aamass_fishp<-mean(fishp_o[((nyears-1)*360+1):ndays])
aamass_fishm<-mean(fishm_o[((nyears-1)*360+1):ndays])
aamass_fishdlar<-mean(fishdlar_o[((nyears-1)*360+1):ndays])
aamass_fishd<-mean(fishd_o[((nyears-1)*360+1):ndays])
aamass_bird<-mean(bird_o[((nyears-1)*360+1):ndays])

aamass_seal<-mean(seal_o[((nyears-1)*360+1):ndays])
aamass_ceta<-mean(ceta_o[((nyears-1)*360+1):ndays])

aamass_totalN<-mean(totalN_o[((nyears-1)*360+1):ndays])

#.........................................

mass_results<-data.frame(rep(0,55))

mass_results[1,1]<-aamass_s_detritus
mass_results[2,1]<-aamass_d_detritus
mass_results[3,1]<-aamass_x_detritus
mass_results[4,1]<-aamass_xR_detritus
mass_results[5,1]<-aamass_discard
mass_results[6,1]<-aamass_corpse

mass_results[7,1]<-aamass_kelpdebris

mass_results[8,1]<-aamass_s_ammonia
mass_results[9,1]<-aamass_d_ammonia
mass_results[10,1]<-aamass_x_ammonia
mass_results[11,1]<-aamass_s_nitrate
mass_results[12,1]<-aamass_d_nitrate
mass_results[13,1]<-aamass_x_nitrate

mass_results[14,1]<-aamass_kelpN

mass_results[15,1]<-aamass_s_phyt
mass_results[16,1]<-aamass_d_phyt
mass_results[17,1]<-aamass_herb
mass_results[18,1]<-aamass_carn
mass_results[19,1]<-aamass_benthslar
mass_results[20,1]<-aamass_benths
mass_results[21,1]<-aamass_benthclar
mass_results[22,1]<-aamass_benthc
mass_results[23,1]<-aamass_fishplar
mass_results[24,1]<-aamass_fishp
mass_results[25,1]<-aamass_fishm
mass_results[26,1]<-aamass_fishdlar
mass_results[27,1]<-aamass_fishd
mass_results[28,1]<-aamass_bird

mass_results[29,1]<-aamass_seal
mass_results[30,1]<-aamass_ceta


mass_results[31,1]<-aamass_totalN

mass_results[32,1]<-x_shallowprop
mass_results[33,1]<-si_depth
mass_results[34,1]<-so_depth
mass_results[35,1]<-d_depth

mass_results[36,1]<-x_area_s0

mass_results[37,1]<-x_area_s1
mass_results[38,1]<-x_area_s2
mass_results[39,1]<-x_area_s3

mass_results[40,1]<-x_area_d0

mass_results[41,1]<-x_area_d1
mass_results[42,1]<-x_area_d2
mass_results[43,1]<-x_area_d3
mass_results[44,1]<-x_depth_s1
mass_results[45,1]<-x_depth_s2
mass_results[46,1]<-x_depth_s3
mass_results[47,1]<-x_depth_d1
mass_results[48,1]<-x_depth_d2
mass_results[49,1]<-x_depth_d3
mass_results[50,1]<-x_poros_s1
mass_results[51,1]<-x_poros_s2
mass_results[52,1]<-x_poros_s3
mass_results[53,1]<-x_poros_d1
mass_results[54,1]<-x_poros_d2
mass_results[55,1]<-x_poros_d3


#Text descriptions of units set here for each row of output data
mass_results[,2]<-"mMN_in_the_whole model_domain_(1m2)"
mass_results[c(32,36:43,50:55),2]<-"dimensionless"
mass_results[c(33:35,44:49),2]<-"m"

mass_results[,3]<-mass_results_descriptions
#The vector of text descriptions for each row of output is set in internal.R



colnames(mass_results)<-c("Model_annual_mean","Units","Description")

mass_results


#Print the data to a csv file
#-----------------------------------------------------------------
filename = csvname(resultsdir, "OFFSHORE_model_anav_biomass", identifier)
writecsv(mass_results, filename, row.names=FALSE)

#-------------------------------------------------------------------------------------------------------

#copy the mass_results dataframe as a template for the annual maximum data
maxmass_results<-mass_results
maxmass_results[1:31,1]<-0


aamaxmass_s_detritus<-max(detritus_so[((nyears-1)*360+1):ndays])
aamaxmass_d_detritus<-max(detritus_d[((nyears-1)*360+1):ndays])
aamaxmass_x_detritus<-max(x_detritus_o[((nyears-1)*360+1):ndays]) #Includes both labile and refractory detritus
aamaxmass_xR_detritus<-max(xR_detritus_d1[((nyears-1)*360+1):ndays]
                       + xR_detritus_d2[((nyears-1)*360+1):ndays]
                       + xR_detritus_d3[((nyears-1)*360+1):ndays])
aamaxmass_discard<-max(discard_o[((nyears-1)*360+1):ndays])
aamaxmass_corpse<-max(corpse_o[((nyears-1)*360+1):ndays])

#aamaxmass_kelpdebris<-max(kelpdebris[((nyears-1)*360+1):ndays])
aamaxmass_kelpdebris<-NA

aamaxmass_s_ammonia<-max(ammonia_so[((nyears-1)*360+1):ndays])
aamaxmass_d_ammonia<-max(ammonia_d[((nyears-1)*360+1):ndays])
aamaxmass_x_ammonia<-max(x_ammonia_o[((nyears-1)*360+1):ndays])
aamaxmass_s_nitrate<-max(nitrate_so[((nyears-1)*360+1):ndays])
aamaxmass_d_nitrate<-max(nitrate_d[((nyears-1)*360+1):ndays])
aamaxmass_x_nitrate<-max(x_nitrate_o[((nyears-1)*360+1):ndays])

#aamaxmass_kelpN<-max(kelpN[((nyears-1)*360+1):ndays])
aamaxmass_kelpN<-NA

aamaxmass_s_phyt<-max(phyt_so[((nyears-1)*360+1):ndays])
aamaxmass_d_phyt<-max(phyt_d[((nyears-1)*360+1):ndays])
aamaxmass_herb<-max(herb_o[((nyears-1)*360+1):ndays])
aamaxmass_carn<-max(carn_o[((nyears-1)*360+1):ndays])
aamaxmass_benthslar<-max(benthslar_o[((nyears-1)*360+1):ndays])
aamaxmass_benths<-max(benths_o[((nyears-1)*360+1):ndays])
aamaxmass_benthclar<-max(benthclar_o[((nyears-1)*360+1):ndays])
aamaxmass_benthc<-max(benthc_o[((nyears-1)*360+1):ndays])
aamaxmass_fishplar<-max(fishplar_o[((nyears-1)*360+1):ndays])
aamaxmass_fishp<-max(fishp_o[((nyears-1)*360+1):ndays])
aamaxmass_fishm<-max(fishm_o[((nyears-1)*360+1):ndays])
aamaxmass_fishdlar<-max(fishdlar_o[((nyears-1)*360+1):ndays])
aamaxmass_fishd<-max(fishd_o[((nyears-1)*360+1):ndays])
aamaxmass_bird<-max(bird_o[((nyears-1)*360+1):ndays])

aamaxmass_seal<-max(seal_o[((nyears-1)*360+1):ndays])
aamaxmass_ceta<-max(ceta_o[((nyears-1)*360+1):ndays])

aamaxmass_totalN<-max(totalN_o[((nyears-1)*360+1):ndays])


#..........................................

maxmass_results[1,1]<-aamaxmass_s_detritus
maxmass_results[2,1]<-aamaxmass_d_detritus
maxmass_results[3,1]<-aamaxmass_x_detritus
maxmass_results[4,1]<-aamaxmass_xR_detritus
maxmass_results[5,1]<-aamaxmass_discard
maxmass_results[6,1]<-aamaxmass_corpse

maxmass_results[7,1]<-aamaxmass_kelpdebris

maxmass_results[8,1]<-aamaxmass_s_ammonia
maxmass_results[9,1]<-aamaxmass_d_ammonia
maxmass_results[10,1]<-aamaxmass_x_ammonia
maxmass_results[11,1]<-aamaxmass_s_nitrate
maxmass_results[12,1]<-aamaxmass_d_nitrate
maxmass_results[13,1]<-aamaxmass_x_nitrate

maxmass_results[14,1]<-aamaxmass_kelpN

maxmass_results[15,1]<-aamaxmass_s_phyt
maxmass_results[16,1]<-aamaxmass_d_phyt
maxmass_results[17,1]<-aamaxmass_herb
maxmass_results[18,1]<-aamaxmass_carn
maxmass_results[19,1]<-aamaxmass_benthslar
maxmass_results[20,1]<-aamaxmass_benths
maxmass_results[21,1]<-aamaxmass_benthclar
maxmass_results[22,1]<-aamaxmass_benthc
maxmass_results[23,1]<-aamaxmass_fishplar
maxmass_results[24,1]<-aamaxmass_fishp
maxmass_results[25,1]<-aamaxmass_fishm
maxmass_results[26,1]<-aamaxmass_fishdlar
maxmass_results[27,1]<-aamaxmass_fishd
maxmass_results[28,1]<-aamaxmass_bird

maxmass_results[29,1]<-aamaxmass_seal
maxmass_results[30,1]<-aamaxmass_ceta


maxmass_results[31,1]<-aamaxmass_totalN


colnames(maxmass_results)<-c("Model_annual_maximum","Units","Description")


maxmass_results


#Print the data to a csv file
#-----------------------------------------------------------------
filename = csvname(resultsdir, "OFFSHORE_model_maximum_biomass", identifier)
writecsv(maxmass_results, filename, row.names=FALSE)

#-------------------------------------------------------------------------------------------------------


#copy the mass_results dataframe as a template for the annual minimum data
minmass_results<-mass_results
minmass_results[1:31,1]<-0


aaminmass_s_detritus<-min(detritus_so[((nyears-1)*360+1):ndays])
aaminmass_d_detritus<-min(detritus_d[((nyears-1)*360+1):ndays])
aaminmass_x_detritus<-min(x_detritus_o[((nyears-1)*360+1):ndays]) #Includes both labile and refractory detritus
aaminmass_xR_detritus<-min(xR_detritus_d1[((nyears-1)*360+1):ndays]
                       + xR_detritus_d2[((nyears-1)*360+1):ndays]
                       + xR_detritus_d3[((nyears-1)*360+1):ndays])
aaminmass_discard<-min(discard_o[((nyears-1)*360+1):ndays])
aaminmass_corpse<-min(corpse_o[((nyears-1)*360+1):ndays])

#aaminmass_kelpdebris<-min(kelpdebris[((nyears-1)*360+1):ndays])
aaminmass_kelpdebris<-NA

aaminmass_s_ammonia<-min(ammonia_so[((nyears-1)*360+1):ndays])
aaminmass_d_ammonia<-min(ammonia_d[((nyears-1)*360+1):ndays])
aaminmass_x_ammonia<-min(x_ammonia_o[((nyears-1)*360+1):ndays])
aaminmass_s_nitrate<-min(nitrate_so[((nyears-1)*360+1):ndays])
aaminmass_d_nitrate<-min(nitrate_d[((nyears-1)*360+1):ndays])
aaminmass_x_nitrate<-min(x_nitrate_o[((nyears-1)*360+1):ndays])

#aaminmass_kelpN<-min(kelpN[((nyears-1)*360+1):ndays])
aaminmass_kelpN<-NA

aaminmass_s_phyt<-min(phyt_so[((nyears-1)*360+1):ndays])
aaminmass_d_phyt<-min(phyt_d[((nyears-1)*360+1):ndays])
aaminmass_herb<-min(herb_o[((nyears-1)*360+1):ndays])
aaminmass_carn<-min(carn_o[((nyears-1)*360+1):ndays])
aaminmass_benthslar<-min(benthslar_o[((nyears-1)*360+1):ndays])
aaminmass_benths<-min(benths_o[((nyears-1)*360+1):ndays])
aaminmass_benthclar<-min(benthclar_o[((nyears-1)*360+1):ndays])
aaminmass_benthc<-min(benthc_o[((nyears-1)*360+1):ndays])
aaminmass_fishplar<-min(fishplar_o[((nyears-1)*360+1):ndays])
aaminmass_fishp<-min(fishp_o[((nyears-1)*360+1):ndays])
aaminmass_fishm<-min(fishm_o[((nyears-1)*360+1):ndays])
aaminmass_fishdlar<-min(fishdlar_o[((nyears-1)*360+1):ndays])
aaminmass_fishd<-min(fishd_o[((nyears-1)*360+1):ndays])
aaminmass_bird<-min(bird_o[((nyears-1)*360+1):ndays])

aaminmass_seal<-min(seal_o[((nyears-1)*360+1):ndays])
aaminmass_ceta<-min(ceta_o[((nyears-1)*360+1):ndays])

aaminmass_totalN<-min(totalN_o[((nyears-1)*360+1):ndays])


#..........................................

minmass_results[1,1]<-aaminmass_s_detritus
minmass_results[2,1]<-aaminmass_d_detritus
minmass_results[3,1]<-aaminmass_x_detritus
minmass_results[4,1]<-aaminmass_xR_detritus
minmass_results[5,1]<-aaminmass_discard
minmass_results[6,1]<-aaminmass_corpse

minmass_results[7,1]<-aaminmass_kelpdebris

minmass_results[8,1]<-aaminmass_s_ammonia
minmass_results[9,1]<-aaminmass_d_ammonia
minmass_results[10,1]<-aaminmass_x_ammonia
minmass_results[11,1]<-aaminmass_s_nitrate
minmass_results[12,1]<-aaminmass_d_nitrate
minmass_results[13,1]<-aaminmass_x_nitrate

minmass_results[14,1]<-aaminmass_kelpN

minmass_results[15,1]<-aaminmass_s_phyt
minmass_results[16,1]<-aaminmass_d_phyt
minmass_results[17,1]<-aaminmass_herb
minmass_results[18,1]<-aaminmass_carn
minmass_results[19,1]<-aaminmass_benthslar
minmass_results[20,1]<-aaminmass_benths
minmass_results[21,1]<-aaminmass_benthclar
minmass_results[22,1]<-aaminmass_benthc
minmass_results[23,1]<-aaminmass_fishplar
minmass_results[24,1]<-aaminmass_fishp
minmass_results[25,1]<-aaminmass_fishm
minmass_results[26,1]<-aaminmass_fishdlar
minmass_results[27,1]<-aaminmass_fishd
minmass_results[28,1]<-aaminmass_bird

minmass_results[29,1]<-aaminmass_seal
minmass_results[30,1]<-aaminmass_ceta


minmass_results[31,1]<-aaminmass_totalN


colnames(minmass_results)<-c("Model_annual_minimum","Units","Description")


minmass_results


#Print the data to a csv file
#-----------------------------------------------------------------
filename = csvname(resultsdir, "OFFSHORE_model_minimum_biomass", identifier)
writecsv(minmass_results, filename, row.names=FALSE)

#-------------------------------------------------------------------------------------------------------





#Extract all of the derived rate variables for the final year


DINinflow<-(fluxAMMinflow_o[ndays]-fluxAMMinflow_o[((nyears-1)*360+1)]) + (fluxNITinflow_o[ndays]-fluxNITinflow_o[((nyears-1)*360+1)])
DINoutflow<-(fluxAMMoutflow_o[ndays]-fluxAMMoutflow_o[((nyears-1)*360+1)]) + (fluxNIToutflow_o[ndays]-fluxNIToutflow_o[((nyears-1)*360+1)]) 
PARTinflow<-(fluxPHYTinflow_o[ndays]-fluxPHYTinflow_o[((nyears-1)*360+1)]) + (fluxDETinflow_o[ndays]-fluxDETinflow_o[((nyears-1)*360+1)])
PARToutflow<-(fluxPHYToutflow_o[ndays]-fluxPHYToutflow_o[((nyears-1)*360+1)]) + (fluxDEToutflow_o[ndays]-fluxDEToutflow_o[((nyears-1)*360+1)])
atmosphereDINinput<-(atmosAMMinput_o[ndays]-atmosAMMinput_o[((nyears-1)*360+1)]) + (atmosNITinput_o[ndays]-atmosNITinput_o[((nyears-1)*360+1)])

#riverDINinflow<-(rivAMMinflow[ndays]-rivAMMinflow[((nyears-1)*360+1)]) + (rivNITinflow[ndays]-rivNITinflow[((nyears-1)*360+1)])
#riverPARTinflow<-rivPARTinflow[ndays]-rivPARTinflow[((nyears-1)*360+1)]
riverDINinflow<-0
riverPARTinflow<-0
#!!!!!!

sumDINinflow<-(fluxAMMinflow_o[ndays-90]-fluxAMMinflow_o[((nyears-1)*360+1+89)]) + (fluxNITinflow_o[ndays-90]-fluxNITinflow_o[((nyears-1)*360+1+89)])
sumDINoutflow<-(fluxAMMoutflow_o[ndays-90]-fluxAMMoutflow_o[((nyears-1)*360+1+89)]) + (fluxNIToutflow_o[ndays-90]-fluxNIToutflow_o[((nyears-1)*360+1+89)])
sumPARTinflow<-(fluxPHYTinflow_o[ndays-90]-fluxPHYTinflow_o[((nyears-1)*360+1+89)]) + (fluxDETinflow_o[ndays-90]-fluxDETinflow_o[((nyears-1)*360+1+89)]) 
sumPARToutflow<-(fluxPHYToutflow_o[ndays-90]-fluxPHYToutflow_o[((nyears-1)*360+1+89)]) + (fluxDEToutflow_o[ndays-90]-fluxDEToutflow_o[((nyears-1)*360+1+89)])

#sumriverDINinflow<-(rivAMMinflow[ndays-90]-rivAMMinflow[((nyears-1)*360+1+89)]) + (rivNITinflow[ndays-90]-rivNITinflow[((nyears-1)*360+1+89)])
sumriverDINinflow<-0

sumatmosDINinput<-(atmosAMMinput_o[ndays-90]-atmosAMMinput_o[((nyears-1)*360+1+89)]) + (atmosNITinput_o[ndays-90]-atmosNITinput_o[((nyears-1)*360+1+89)])
surfvertnitflux<-vertnitflux[ndays]-vertnitflux[((nyears-1)*360+1)]
#surfvertnitflux<-NA
#surfhoriznitflux<-horiznitflux[ndays]-horiznitflux[((nyears-1)*360+1)]
surfhoriznitflux<-NA


Flux_sedboundary <- (fluxsedboundary_o[ndays]-fluxsedboundary_o[((nyears-1)*360+1)]) 

#kelp_beachcast<-((fluxkelpdebris_beachexport[ndays]-fluxkelpdebris_beachexport[((nyears-1)*360+1)]))   
kelp_beachcast<-NA

DIN_NET_flux_o_i   <-  DIN_NET_flux_o_i[ndays]-DIN_NET_flux_o_i[((nyears-1)*360+1)]
PART_NET_flux_o_i  <-  PART_NET_flux_o_i[ndays]-PART_NET_flux_o_i[((nyears-1)*360+1)]
NET_activemigpelfish_o_i  <-  NET_activemigpelfish_o_i[ndays]-NET_activemigpelfish_o_i[((nyears-1)*360+1)]

NET_activemigmigfish_o_i  <-  NET_activemigmigfish_o_i[ndays]-NET_activemigmigfish_o_i[((nyears-1)*360+1)]
NET_activemigdemfish_o_i  <-  NET_activemigdemfish_o_i[ndays]-NET_activemigdemfish_o_i[((nyears-1)*360+1)]
NET_activemigbird_o_i  <-  NET_activemigbird_o_i[ndays]-NET_activemigbird_o_i[((nyears-1)*360+1)]
NET_activemigseal_o_i  <-  NET_activemigseal_o_i[ndays]-NET_activemigseal_o_i[((nyears-1)*360+1)]
NET_activemigceta_o_i  <-  NET_activemigceta_o_i[ndays]-NET_activemigceta_o_i[((nyears-1)*360+1)]

NET_mfish_ext_o    <-  NET_mfish_ext_o[ndays]-NET_mfish_ext_o[((nyears-1)*360+1)]

Mfish_annual_imig <-    mfish_imigration[ndays]-mfish_imigration[((nyears-1)*360+1)]
Mfish_annual_emig  <-   mfish_emigration[ndays]-mfish_emigration[((nyears-1)*360+1)]

NETPrimaryP<-netpprod_o[ndays]-netpprod_o[((nyears-1)*360+1)]
MMP<-(max(nitrate_so[((nyears-1)*360+1):ndays]+nitrate_d[((nyears-1)*360+1):ndays])) - (min(nitrate_so[((nyears-1)*360+1):ndays]+nitrate_d[((nyears-1)*360+1):ndays]))
PNP<-PNP_o[ndays]-PNP_o[((nyears-1)*360+1)]
PhytNitUp<-fluxwcnit_phyt_o[ndays]-fluxwcnit_phyt_o[((nyears-1)*360+1)]
PhytAmmUp<-fluxwcamm_phyt_o[ndays]-fluxwcamm_phyt_o[((nyears-1)*360+1)]
NewP<-MMP+sumriverDINinflow+sumatmosDINinput+sumDINinflow-sumDINoutflow
fratio<-NewP/NETPrimaryP
Tfratio<-PhytNitUp/(PhytNitUp+PhytAmmUp)

#KelpNitUp<-fluxwcnit_kelp[ndays]-fluxwcnit_kelp[((nyears-1)*360+1)]
#KelpAmmUp<-fluxwcamm_kelp[ndays]-fluxwcamm_kelp[((nyears-1)*360+1)]
KelpNitUp<-NA
KelpAmmUp<-NA


#KelpNprod       <-   kelpNprod_i[ndays]      -     kelpNprod_i[((nyears-1)*360+1)]
KelpNprod       <-   NA

Phytgrossprod        <-   phytgrossprod_o[ndays]      -     phytgrossprod_o[((nyears-1)*360+1)]

Herbgrossprod        <-   herbgrossprod_o[ndays]      -     herbgrossprod_o[((nyears-1)*360+1)]
Carngrossprod        <-   carngrossprod_o[ndays]      -     carngrossprod_o[((nyears-1)*360+1)]
Fishplargrossprod    <-   pfishlargrossprod_o[ndays]  -     pfishlargrossprod_o[((nyears-1)*360+1)]
Fishdlargrossprod    <-   dfishlargrossprod_o[ndays]  -     dfishlargrossprod_o[((nyears-1)*360+1)]
Fishpgrossprod       <-   pfishgrossprod_o[ndays]     -     pfishgrossprod_o[((nyears-1)*360+1)]
Fishmgrossprod       <-   mfishgrossprod_o[ndays]     -     mfishgrossprod_o[((nyears-1)*360+1)]
Fishdgrossprod       <-   dfishgrossprod_o[ndays]     -     dfishgrossprod_o[((nyears-1)*360+1)]
Benthslargrossprod   <-   benthslargrossprod_o[ndays] -     benthslargrossprod_o[((nyears-1)*360+1)]
Benthclargrossprod   <-   benthclargrossprod_o[ndays] -     benthclargrossprod_o[((nyears-1)*360+1)]
Benthsgrossprod      <-   benthsgrossprod_o[ndays]    -     benthsgrossprod_o[((nyears-1)*360+1)]
Benthcgrossprod      <-   benthcgrossprod_o[ndays]    -     benthcgrossprod_o[((nyears-1)*360+1)]
Birdgrossprod        <-   birdgrossprod_o[ndays]      -     birdgrossprod_o[((nyears-1)*360+1)]
Sealgrossprod        <-   sealgrossprod_o[ndays]      -     sealgrossprod_o[((nyears-1)*360+1)]
Cetagrossprod        <-   cetagrossprod_o[ndays]      -     cetagrossprod_o[((nyears-1)*360+1)]

Herbnetprod        <-   herbnetprod_o[ndays]      -     herbnetprod_o[((nyears-1)*360+1)]
Carnnetprod        <-   carnnetprod_o[ndays]      -     carnnetprod_o[((nyears-1)*360+1)]
Fishplarnetprod    <-   pfishlarnetprod_o[ndays]  -     pfishlarnetprod_o[((nyears-1)*360+1)]
Fishdlarnetprod    <-   dfishlarnetprod_o[ndays]  -     dfishlarnetprod_o[((nyears-1)*360+1)]
Fishpnetprod       <-   pfishnetprod_o[ndays]     -     pfishnetprod_o[((nyears-1)*360+1)]
Fishmnetprod       <-   mfishnetprod_o[ndays]     -     mfishnetprod_o[((nyears-1)*360+1)]
Fishdnetprod       <-   dfishnetprod_o[ndays]     -     dfishnetprod_o[((nyears-1)*360+1)]
Benthslarnetprod   <-   benthslarnetprod_o[ndays] -     benthslarnetprod_o[((nyears-1)*360+1)]
Benthclarnetprod   <-   benthclarnetprod_o[ndays] -     benthclarnetprod_o[((nyears-1)*360+1)]
Benthsnetprod      <-   benthsnetprod_o[ndays]    -     benthsnetprod_o[((nyears-1)*360+1)]
Benthcnetprod      <-   benthcnetprod_o[ndays]    -     benthcnetprod_o[((nyears-1)*360+1)]
Birdnetprod        <-   birdnetprod_o[ndays]      -     birdnetprod_o[((nyears-1)*360+1)]
Sealnetprod        <-   sealnetprod_o[ndays]      -     sealnetprod_o[((nyears-1)*360+1)]
Cetanetprod        <-   cetanetprod_o[ndays]      -     cetanetprod_o[((nyears-1)*360+1)]


#WCdetritusprod      <-   fluxcorp_wcdet[ndays]      -     fluxcorp_wcdet[((nyears-1)*360+1)] +
#                        +fluxkelpdebris_wcdet[ndays]      -     fluxkelpdebris_wcdet[((nyears-1)*360+1)] +
#                        +fluxphyt_wcdet[ndays]      -     fluxphyt_wcdet[((nyears-1)*360+1)] +
#                        +fluxherb_wcdet[ndays]      -     fluxherb_wcdet[((nyears-1)*360+1)] +
#                        +fluxcarn_wcdet[ndays]      -     fluxcarn_wcdet[((nyears-1)*360+1)] +
#                        +fluxpfishlar_wcdet[ndays]      -     fluxpfishlar_wcdet[((nyears-1)*360+1)] +
#                        +fluxdfishlar_wcdet[ndays]      -     fluxdfishlar_wcdet[((nyears-1)*360+1)] +
#                        +fluxpfish_wcdet[ndays]      -     fluxpfish_wcdet[((nyears-1)*360+1)] +
#                        +fluxmfish_wcdet[ndays]      -     fluxmfish_wcdet[((nyears-1)*360+1)] +
#                        +fluxdfish_wcdet[ndays]      -     fluxdfish_wcdet[((nyears-1)*360+1)] +
#                        +fluxbenthslar_wcdet[ndays]      -     fluxbenthslar_wcdet[((nyears-1)*360+1)] +
#                        +fluxbenthclar_wcdet[ndays]      -     fluxbenthclar_wcdet[((nyears-1)*360+1)] +
#                        +fluxbenths_wcdet[ndays]      -     fluxbenths_wcdet[((nyears-1)*360+1)] +
#                        +fluxbenthc_wcdet[ndays]      -     fluxbenthc_wcdet[((nyears-1)*360+1)] +
#                        +fluxbird_wcdet[ndays]      -     fluxbird_wcdet[((nyears-1)*360+1)] +
#                        +fluxseal_wcdet[ndays]      -     fluxseal_wcdet[((nyears-1)*360+1)] +
#                        +fluxceta_wcdet[ndays]      -     fluxceta_wcdet[((nyears-1)*360+1)]
WCdetritusprod      <- NA

#SEDdetritusprod     <-   fluxcorp_xdet[ndays]      -     fluxcorp_xdet[((nyears-1)*360+1)] +
#                        +fluxbenths_xdet[ndays]      -     fluxbenths_xdet[((nyears-1)*360+1)] +
#                        +fluxbenthc_xdet[ndays]      -     fluxbenthc_xdet[((nyears-1)*360+1)]
SEDdetritusprod     <- NA

#Kelpdebrisprod     <-   fluxkelp_kelpdebris[ndays]      -     fluxkelp_kelpdebris[((nyears-1)*360+1)]
Kelpdebrisprod     <- NA

#Corpseprod          <-   fluxdisc_corp[ndays]      -     fluxdisc_corp[((nyears-1)*360+1)] +
#                        +fluxpfish_corp[ndays]      -     fluxpfish_corp[((nyears-1)*360+1)] +
#                        +fluxmfish_corp[ndays]      -     fluxmfish_corp[((nyears-1)*360+1)] +
#                        +fluxdfish_corp[ndays]      -     fluxdfish_corp[((nyears-1)*360+1)] +
#                        +fluxbenths_corp[ndays]      -     fluxbenths_corp[((nyears-1)*360+1)] +
#                        +fluxbenthc_corp[ndays]      -     fluxbenthc_corp[((nyears-1)*360+1)] +
#                        +fluxbird_corp[ndays]      -     fluxbird_corp[((nyears-1)*360+1)] +
#                        +fluxseal_corp[ndays]      -     fluxseal_corp[((nyears-1)*360+1)] +
#                        +fluxceta_corp[ndays]      -     fluxceta_corp[((nyears-1)*360+1)]
Corpseprod <- NA

#Fluxpartwc_sed      <-   fluxwcdet_xdet[ndays]      -     fluxwcdet_xdet[((nyears-1)*360+1)] +
#                        +fluxdisc_corp[ndays]      -     fluxdisc_corp[((nyears-1)*360+1)] +
#                        +fluxpfish_corp[ndays]      -     fluxpfish_corp[((nyears-1)*360+1)] +
#                        +fluxmfish_corp[ndays]      -     fluxmfish_corp[((nyears-1)*360+1)] +
#                        +fluxdfish_corp[ndays]      -     fluxdfish_corp[((nyears-1)*360+1)] +
#                        +fluxbird_corp[ndays]      -     fluxbird_corp[((nyears-1)*360+1)] +
#                        +fluxphyt_benths[ndays]      -     fluxphyt_benths[((nyears-1)*360+1)]+
#                        +fluxwcdet_benths[ndays]      -     fluxwcdet_benths[((nyears-1)*360+1)]
##Includes the water column feeding flux of benthos
Fluxpartwc_sed <- NA

#Fluxdisc_corp       <-   fluxdisc_corp[ndays]      -     fluxdisc_corp[((nyears-1)*360+1)]
Fluxdisc_corp       <- NA

#Pelagammprod        <-   fluxherb_wcamm[ndays]      -     fluxherb_wcamm[((nyears-1)*360+1)] +
#                        +fluxcarn_wcamm[ndays]      -     fluxcarn_wcamm[((nyears-1)*360+1)] +
#                        +fluxpfishlar_wcamm[ndays]      -     fluxpfishlar_wcamm[((nyears-1)*360+1)] +
#                        +fluxdfishlar_wcamm[ndays]      -     fluxdfishlar_wcamm[((nyears-1)*360+1)] +
#                        +fluxpfish_wcamm[ndays]      -     fluxpfish_wcamm[((nyears-1)*360+1)] +
#                        +fluxmfish_wcamm[ndays]      -     fluxmfish_wcamm[((nyears-1)*360+1)] +
#                        +fluxdfish_wcamm[ndays]      -     fluxdfish_wcamm[((nyears-1)*360+1)] +
#                        +fluxbenthslar_wcamm[ndays]      -     fluxbenthslar_wcamm[((nyears-1)*360+1)] +
#                        +fluxbenthclar_wcamm[ndays]      -     fluxbenthclar_wcamm[((nyears-1)*360+1)] +
#                        +fluxbird_wcamm[ndays]      -     fluxbird_wcamm[((nyears-1)*360+1)] + 
#                        +fluxseal_wcamm[ndays]      -     fluxseal_wcamm[((nyears-1)*360+1)] +
#                        +fluxceta_wcamm[ndays]      -     fluxceta_wcamm[((nyears-1)*360+1)] 
##Excludes mineralisation of detritus
Pelagammprod        <- NA

#Benthammprod        <-   fluxbenths_wcamm[ndays]      -     fluxbenths_wcamm[((nyears-1)*360+1)]+
#                        +fluxbenthc_wcamm[ndays]      -     fluxbenthc_wcamm[((nyears-1)*360+1)]
##Excludes mineralisation of detritus
Benthammprod        <- NA

#WCmineralisation    <-   fluxwcdet_wcamm[ndays]      -     fluxwcdet_wcamm[((nyears-1)*360+1)]
WCmineralisation    <- NA

#SEDmineralisation   <-   fluxxdet_sedamm[ndays]      -     fluxxdet_sedamm[((nyears-1)*360+1)]+
#                        +fluxxRdet_sedamm[ndays]      -     fluxxRdet_sedamm[((nyears-1)*360+1)]
SEDmineralisation   <- NA

#WCnitrification     <-   fluxwcamm_wcnit[ndays]      -     fluxwcamm_wcnit[((nyears-1)*360+1)]
WCnitrification     <- NA

#SEDnitrification    <-   fluxsedamm_sednit[ndays]      -     fluxsedamm_sednit[((nyears-1)*360+1)]
SEDnitrification    <- NA

#WCdenitrification   <-   wcdenitrif[ndays]      -     wcdenitrif[((nyears-1)*360+1)]
WCdenitrification   <- NA

#SEDdenitrification  <-   seddenitrif[ndays]      -     seddenitrif[((nyears-1)*360+1)]
SEDdenitrification  <- NA

#SEDWCammflux        <-   fluxsedamm_wcamm[ndays]      -     fluxsedamm_wcamm[((nyears-1)*360+1)]+
#                        +fluxbenths_wcamm[ndays]      -     fluxbenths_wcamm[((nyears-1)*360+1)]+
#                        +fluxbenthc_wcamm[ndays]      -     fluxbenthc_wcamm[((nyears-1)*360+1)]
##Includes excretion by benthos
SEDWCammflux        <- NA


#SEDWCnitflux        <-   fluxsednit_wcnit[ndays]      -     fluxsednit_wcnit[((nyears-1)*360+1)]
SEDWCnitflux        <- NA


#Fluxdet_herb           <-   fluxwcdet_herb[ndays]      -     fluxwcdet_herb[((nyears-1)*360+1)]
#Fluxphyt_herb          <-   fluxphyt_herb[ndays]      -     fluxphyt_herb[((nyears-1)*360+1)]
#Fluxbenthslar_herb          <-   fluxbenthslar_herb[ndays]      -     fluxbenthslar_herb[((nyears-1)*360+1)]
#Fluxbenthclar_herb          <-   fluxbenthclar_herb[ndays]      -     fluxbenthclar_herb[((nyears-1)*360+1)]
Fluxdet_herb           <- NA
Fluxphyt_herb          <- NA
Fluxbenthslar_herb          <- NA
Fluxbenthclar_herb          <- NA


#Fluxherb_carn           <-   fluxherb_carn[ndays]      -     fluxherb_carn[((nyears-1)*360+1)]
#Fluxpfishlar_carn       <-   fluxpfishlar_carn[ndays]      -     fluxpfishlar_carn[((nyears-1)*360+1)]
#Fluxdfishlar_carn       <-   fluxdfishlar_carn[ndays]      -     fluxdfishlar_carn[((nyears-1)*360+1)]   
#Fluxbenthslar_carn       <-   fluxbenthslar_carn[ndays]      -     fluxbenthslar_carn[((nyears-1)*360+1)]    
#Fluxbenthclar_carn       <-   fluxbenthclar_carn[ndays]      -     fluxbenthclar_carn[((nyears-1)*360+1)]    
Fluxherb_carn           <- NA
Fluxpfishlar_carn       <- NA
Fluxdfishlar_carn       <- NA
Fluxbenthslar_carn       <- NA
Fluxbenthclar_carn       <- NA


#Fluxherb_pfishlar           <-   fluxherb_pfishlar[ndays]      -     fluxherb_pfishlar[((nyears-1)*360+1)]   
#Fluxbenthslar_pfishlar        <-   fluxbenthslar_pfishlar[ndays]      -     fluxbenthslar_pfishlar[((nyears-1)*360+1)]   
#Fluxbenthclar_pfishlar        <-   fluxbenthclar_pfishlar[ndays]      -     fluxbenthclar_pfishlar[((nyears-1)*360+1)]   
Fluxherb_pfishlar           <-  NA
Fluxbenthslar_pfishlar        <-  NA
Fluxbenthclar_pfishlar        <-  NA



#Fluxherb_dfishlar           <-   fluxherb_dfishlar[ndays]      -     fluxherb_dfishlar[((nyears-1)*360+1)]   
#Fluxbenthslar_dfishlar        <-   fluxbenthslar_dfishlar[ndays]      -     fluxbenthslar_dfishlar[((nyears-1)*360+1)]   
#Fluxbenthclar_dfishlar        <-   fluxbenthclar_dfishlar[ndays]      -     fluxbenthclar_dfishlar[((nyears-1)*360+1)]   
Fluxherb_dfishlar           <-  NA
Fluxbenthslar_dfishlar        <- NA
Fluxbenthclar_dfishlar        <- NA



#Fluxherb_pfish            <-   fluxherb_pfish[ndays]      -     fluxherb_pfish[((nyears-1)*360+1)]     
#Fluxcarn_pfish            <-   fluxcarn_pfish[ndays]      -     fluxcarn_pfish[((nyears-1)*360+1)]     
#Fluxpfishlar_pfish        <-   fluxpfishlar_pfish[ndays]      -     fluxpfishlar_pfish[((nyears-1)*360+1)]     
#Fluxdfishlar_pfish        <-   fluxdfishlar_pfish[ndays]      -     fluxdfishlar_pfish[((nyears-1)*360+1)]     
#Fluxbenthslar_pfish         <-   fluxbenthslar_pfish[ndays]      -     fluxbenthslar_pfish[((nyears-1)*360+1)]     
#Fluxbenthclar_pfish         <-   fluxbenthclar_pfish[ndays]      -     fluxbenthclar_pfish[((nyears-1)*360+1)]     
Fluxherb_pfish            <-  NA
Fluxcarn_pfish            <-  NA
Fluxpfishlar_pfish        <-  NA
Fluxdfishlar_pfish        <-  NA
Fluxbenthslar_pfish         <- NA
Fluxbenthclar_pfish         <-  NA



#Fluxherb_mfish            <-   fluxherb_mfish[ndays]      -     fluxherb_mfish[((nyears-1)*360+1)]     
#Fluxcarn_mfish            <-   fluxcarn_mfish[ndays]      -     fluxcarn_mfish[((nyears-1)*360+1)]     
#Fluxpfishlar_mfish        <-   fluxpfishlar_mfish[ndays]      -     fluxpfishlar_mfish[((nyears-1)*360+1)]     
#Fluxdfishlar_mfish        <-   fluxdfishlar_mfish[ndays]      -     fluxdfishlar_mfish[((nyears-1)*360+1)]     
#Fluxbenthslar_mfish       <-   fluxbenthslar_mfish[ndays]      -     fluxbenthslar_mfish[((nyears-1)*360+1)]     
#Fluxbenthclar_mfish       <-   fluxbenthclar_mfish[ndays]      -     fluxbenthclar_mfish[((nyears-1)*360+1)]     
Fluxherb_mfish            <- NA
Fluxcarn_mfish            <- NA
Fluxpfishlar_mfish        <- NA
Fluxdfishlar_mfish        <- NA
Fluxbenthslar_mfish       <- NA
Fluxbenthclar_mfish       <- NA



#Fluxcorp_dfish            <-   fluxcorp_dfish[ndays]      -     fluxcorp_dfish[((nyears-1)*360+1)]     
#Fluxdisc_dfish            <-   fluxdisc_dfish[ndays]      -     fluxdisc_dfish[((nyears-1)*360+1)]     
#Fluxcarn_dfish            <-   fluxcarn_dfish[ndays]      -     fluxcarn_dfish[((nyears-1)*360+1)]     
#Fluxpfishlar_dfish        <-   fluxpfishlar_dfish[ndays]      -     fluxpfishlar_dfish[((nyears-1)*360+1)]     
#Fluxdfishlar_dfish        <-   fluxdfishlar_dfish[ndays]      -     fluxdfishlar_dfish[((nyears-1)*360+1)]     
#Fluxpfish_dfish           <-   fluxpfish_dfish[ndays]      -     fluxpfish_dfish[((nyears-1)*360+1)]     
#Fluxmfish_dfish           <-   fluxmfish_dfish[ndays]      -     fluxmfish_dfish[((nyears-1)*360+1)]     
#Fluxdfish_dfish           <-   fluxdfish_dfish[ndays]      -     fluxdfish_dfish[((nyears-1)*360+1)]     
#Fluxbenths_dfish          <-   fluxbenths_dfish[ndays]      -     fluxbenths_dfish[((nyears-1)*360+1)]     
#Fluxbenthc_dfish          <-   fluxbenthc_dfish[ndays]      -     fluxbenthc_dfish[((nyears-1)*360+1)]     
Fluxcorp_dfish            <-  NA
Fluxdisc_dfish            <-  NA
Fluxcarn_dfish            <-  NA
Fluxpfishlar_dfish        <-  NA
Fluxdfishlar_dfish        <-  NA
Fluxpfish_dfish           <-  NA
Fluxmfish_dfish           <-  NA
Fluxdfish_dfish           <-  NA
Fluxbenths_dfish          <-  NA
Fluxbenthc_dfish          <-  NA


#Fluxdet_benthslar            <-   fluxwcdet_benthslar[ndays]      -     fluxwcdet_benthslar[((nyears-1)*360+1)]  
#Fluxphyt_benthslar           <-   fluxphyt_benthslar[ndays]      -     fluxphyt_benthslar[((nyears-1)*360+1)]    
Fluxdet_benthslar            <-  NA
Fluxphyt_benthslar           <-  NA

#Fluxdet_benthclar            <-   fluxwcdet_benthclar[ndays]      -     fluxwcdet_benthclar[((nyears-1)*360+1)]  
#Fluxphyt_benthclar           <-   fluxphyt_benthclar[ndays]      -     fluxphyt_benthclar[((nyears-1)*360+1)]  
Fluxdet_benthclar            <- NA
Fluxphyt_benthclar           <- NA

#Fluxdet_benths             <-   fluxwcdet_benths[ndays]      -     fluxwcdet_benths[((nyears-1)*360+1)]    
#Fluxseddet_benths          <-   fluxxdet_benths[ndays]      -     fluxxdet_benths[((nyears-1)*360+1)] +   
#Fluxphyt_benths            <-   fluxphyt_benths[ndays]      -     fluxphyt_benths[((nyears-1)*360+1)]    
Fluxdet_benths             <- NA
Fluxseddet_benths          <- NA
Fluxphyt_benths            <- NA

#Fluxkelp_benthc            <-   fluxkelp_benthc[ndays]      -     fluxkelp_benthc[((nyears-1)*360+1)]    
#Fluxkelpdebris_benthc            <-   fluxkelpdebris_benthc[ndays]      -     fluxkelpdebris_benthc[((nyears-1)*360+1)]    
#Fluxcorp_benthc            <-   fluxcorp_benthc[ndays]      -     fluxcorp_benthc[((nyears-1)*360+1)]    
#Fluxbenths_benthc          <-   fluxbenths_benthc[ndays]      -     fluxbenths_benthc[((nyears-1)*360+1)]    
Fluxkelp_benthc            <- NA
Fluxkelpdebris_benthc            <- NA
Fluxcorp_benthc            <- NA
Fluxbenths_benthc          <- NA


#Fluxcorp_bird            <-   fluxcorp_bird[ndays]      -     fluxcorp_bird[((nyears-1)*360+1)]      
#Fluxdisc_bird            <-   fluxdisc_bird[ndays]      -     fluxdisc_bird[((nyears-1)*360+1)]      
##Fluxherb_bird            <-   fluxherb_bird[ndays]      -     fluxherb_bird[((nyears-1)*360+1)]      
#Fluxcarn_bird            <-   fluxcarn_bird[ndays]      -     fluxcarn_bird[((nyears-1)*360+1)]      
#Fluxpfish_bird           <-   fluxpfish_bird[ndays]      -     fluxpfish_bird[((nyears-1)*360+1)]      
#Fluxmfish_bird           <-   fluxmfish_bird[ndays]      -     fluxmfish_bird[((nyears-1)*360+1)]      
#Fluxdfish_bird           <-   fluxdfish_bird[ndays]      -     fluxdfish_bird[((nyears-1)*360+1)]      
#Fluxbenths_bird          <-   fluxbenths_bird[ndays]      -     fluxbenths_bird[((nyears-1)*360+1)]      
#Fluxbenthc_bird          <-   fluxbenthc_bird[ndays]      -     fluxbenthc_bird[((nyears-1)*360+1)]      

Fluxcorp_bird            <-  NA
Fluxdisc_bird            <-  NA
#Fluxherb_bird            <- NA
Fluxcarn_bird            <-  NA
Fluxpfish_bird           <-  NA
Fluxmfish_bird           <-  NA
Fluxdfish_bird           <-  NA
Fluxbenths_bird          <-  NA
Fluxbenthc_bird          <-  NA


     
#Fluxcorp_seal            <-   fluxcorp_seal[ndays]      -     fluxcorp_seal[((nyears-1)*360+1)]      
#Fluxdisc_seal            <-   fluxdisc_seal[ndays]      -     fluxdisc_seal[((nyears-1)*360+1)]      
#Fluxcarn_seal            <-   fluxcarn_seal[ndays]      -     fluxcarn_seal[((nyears-1)*360+1)]      
#Fluxpfish_seal           <-   fluxpfish_seal[ndays]      -     fluxpfish_seal[((nyears-1)*360+1)]      
#Fluxmfish_seal           <-   fluxmfish_seal[ndays]      -     fluxmfish_seal[((nyears-1)*360+1)]      
#Fluxdfish_seal           <-   fluxdfish_seal[ndays]      -     fluxdfish_seal[((nyears-1)*360+1)]      
#Fluxbenths_seal          <-   fluxbenths_seal[ndays]      -     fluxbenths_seal[((nyears-1)*360+1)]      
#Fluxbenthc_seal          <-   fluxbenthc_seal[ndays]      -     fluxbenthc_seal[((nyears-1)*360+1)]      
#Fluxbird_seal          <-   fluxbird_seal[ndays]      -     fluxbird_seal[((nyears-1)*360+1)]      
Fluxcorp_seal            <- NA
Fluxdisc_seal            <- NA
Fluxcarn_seal            <- NA
Fluxpfish_seal           <- NA
Fluxmfish_seal           <- NA
Fluxdfish_seal           <- NA
Fluxbenths_seal          <- NA
Fluxbenthc_seal          <- NA
Fluxbird_seal          <-   NA


#Fluxdisc_ceta            <-   fluxdisc_ceta[ndays]      -     fluxdisc_ceta[((nyears-1)*360+1)]      
#Fluxherb_ceta            <-   fluxherb_ceta[ndays]      -     fluxherb_ceta[((nyears-1)*360+1)]      
#Fluxcarn_ceta            <-   fluxcarn_ceta[ndays]      -     fluxcarn_ceta[((nyears-1)*360+1)]      
#Fluxpfish_ceta           <-   fluxpfish_ceta[ndays]      -     fluxpfish_ceta[((nyears-1)*360+1)]      
#Fluxmfish_ceta           <-   fluxmfish_ceta[ndays]      -     fluxmfish_ceta[((nyears-1)*360+1)]      
#Fluxdfish_ceta           <-   fluxdfish_ceta[ndays]      -     fluxdfish_ceta[((nyears-1)*360+1)]      
#Fluxbenths_ceta          <-   fluxbenths_ceta[ndays]      -     fluxbenths_ceta[((nyears-1)*360+1)]      
#Fluxbenthc_ceta          <-   fluxbenthc_ceta[ndays]      -     fluxbenthc_ceta[((nyears-1)*360+1)]      
#Fluxbird_ceta            <-   fluxbird_ceta[ndays]      -     fluxbird_ceta[((nyears-1)*360+1)]      
#Fluxseal_ceta            <-   fluxseal_ceta[ndays]      -     fluxseal_ceta[((nyears-1)*360+1)]      
Fluxdisc_ceta            <-  NA
Fluxherb_ceta            <-  NA
Fluxcarn_ceta            <-  NA
Fluxpfish_ceta           <-  NA
Fluxmfish_ceta           <-  NA
Fluxdfish_ceta           <-  NA
Fluxbenths_ceta          <-  NA
Fluxbenthc_ceta          <-  NA
Fluxbird_ceta            <-  NA
Fluxseal_ceta            <-  NA

HTLP<-   Herbnetprod +
       + Carnnetprod +
       + Benthsnetprod +
       + Benthcnetprod +
       + Benthslarnetprod +
       + Benthclarnetprod +
       + Fishplarnetprod +
       + Fishdlarnetprod +
       + Fishpnetprod +
       + Fishmnetprod +
       + Fishdnetprod +
       + Birdnetprod +
       + Sealnetprod +
       + Cetanetprod 


#export_from_2prod<-  Fluxherb_carn +
#                   + Fluxherb_pfishlar + 
#                   + Fluxherb_dfishlar +
#                   + Fluxherb_pfish +
#                   + Fluxherb_ceta +
#                   + Fluxbenths_dfish +
#                   + Fluxbenths_benthc +
#                   + Fluxbenths_bird +
#                   + Fluxbenths_seal +
#                   + Fluxbenths_ceta
export_from_2prod<- NA

#Pfish_annual_spawn   <- Pfish_spawn[ndays]-Pfish_spawn[((nyears-1)*360+1)]
#Pfish_annual_recruit <- Pfish_recruit[ndays]-Pfish_recruit[((nyears-1)*360+1)]
#Dfish_annual_spawn   <- Dfish_spawn[ndays]-Dfish_spawn[((nyears-1)*360+1)]
#Dfish_annual_recruit <- Dfish_recruit[ndays]-Dfish_recruit[((nyears-1)*360+1)]
Pfish_annual_spawn   <- NA
Pfish_annual_recruit <- NA
Dfish_annual_spawn   <- NA
Dfish_annual_recruit <- NA



#Benths_annual_spawn   <- Bs_spawn[ndays]-Bs_spawn[((nyears-1)*360+1)]
#Benths_annual_recruit <- Bs_recruit[ndays]-Bs_recruit[((nyears-1)*360+1)]
#Benthc_annual_spawn   <- Bc_spawn[ndays]-Bc_spawn[((nyears-1)*360+1)]
#Benthc_annual_recruit <- Bc_recruit[ndays]-Bc_recruit[((nyears-1)*360+1)]
Benths_annual_spawn   <- NA
Benths_annual_recruit <- NA
Benthc_annual_spawn   <- NA
Benthc_annual_recruit <- NA



FishpLand_livewt<-landp_o[ndays]-landp_o[((nyears-1)*360+1)]
FishmLand_livewt<-landm_o[ndays]-landm_o[((nyears-1)*360+1)]
FishdLand_livewt<-landd_o[ndays]-landd_o[((nyears-1)*360+1)]
Fishd_qLand_livewt<-landd_quota_o[ndays]-landd_quota_o[((nyears-1)*360+1)]
Fishd_nqLand_livewt<-landd_nonquota_o[ndays]-landd_nonquota_o[((nyears-1)*360+1)]
BenthsLand_livewt <- landsb_o[ndays]-landsb_o[((nyears-1)*360+1)]
BenthcLand_livewt <- landcb_o[ndays]-landcb_o[((nyears-1)*360+1)]
CarnzLand_livewt <- landcz_o[ndays]-landcz_o[((nyears-1)*360+1)]
BirdLand_livewt <- landbd_o[ndays]-landbd_o[((nyears-1)*360+1)]
SealLand_livewt <- landsl_o[ndays]-landsl_o[((nyears-1)*360+1)]
CetaLand_livewt <- landct_o[ndays]-landct_o[((nyears-1)*360+1)]
#KelpLand_livewt <- landkp_i[ndays]-landkp_i[((nyears-1)*360+1)]
KelpLand_livewt <- NA

FishpDiscard<-discpel_o[ndays]-discpel_o[((nyears-1)*360+1)]
FishmDiscard<-discmig_o[ndays]-discmig_o[((nyears-1)*360+1)]
FishdDiscard<-discdem_o[ndays]-discdem_o[((nyears-1)*360+1)]
Fishd_qDiscard<-discdem_quota_o[ndays]-discdem_quota_o[((nyears-1)*360+1)]
Fishd_nqDiscard<-discdem_nonquota_o[ndays]-discdem_nonquota_o[((nyears-1)*360+1)]
BenthsDiscard <- discsb_o[ndays]-discsb_o[((nyears-1)*360+1)]
BenthcDiscard <- disccb_o[ndays]-disccb_o[((nyears-1)*360+1)]
CarnzDiscard  <- disccz_o[ndays]-disccz_o[((nyears-1)*360+1)]
BirdDiscard   <- discbd_o[ndays]-discbd_o[((nyears-1)*360+1)]
SealDiscard   <- discsl_o[ndays]-discsl_o[((nyears-1)*360+1)]
CetaDiscard   <- discct_o[ndays]-discct_o[((nyears-1)*360+1)]
#KelpDiscard   <- disckp_i[ndays]-disckp_i[((nyears-1)*360+1)]
KelpDiscard   <- NA

FishpOffal<-offalpel_o[ndays]-offalpel_o[((nyears-1)*360+1)]
FishmOffal<-offalmig_o[ndays]-offalmig_o[((nyears-1)*360+1)]
FishdOffal<-offaldem_o[ndays]-offaldem_o[((nyears-1)*360+1)]
Fishd_qOffal<-offaldem_quota_o[ndays]-offaldem_quota_o[((nyears-1)*360+1)]
Fishd_nqOffal<-offaldem_nonquota_o[ndays]-offaldem_nonquota_o[((nyears-1)*360+1)]
BenthsOffal <- offalsb_o[ndays]-offalsb_o[((nyears-1)*360+1)]
BenthcOffal <- offalcb_o[ndays]-offalcb_o[((nyears-1)*360+1)]
CarnzOffal  <- offalcz_o[ndays]-offalcz_o[((nyears-1)*360+1)]
BirdOffal   <- offalbd_o[ndays]-offalbd_o[((nyears-1)*360+1)]
SealOffal   <- offalsl_o[ndays]-offalsl_o[((nyears-1)*360+1)]
CetaOffal   <- offalct_o[ndays]-offalct_o[((nyears-1)*360+1)]
#KelpOffal   <- offalkp_i[ndays]-offalkp_i[((nyears-1)*360+1)]
KelpOffal   <- NA

FishpLand_processedwt<- FishpLand_livewt - FishpOffal
FishmLand_processedwt<- FishmLand_livewt - FishmOffal
FishdLand_processedwt<- FishdLand_livewt - FishdOffal
Fishd_qLand_processedwt<- Fishd_qLand_livewt - Fishd_qOffal
Fishd_nqLand_processedwt<- Fishd_nqLand_livewt - Fishd_nqOffal
BenthsLand_processedwt <- BenthsLand_livewt - BenthsOffal
BenthcLand_processedwt <- BenthcLand_livewt - BenthcOffal
CarnzLand_processedwt <- CarnzLand_livewt - CarnzOffal
BirdLand_processedwt <- BirdLand_livewt - BirdOffal
SealLand_processedwt <- SealLand_livewt - SealOffal
CetaLand_processedwt <- CetaLand_livewt - CetaOffal
#KelpLand_processedwt <- KelpLand_livewt - KelpOffal
KelpLand_processedwt <- NA



annual_flux_results<-data.frame(rep(0,240))

#EXTRACT THE RESULTS INTO A DATA FRAME
#COLUMN 1 IS IN NITROGEN UNITS (mM N/m2/y)

#DERIVED ANNUAL VALUES IN UNITS OF mM N/m2 and fluxes in mMN/m2/y

annual_flux_results[1,1]<-DINinflow
annual_flux_results[2,1]<-DINoutflow
annual_flux_results[3,1]<-PARTinflow
annual_flux_results[4,1]<-PARToutflow
annual_flux_results[5,1]<-atmosphereDINinput
annual_flux_results[6,1]<-riverDINinflow
annual_flux_results[7,1]<-riverPARTinflow
annual_flux_results[8,1]<-sumDINinflow
annual_flux_results[9,1]<-sumDINoutflow
annual_flux_results[10,1]<-sumPARTinflow
annual_flux_results[11,1]<-sumPARToutflow
annual_flux_results[12,1]<-sumriverDINinflow
annual_flux_results[13,1]<-sumatmosDINinput
annual_flux_results[14,1]<-surfvertnitflux
annual_flux_results[15,1]<-surfhoriznitflux
annual_flux_results[16,1]<-Flux_sedboundary

annual_flux_results[17,1]<-kelp_beachcast


annual_flux_results[18,1]<-DIN_NET_flux_o_i
annual_flux_results[19,1]<-PART_NET_flux_o_i
annual_flux_results[20,1]<-NET_activemigpelfish_o_i

annual_flux_results[21,1]<-NET_activemigmigfish_o_i
annual_flux_results[22,1]<-NET_activemigdemfish_o_i
annual_flux_results[23,1]<-NET_activemigbird_o_i
annual_flux_results[24,1]<-NET_activemigseal_o_i
annual_flux_results[25,1]<-NET_activemigceta_o_i

annual_flux_results[26,1]<-NET_mfish_ext_o 
annual_flux_results[27,1]<-Mfish_annual_imig
annual_flux_results[28,1]<-Mfish_annual_emig
annual_flux_results[29,1]<-NETPrimaryP
annual_flux_results[30,1]<-MMP
annual_flux_results[31,1]<-PNP
annual_flux_results[32,1]<-PhytNitUp
annual_flux_results[33,1]<-PhytAmmUp
annual_flux_results[34,1]<-NewP
annual_flux_results[35,1]<-fratio
annual_flux_results[36,1]<-Tfratio

annual_flux_results[37,1]<-KelpNitUp
annual_flux_results[38,1]<-KelpAmmUp

annual_flux_results[39,1]<-KelpNprod


annual_flux_results[40,1]<-Phytgrossprod

annual_flux_results[41,1]<-Herbgrossprod
annual_flux_results[42,1]<-Carngrossprod
annual_flux_results[43,1]<-Fishplargrossprod
annual_flux_results[44,1]<-Fishdlargrossprod
annual_flux_results[45,1]<-Fishpgrossprod 
annual_flux_results[46,1]<-Fishmgrossprod 
annual_flux_results[47,1]<-Fishdgrossprod 
annual_flux_results[48,1]<-Benthslargrossprod 
annual_flux_results[49,1]<-Benthclargrossprod 
annual_flux_results[50,1]<-Benthsgrossprod    
annual_flux_results[51,1]<-Benthcgrossprod    
annual_flux_results[52,1]<-Birdgrossprod
annual_flux_results[53,1]<-Sealgrossprod
annual_flux_results[54,1]<-Cetagrossprod

annual_flux_results[55,1]<-Herbnetprod
annual_flux_results[56,1]<-Carnnetprod
annual_flux_results[57,1]<-Fishplarnetprod
annual_flux_results[58,1]<-Fishdlarnetprod
annual_flux_results[59,1]<-Fishpnetprod 
annual_flux_results[60,1]<-Fishmnetprod 
annual_flux_results[61,1]<-Fishdnetprod 
annual_flux_results[62,1]<-Benthslarnetprod 
annual_flux_results[63,1]<-Benthclarnetprod 
annual_flux_results[64,1]<-Benthsnetprod    
annual_flux_results[65,1]<-Benthcnetprod    
annual_flux_results[66,1]<-Birdnetprod
annual_flux_results[67,1]<-Sealnetprod
annual_flux_results[68,1]<-Cetanetprod


      
annual_flux_results[69,1]<-WCdetritusprod  
annual_flux_results[70,1]<-SEDdetritusprod 
annual_flux_results[71,1]<-Corpseprod      
annual_flux_results[72,1]<-Fluxpartwc_sed  
annual_flux_results[73,1]<-Fluxdisc_corp   
annual_flux_results[74,1]<-Pelagammprod    
annual_flux_results[75,1]<-Benthammprod    
annual_flux_results[76,1]<-WCmineralisation
annual_flux_results[77,1]<-SEDmineralisation
annual_flux_results[78,1]<-WCnitrification  
annual_flux_results[79,1]<-SEDnitrification 
annual_flux_results[80,1]<-WCdenitrification
annual_flux_results[81,1]<-SEDdenitrification
annual_flux_results[82,1]<-SEDWCammflux      
annual_flux_results[83,1]<-SEDWCnitflux      
annual_flux_results[84,1]<-Fluxdet_herb    
annual_flux_results[85,1]<-Fluxphyt_herb   
annual_flux_results[85,1]<-Fluxbenthslar_herb 
annual_flux_results[87,1]<-Fluxbenthclar_herb 
annual_flux_results[88,1]<-Fluxherb_carn      
annual_flux_results[89,1]<-Fluxpfishlar_carn  
annual_flux_results[90,1]<-Fluxdfishlar_carn  
annual_flux_results[91,1]<-Fluxbenthslar_carn   
annual_flux_results[92,1]<-Fluxbenthclar_carn   
annual_flux_results[93,1]<-Fluxherb_pfishlar   
annual_flux_results[94,1]<-Fluxbenthslar_pfishlar
annual_flux_results[95,1]<-Fluxbenthclar_pfishlar
annual_flux_results[96,1]<-Fluxherb_dfishlar   
annual_flux_results[97,1]<-Fluxbenthslar_dfishlar
annual_flux_results[98,1]<-Fluxbenthclar_dfishlar
annual_flux_results[99,1]<-Fluxherb_pfish       
annual_flux_results[100,1]<-Fluxcarn_pfish       
annual_flux_results[101,1]<-Fluxpfishlar_pfish   
annual_flux_results[102,1]<-Fluxdfishlar_pfish   
annual_flux_results[103,1]<-Fluxbenthslar_pfish    
annual_flux_results[104,1]<-Fluxbenthclar_pfish    
annual_flux_results[105,1]<-Fluxherb_mfish      
annual_flux_results[106,1]<-Fluxcarn_mfish      
annual_flux_results[107,1]<-Fluxpfishlar_mfish  
annual_flux_results[108,1]<-Fluxdfishlar_mfish  
annual_flux_results[109,1]<-Fluxbenthslar_mfish 
annual_flux_results[110,1]<-Fluxbenthclar_mfish 
annual_flux_results[111,1]<-Fluxcorp_dfish      
annual_flux_results[112,1]<-Fluxdisc_dfish
annual_flux_results[113,1]<-Fluxcarn_dfish      
annual_flux_results[114,1]<-Fluxpfishlar_dfish  
annual_flux_results[115,1]<-Fluxdfishlar_dfish  
annual_flux_results[116,1]<-Fluxpfish_dfish     
annual_flux_results[117,1]<-Fluxmfish_dfish     
annual_flux_results[118,1]<-Fluxdfish_dfish     
annual_flux_results[119,1]<-Fluxbenths_dfish    
annual_flux_results[120,1]<-Fluxbenthc_dfish    
annual_flux_results[121,1]<-Fluxdet_benthslar   
annual_flux_results[122,1]<-Fluxphyt_benthslar  
annual_flux_results[123,1]<-Fluxdet_benthclar   
annual_flux_results[124,1]<-Fluxphyt_benthclar  
annual_flux_results[125,1]<-Fluxdet_benths      
annual_flux_results[126,1]<-Fluxseddet_benths   
annual_flux_results[127,1]<-Fluxphyt_benths     
annual_flux_results[128,1]<-Fluxkelpdebris_benthc     
annual_flux_results[129,1]<-Fluxcorp_benthc     
annual_flux_results[130,1]<-Fluxkelp_benthc     
annual_flux_results[131,1]<-Fluxbenths_benthc   
annual_flux_results[132,1]<-Fluxcorp_bird       
annual_flux_results[133,1]<-Fluxdisc_bird       

#annual_flux_results[xxx,1]<-Fluxherb_bird       

annual_flux_results[134,1]<-Fluxcarn_bird       
annual_flux_results[135,1]<-Fluxpfish_bird      
annual_flux_results[136,1]<-Fluxmfish_bird      
annual_flux_results[137,1]<-Fluxdfish_bird      
annual_flux_results[138,1]<-Fluxbenths_bird     
annual_flux_results[139,1]<-Fluxbenthc_bird     
annual_flux_results[140,1]<-Fluxcorp_seal       
annual_flux_results[141,1]<-Fluxdisc_seal       
annual_flux_results[142,1]<-Fluxcarn_seal       
annual_flux_results[143,1]<-Fluxpfish_seal      
annual_flux_results[144,1]<-Fluxmfish_seal      
annual_flux_results[145,1]<-Fluxdfish_seal      
annual_flux_results[146,1]<-Fluxbenths_seal     
annual_flux_results[147,1]<-Fluxbenthc_seal     
annual_flux_results[148,1]<-Fluxbird_seal     
annual_flux_results[149,1]<-Fluxdisc_ceta       
annual_flux_results[150,1]<-Fluxherb_ceta       
annual_flux_results[151,1]<-Fluxcarn_ceta       
annual_flux_results[152,1]<-Fluxpfish_ceta      
annual_flux_results[153,1]<-Fluxmfish_ceta      
annual_flux_results[154,1]<-Fluxdfish_ceta      
annual_flux_results[155,1]<-Fluxbenths_ceta     
annual_flux_results[156,1]<-Fluxbenthc_ceta     
annual_flux_results[157,1]<-Fluxbird_ceta     
annual_flux_results[158,1]<-Fluxseal_ceta     

annual_flux_results[159,1]<-HTLP
annual_flux_results[160,1]<-export_from_2prod
annual_flux_results[161,1]<-Pfish_annual_spawn   
annual_flux_results[162,1]<-Pfish_annual_recruit 
annual_flux_results[163,1]<-Dfish_annual_spawn   
annual_flux_results[164,1]<-Dfish_annual_recruit 
annual_flux_results[165,1]<-Benths_annual_spawn   
annual_flux_results[166,1]<-Benths_annual_recruit 
annual_flux_results[167,1]<-Benthc_annual_spawn   
annual_flux_results[168,1]<-Benthc_annual_recruit 

annual_flux_results[169,1]<-FishpLand_livewt
annual_flux_results[170,1]<-FishmLand_livewt
annual_flux_results[171,1]<-FishdLand_livewt
annual_flux_results[172,1]<-Fishd_qLand_livewt
annual_flux_results[173,1]<-Fishd_nqLand_livewt
annual_flux_results[174,1]<-BenthsLand_livewt
annual_flux_results[175,1]<-BenthcLand_livewt 
annual_flux_results[176,1]<-CarnzLand_livewt 
annual_flux_results[177,1]<-BirdLand_livewt 
annual_flux_results[178,1]<-SealLand_livewt 
annual_flux_results[179,1]<-CetaLand_livewt 
annual_flux_results[180,1]<-KelpLand_livewt 

annual_flux_results[181,1]<-FishpDiscard
annual_flux_results[182,1]<-FishmDiscard
annual_flux_results[183,1]<-FishdDiscard
annual_flux_results[184,1]<-Fishd_qDiscard
annual_flux_results[185,1]<-Fishd_nqDiscard
annual_flux_results[186,1]<-BenthsDiscard
annual_flux_results[187,1]<-BenthcDiscard
annual_flux_results[188,1]<-CarnzDiscard 
annual_flux_results[189,1]<-BirdDiscard
annual_flux_results[190,1]<-SealDiscard
annual_flux_results[191,1]<-CetaDiscard
annual_flux_results[192,1]<-KelpDiscard

annual_flux_results[193,1]<-FishpOffal
annual_flux_results[194,1]<-FishmOffal
annual_flux_results[195,1]<-FishdOffal
annual_flux_results[196,1]<-Fishd_qOffal
annual_flux_results[197,1]<-Fishd_nqOffal
annual_flux_results[198,1]<-BenthsOffal
annual_flux_results[199,1]<-BenthcOffal
annual_flux_results[200,1]<-CarnzOffal 
annual_flux_results[201,1]<-BirdOffal
annual_flux_results[202,1]<-SealOffal
annual_flux_results[203,1]<-CetaOffal
annual_flux_results[204,1]<-KelpOffal

annual_flux_results[205,1]<-FishpLand_processedwt
annual_flux_results[206,1]<-FishmLand_processedwt
annual_flux_results[207,1]<-FishdLand_processedwt
annual_flux_results[208,1]<-Fishd_qLand_processedwt
annual_flux_results[209,1]<-Fishd_nqLand_processedwt
annual_flux_results[210,1]<-BenthsLand_processedwt
annual_flux_results[211,1]<-BenthcLand_processedwt 
annual_flux_results[212,1]<-CarnzLand_processedwt 
annual_flux_results[213,1]<-BirdLand_processedwt 
annual_flux_results[214,1]<-SealLand_processedwt 
annual_flux_results[215,1]<-CetaLand_processedwt 
annual_flux_results[216,1]<-KelpLand_processedwt 

annual_flux_results[217,1]<-x_shallowprop
annual_flux_results[218,1]<-si_depth
annual_flux_results[219,1]<-so_depth
annual_flux_results[220,1]<-d_depth

annual_flux_results[221,1]<-x_area_s0

annual_flux_results[222,1]<-x_area_s1
annual_flux_results[223,1]<-x_area_s2
annual_flux_results[224,1]<-x_area_s3

annual_flux_results[225,1]<-x_area_d0

annual_flux_results[226,1]<-x_area_d1
annual_flux_results[227,1]<-x_area_d2
annual_flux_results[228,1]<-x_area_d3
annual_flux_results[229,1]<-x_depth_s1
annual_flux_results[230,1]<-x_depth_s2
annual_flux_results[231,1]<-x_depth_s3
annual_flux_results[232,1]<-x_depth_d1
annual_flux_results[233,1]<-x_depth_d2
annual_flux_results[234,1]<-x_depth_d3
annual_flux_results[235,1]<-x_poros_s1
annual_flux_results[236,1]<-x_poros_s2
annual_flux_results[237,1]<-x_poros_s3
annual_flux_results[238,1]<-x_poros_d1
annual_flux_results[239,1]<-x_poros_d2
annual_flux_results[240,1]<-x_poros_d3




#Text descriptions of units set here for each row of output data
annual_flux_results[,2]<-rep("mMN/whole_model_domain_(1m2)/y",240)
annual_flux_results[8:13,2]<-("mMN/whole_model_domain_(1m2)/summer_period_AMJJAS")
annual_flux_results[c(217,221:228,235:240),2]<-"dimensionless"
annual_flux_results[c(218:220,229:234),2]<-"m"


annual_flux_results[,3]<-annual_flux_descriptions
#The vector of text descriptions for each row of output is set in internal.R


names(annual_flux_results)<-c("Model_annual_flux","Units","Description")

	filename = csvname(resultsdir, "OFFSHORE_model_annualresults", identifier)
	writecsv(annual_flux_results, filename, row.names=FALSE)

	list(
		mass_results		= mass_results,
		maxmass_results		= maxmass_results,
		minmass_results		= minmass_results,
		annual_flux_results	= annual_flux_results
	)
}

