% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annealing_find_gear_activity_mult_HR_target.R
\name{annealing_find_gear_activity_mult_HR_target}
\alias{annealing_find_gear_activity_mult_HR_target}
\title{Optimise fishing gear activity multipliers to maximum the likelihood of known harvest ratios}
\usage{
annealing_find_gear_activity_mult_HR_target(model, nchains = 100,
  n_iter = 3000, start_temperature = 0.5, cooling = 0.985,
  deltaHi = 0.2, attenuationstep = 500, deltaGrat = 0.25)
}
\arguments{
\item{model}{R-list object generated by the read_model() function which defined the model configuration}

\item{nchains}{Number of repeats (chains) of the simulated annealing process (default=100)}

\item{n_iter}{Number of iterations of the fishing fleet model per chain (default=3000)}

\item{start_temperature}{Initial value of the simulated annealing temperature parameter (default=0.5). Suggested values in the range 0.0005 - 5. Higher values increase the probability of rejecting parameter combinations producing an improvement in likelihood}

\item{cooling}{Rate at which the simulated annealing temperature declines with iterations (default=0.985). Suggested values in the range 0.9 - 0.985}

\item{deltaHi}{Initial coefficient of variation for jiggling the activity multiplier values (default=0.2)}

\item{attenuationstep}{Number of itereations between down-steps of the jiggling factor applied to the multiplier values. The jiggling rate is attenuated by a factor of 2 every xx iterations (default=500)}

\item{deltaGrat}{Coefficient of variation for jiggling the gear linkage values (default=0.25)}
}
\value{
CSV file of fitted gear activity multipliers and statistics of the likelihood weighted distributions of activity multipliers and the fit to harvest ratios
}
\description{
Launches a simulated annealing process to find the set of fishing fleet model gear activity multipliers
producing the maximum likelihood of a set of known harvest ratios using only the fishing fleet model,
given specified effort-harvest ratio scaling parameters.
Note that there is a related function annealing_find_gear_activity_mult_ecosystem_target() which uses the ecology model to
find the activity multipliers which maximise the likelihood of observed target data on the state of the ecosytem, given values of the
ecology model parameters and the scaling values linking effort to harvest ratio.
}
\details{
The known harvest ratios which act as the target for the optimization process are located in the file
../Modelname/Variantname/Target_data/fishing_fleet_target_harvest_ratios*.csv, where * is an identifier.

Simulated annealing is an iterative random-walk type process which searches the parameter space
of a model to locate the combination which maximises the likelihood of a set of observed
data corresponding to a suite of derived outputs. Parameter combinations which result in an improved likelihood
may be rejected according to a probability ('temperature') which decreases as the iterations progress. This is to  
avoid becoming stuck at local likelihood-maxima. The rate at which the 'temperature' decreases is set
by a 'cooling' parameter (fraction of previous temperature at each iteration, 0<value<1). The task here is a bit harder than normal
because of the potentially large overlap in the selectivity patterns of the fishing gears with respect to the living guilds in the ecosystem. So there are
some non-standard features to try and avoid local maxima.

Model configuration and initial values of the ecology model parameters need to be
assembled by a prior call of the read_model() function.

NOTE that the user.path argument in the read_model() function call needs to point to a user workspace folder, not the default
North Sea model provided with the package. This is because the annealing function needs write-access to the model /Parameters folder,
but the /extdata/Models folder in the package installation is read-only.
To use the annealing function on the North Sea model, use the copy_model() function to make a copy of the
North Sea model in the user workspace.

The initial coefficient of variation for searching the parameter space is set by a function argument. The CV decreases in steps with increasing iterations.
The function repeats the iteration process multiple times. The repeats are referred to as 'chains'. Each chain follows a different pathway through the parameter space.
At the end of the process, the best-fit set of activity multipliers is selected from across all the chains.

To cope with the overlap in selectivity of the fishing gears, the function uses a set of linkage parameters specified in the the file /Parameters/fishing_fleet_gear_linkages.csv
These parameters force selected gears activities to vary in concert +/- some variation, rather than independently. The parameters for the gear linkages are located in the file
../Modelname/Variantname/Parameters/fishing_fleet_gear_linkages.csv. The table of linkages specifies which gear activity rates are forced to 
vary in concert during the fitting process, as opposed to varying independently. The value of the linkage coefficient defines the 
scaling of changes in the activity rate of a dependent gear relative to its linked independent gear. For example, if gear 8 is permitted to vary 
independently (value in column "Gear to which linked" = NA and "Linkage coefficient" = NA). If gear 9 is dependent on gear 8 then the activity rate 
of gear 9 this would be specified by e.g. "Gear to which linked" = 8 and "Linkage coefficient" = 0.645. This would force the activity of gear 9 to be 
set at gear8_activity * (0.645 +/- a random variation defined by the argument deltaGrat).

The function produces a real-time graphical summary of the progress of the fitting procedure, displaying
the likelihoods of the proposed and accepted parameter sets at each iteration.
Y-axis (likelihood of the target data) range of the real time plot can be varied during the run by 
editing the setup file "annealing_SD_fishing.csv"

Once all the chains have been completed the function produces some diagnostic box and whisker plots showing the uncertainty in the estimated activity rate multipliers
and in the estimated harvest ratios across the end-points of all the chains. In each diagnostic plot the maximum likelihood model resullts are shown by a red
bar, and the distribution of all results by black box and whiskers.

At the end of the procedure a new version of the gear activity multipliers file is exported
to the folder /Parameters of the model version, with a user defined identifier specified by the model.ident argument
in the read_model() function. The histories of proposed and accepted parameter combinations
are saved as CSV files in the results folder.

To preserve the new activity multipliers and incorporate them into the fishing fleet model parameterisation
the multiplier values need to be applied to the activity rates specified in the data input file /Parameters/fishing_activity_parameters_*.csv.
Manually update the values in fishing_activity_parameters_*.csv, by multiplying the existing values by the new multipliers emerging from the annealing process.

If the edited file fishing_activity_parameters_*.csv is saved with a new identifier (*) then in order to use it in a subsequent run of the
StrathE2E model (using the StrathE2E() function) it will be necessary to edit the MODEL_SETUP.csv file in the relevant /Models/variant folder to point to the new file.
}
\examples{
#Copy the 1970-1999 version of the North Sea model supplied with the package into a user workspace (Windows OS):
copy_model("North_Sea", "1970-1999",
           dest.path="C:/Users/username/Documents/Models")

# Load the 1970-1999 version of the North Sea model from the user workspace:
model<-read_model(model.name="North_Sea",
                  model.variant="1970-1999",
                  model.ident="TEST",
                  user.path="C:/Users/username/Documents/Models")

# Quick Demo of the annealing function in operation:
annealing_find_gear_activity_mult_HR_target(model, nchains=5, n_iter=100, start_temperature=0.5)
# More realistic configuration would be (WARNING - this will an hour or so to run) :
annealing_find_gear_activity_mult_HR_target(model, nchains=100, n_iter=3000, start_temperature=0.5)
}
\seealso{
\code{\link{list_models}} , \code{\link{read_model}} , \code{\link{StrathE2E}} , \code{\link{annealing_find_ecology_parameters}} , \code{\link{annealing_find_harvest_ratio_mult}} , \code{\link{annealing_find_gear_activity_mult_ecosystem_target}}
}
