% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/annealing_find_gear_activity_mult_ecosystem_target.R
\name{annealing_find_gear_activity_mult_ecosystem_target}
\alias{annealing_find_gear_activity_mult_ecosystem_target}
\title{Optimise StrathE2E fishing gear activity multipliers to maximum the likelihood of observed ecosystem target data}
\usage{
annealing_find_gear_activity_mult_ecosystem_target(model, nyears = 40,
  n_iter = 500, start_temperature = 1, cooling = 0.975,
  quiet = TRUE)
}
\arguments{
\item{model}{R-list object generated by the read_model() function which defined the model configuration}

\item{nyears}{Number of years to run the model in each iteration (default=40)}

\item{n_iter}{Number of iterations of the model (default=500)}

\item{start_temperature}{Initial value of the simulated annealing temperature parameter (default=1). Suggested values in the range 0.0005 - 5. Higher values increase the probability of rejecting parameter combinations producing an improvement in likelihood}

\item{cooling}{Rate at which the simulated annealing temperature declines with iterations (default=0.975). Suggested values in the range 0.9 - 0.985}

\item{quiet}{(TRUE or FALSE) Suppress informational messages at the start of each iteration (default=TRUE)}
}
\value{
CSV file of fitted gear activity multipliers and the histories of the proposed and accepted parameter values
}
\description{
Launches a simulated annealing process to find the set of fishing fleet model gear activity multipliers
producing the maximum likelihood of observed target data on the state of the ecosystem,
given specified environmental driving data and ecology model parameters, and effort-harvest ratio scaling parameters.
Note that there is a related function annealing_find_gear_activity_mult_HR_target() which uses only the fishing fleet model to
find the activity multipliers which maximise the likelihood of a set of target harvest ratios (where these are known), given values of the
scaling values linking effort to harvest ratio.
}
\details{
Simulated annealing is an iterative random-walk type process which searches the parameter space
of a model to locate the combination which maximises the likelihood of a set of observed
data corresponding to a suite of derived outputs. Parameter combinations which result in an improved likelihood
may be rejected according to a probability ('temperature') which decreases as the iterations progress. This is to  
avoid becoming stuck at local likelihood-maxima. The rate at which the 'temperature' decreases is set
by a 'cooling' parameter (fraction of previous temperature at each iteration, 0<value<1)

Model configuration and initial values of the ecology model parameters need to be
assembled by a prior call of the read_model() function.

NOTE that the user.path argument in the read_model() function call needs to point to a user workspace folder, not the default
North Sea model provided with the package. This is because the annealing function needs write-access to the model /Parameters folder,
but the /extdata/Models folder in the package installation is read-only.
To use the annealing function on the North Sea model, use the copy_model() function to make a copy of the
North Sea model in the user workspace.

The coefficient of variation for jiggling the activity multipliers can be varied in real-time
during the run by editing the file "annealing_SD_fishing.csv" in the folder
/Parameters/Parameter_SD_control/ of the model version. Suggested vaues for the SD are in the range 0.1 to 0.01

The function produces a real-time graphical summary of the progress of the fitting procedure, displaying
the likelihoods of the proposed and accepted parameter sets at each iteration.
Y-axis (likelihood of the target data) range of the real time plot can be varied during the run by 
editing the setup file "annealing_SD_fishing.csv"

At the end of the procedure a new version of the gear activity multipliers file is exported
to the folder /Parameters of the model version, with a user defined identifier specified by the model.ident argument
in the read_model() function. The histories of proposed and accepted parameter combinations
are saved as CSV files in the results folder.

To preserve the new activity multipliers and incorporate them into the fishing fleet model parameterisation
the multiplier values need to be applied to the activity rates specified in the data input file /Parameters/fishing_activity_parameters_*.csv.
Manually update the values in fishing_activity_parameters_*.csv, by multiplying the existing values by the new multipliers emerging from the annealing process.

If the edited file fishing_activity_parameters_*.csv is saved with a new identifier (*) then in order to use it in a subsequent run of the
StrathE2E model (using the StrathE2E() function) it will be necessary to edit the MODEL_SETUP.csv file in the relevant /Models/variant folder to point to the new file.
}
\examples{
#Copy the 2003-2013 version of the North Sea model supplied with the package into a user workspace (Windows OS):
copy_model("North_Sea", "2003-2013",
           dest.path="C:/Users/username/Documents/Models")

# Load the 2003-2013 version of the North Sea model from the user workspace:
model<-read_model(model.name="North_Sea",
                  model.variant="2003-2013",
                  model.ident="TEST",
                  user.path="C:/Users/username/Documents/Models")

# Quick Demo of the annealing function in operation:
annealing_find_gear_activity_mult_ecosystem_target(model, nyears=5, n_iter=10, start_temperature=0.5)
# More realistic configuration would be (WARNING - this will take about 26 hours to run) :
annealing_find_gear_activity_mult_ecosystem_target(model, nyears=50, n_iter=1000, start_temperature=1)

}
\seealso{
\code{\link{list_models}} , \code{\link{read_model}} , \code{\link{StrathE2E}} , \code{\link{annealing_find_ecology_parameters}} , \code{\link{annealing_find_harvest_ratio_mult}} , \code{\link{annealing_find_gear_activity_mult_HR_target}}
}
