% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_new_initial_cond_from_end_of_run.R
\name{extract_new_initial_cond_from_end_of_run}
\alias{extract_new_initial_cond_from_end_of_run}
\title{Extract the values of all the state variables at the end of a run and format for use as new initial conditions}
\usage{
extract_new_initial_cond_from_end_of_run(model, results)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{results}{R-list object generated by the StrathE2E() function}
}
\value{
csv file containing new initial conditions
}
\description{
The function saves the state of the model at the end of a run for use as initial conditions in future runs. This enables, 
for example, the model to be run for a long time to attain a stationary state, and then restarted in that state.
}
\details{
Initial conditions for a model run are held in the /Parameters folder of the Model/Variant path specified in the read_model()
function call used to define a run. By default, the function attampts to write the model end-state file back to this /Parameters folder.
However, the package folders are read-only so if read_model() has been specified to load an internally provided Model/Variant then 
the output will revert to the currently specified results folder instead. To fix this, copy the required package model to a user
workspace using the copy_model() function and re-run.

The new initial conditions file will have a name model_endstate_export-*.csv, where * is the model.ident text identifier specified in read_model()
To source the new initial conditions in a subsequent model run, edit the MODEL_SETUP.csv file in the required /Models/Variant folder
}
\examples{
# Copy the 2003-2013 version of the North Sea model supplied with the package to a user workspace (Windows OS):
copy_model("North_Sea", "2003-2013",
           dest.path="C:/Users/username/Documents/Models")
model <- read_model("North_Sea", "2003-2013", 
      user.path="C:/Users/username/Documents/Models", model.ident="TEST")
results<-StrathE2E(model, nyears=5)
extract_new_initial_cond_from_end_of_run(model,results)
}
\seealso{
\code{\link{read_model}}, \code{\link{StrathE2E}}
}
