% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Monte_Carlo_parameter_distributions.R
\name{plot_Monte_Carlo_parameter_distributions}
\alias{plot_Monte_Carlo_parameter_distributions}
\title{Plots the credible distributions of ecology model parameters from a Monte Carlo simulation}
\usage{
plot_Monte_Carlo_parameter_distributions(model, use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Graphical display in a new graphics window
}
\description{
Create a plot showing the credible distributions of ecology model parameters based on the results from the Monte_Carlo_StrathE2E() function.
These distributions are formed from the input distributions to the Monte Carlo process, weighted by the likelihood of observed target data
on the state of the ecosystem given each combination of parameter values.
}
\details{
Post-processed data from the Monte_Carlo_StrathE2E() function are stored in the file
/results/Modelname/Variantname/CredInt/CredInt_processed_PARAMETERresults_data-*.csv, where * represents the model run identifier
(model.ident) text embedded in the R-list object created by the read_model() function.

Optionally the function can read an example data set for one of the two North Sea model variants supplied with the package.

Each parameter in the plot is scaled to its maximum likelihood value as (value-max.likelihood.value)/max.likelihood.value. 
Each parameter is then represented by a box and whisker plot which shows the distribution of credible parameter values around zero, ie.
around the maximum likelihood value. The median of the credible values distribution for each parameter
is shown my a black tick-mark. The box spans the 50% credible interval (quartiles of the cumulative likelihood
of simulated values). Whisker lines span the 99% credible interval.

The individual parameters are identified by numbers (rather than text names). These numnbers correspond to the column numnbers in
the file /results/Modelname/Variantname/CredInt/CredInt_processed_parameters-*.csv

The input distribution of parameter values to the Monte Carlo process is drawn from a random uniform distribution with limits specified in
the CredINtSim_SD control file for the model setup (located in a sub-folder of the /Parameters folder). This distribution is shown by
a red box and whisker at the bottom of the plot. Given the random uniform input we expect the quartiles (limits of the box) to be symetrical
and located mid-way between zero and the upper and lower extremes. Vertical red lines show the expected limits of the quartiles boxes if 
model results were completely insensitive to individual parameter values.

The extent to which individual parameter distributions deviate from the random uniform input is an indication of their sensitivity in the model. 
Parameters whose distributions are tightly confined around zero (the maximum likelihood value) are highly sensitive.

For some parameters, in particular the preference parameters, their credible distributions may span a wider range than the inputs. This may seem
unexpected, but arises because within each feeding guild the preference parameters are not independent of each other. The preferences within each guild
must sum to 1. Hence, during the Monte Carlo process, after drawing new values of the preference values they are all rescaled to sum to 1, which may mean that
some of them will have been varied by more than the original coefficient of variation of the input random uniform.

For details of how the distribution of credible output values from StrathE2E are calculated see the help information for the Monte_Carlo_StrathE2E() function.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")

# Either run the Monte_Carlo_StrathE2E() to generate some results, or use the internal example data

#Plot the ecology model parameter distributions:
plot_Monte_Carlo_parameter_distributions(model, use.example=TRUE)

# To direct the graph output to a file rather than the screen, wrap the plot_Monte_Carlo_parameter_distributions() function call in a graphical device call:
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=9,height=4)      # or jpeg("plot.jpg"), png("plot.png")
	plot_Monte_Carlo_parameter_distributions(model, use.example=TRUE)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{Monte_Carlo_StrathE2E}}, \code{\link{box_and_whisker_annual_plots_with_credible_intervals}}
}
