% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/plot_final_year_time_series_data_with_credible_intervals.R
\name{plot_final_year_time_series_data_with_credible_intervals}
\alias{plot_final_year_time_series_data_with_credible_intervals}
\title{Create multi-panel plots showing the credible intervals of state variable densities over the final year of a simulation generated by the Monte_Carlo_StrathE2E() function}
\usage{
plot_final_year_time_series_data_with_credible_intervals(model, selection,
  use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{selection}{Text string from a list identifying the group of model output variables to be plotted. Select from: "NUT_PHYT", "SEDIMENT", "ZOOPLANKTON", "FISH", "BENTHOS", "PREDATORS", "CORP_DISC", "MACROPHYTE", Remember to include the phrase within "" quotes.}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Graphical display in a new graphics window
}
\description{
Each panel of the plot shows a time-series of the densities (per unit sea surface area or layer volume) of a
state variable over the final year of a run. The data displayed are the solution to the maximum likelihood model, together with 
centiles of the distribution of credible values. The distribution of credible values is derived from
a Monte Carlo simulation scheme performed by the Monte_Carlo_StrathE2E() function.
}
\details{
Daily interval post-processed data from the Monte_Carlo_StrathE2E() function are stored in the file
/results/Modelname/Variantname/CredInt/CredInt_processed_daily_mass-*.csv, where * represents the model run identifier
(model.ident) text embedded in the R-list object created by the read_model() function.
The function described here loads these stored data. Depending on the value set for the 'selection' argument in the function,
different groups of variables are extracted for plotting in each multi-panel page.

Optionally the function can read an example data set for one of the two North Sea model variants supplied with the package.

In each plot the x-axis represents day of the year over an annual cycle. The y-axis represents mass density of a state variable
(mMN/m2 or mMN/m3). Results from the maximum likelihood model are shown by a red line. The median of the credible values distribution
is shown my a solid black line. A grey-shaded area indicates the 50% credible interval (spanning quartiles of the cumulative likelihood
of simulated values). Black dashed lines span the 99% credible interval.

For details of how the distribution of credible output values from StrathE2E are calculated see ?Monte_Carlo_StrathE2E.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")

# Either run the Monte_Carlo_StrathE2E() to generate some results, or use the internal example data

# Plot final year time series from the internal example data on screen, each page to a new plot window:
plot_final_year_time_series_data_with_credible_intervals(model, "NUT_PHYT",use.example=TRUE)	   # plot nutrient and phytoplankton data
dev.new()
plot_final_year_time_series_data_with_credible_intervals(model, "SEDIMENT",use.example=TRUE)	   # plot sediment chemisty data
dev.new()
plot_final_year_time_series_data_with_credible_intervals(model, "ZOOPLANKTON",use.example=TRUE) # plot zooplankton data
dev.new()
plot_final_year_time_series_data_with_credible_intervals(model, "FISH",use.example=TRUE)	   # plot fish and fish larvae data
dev.new()
plot_final_year_time_series_data_with_credible_intervals(model, "BENTHOS",use.example=TRUE)	   # plot benthos and benthos larvae data
dev.new()
plot_final_year_time_series_data_with_credible_intervals(model, "PREDATORS",use.example=TRUE)   # plot bird, pinniped and cetacean data
dev.new()
plot_final_year_time_series_data_with_credible_intervals(model, "CORP_DISC",use.example=TRUE)   # plot corpse and discard data
dev.new()
plot_final_year_time_series_data_with_credible_intervals(model, "MACROPHYTE",use.example=TRUE)  # plot macrophyte data

# To direct the graph output to a file rather than the screen, wrap the plot_final_year_data_with_credible_intervals() function call in a graphical device call:
# Since the plot pages contain different numbers of panels the recommended width:height ratios are as follows:
#	NUT_PHYT,	1.5  : 1
#	SEDIMENT,	0.67 : 1
#	ZOOPLANKTON,	1    : 1
#	FISH		2    : 1
#	BENTHOS		2    : 1
#	PREDATORS	2    : 1
#	CORP_DISC	1    : 1
#	MACROPHYTE	2    : 1
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=7,height=4.667)      # or jpeg("plot.jpg"), png("plot.png")
	plot_final_year_time_series_data_with_credible_intervals(model, "NUT_PHYT",use.example=TRUE)
dev.off()
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=4,height=6)
	plot_final_year_time_series_data_with_credible_intervals(model, "SEDIMENT",use.example=TRUE)
dev.off()
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=4,height=4)
	plot_final_year_time_series_data_with_credible_intervals(model, "ZOOPLANKTON",use.example=TRUE)
dev.off()
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=6,height=3)
	plot_final_year_time_series_data_with_credible_intervals(model, "FISH",use.example=TRUE)
dev.off()
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=6,height=3)
	plot_final_year_time_series_data_with_credible_intervals(model, "BENTHOS",use.example=TRUE)
dev.off()
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=6,height=3)
	plot_final_year_time_series_data_with_credible_intervals(model, "PREDATORS",use.example=TRUE)
dev.off()
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=4,height=4)
	plot_final_year_time_series_data_with_credible_intervals(model, "CORP_DISC",use.example=TRUE)
dev.off()
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=4,height=2)
	plot_final_year_time_series_data_with_credible_intervals(model, "MACROPHYTE",use.example=TRUE)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{Monte_Carlo_StrathE2E}}, \code{\link{plot_final_year_migration_data_with_credible_intervals}} , \code{\link{plot_inshore_vs_offshore_anavmass_with_credible_intervals}}
}
