% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sensitivity_analysis_results.R
\name{plot_sensitivity_analysis_results}
\alias{plot_sensitivity_analysis_results}
\title{Create a plot of results from the Morris method sensitivity analysis}
\usage{
plot_sensitivity_analysis_results(model, use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Graphical display in a new graphics window
}
\description{
Reads results generated by the function Sensitivity_analysis_StrathE2E() and plots the Elementary Effect mean (x-axis; magnitude of sensitivity)
against Elementary Effect standard deviation (y-axis; strength of interactions between parameters).
}
\details{
Results from the Sensitivity_analysis_StrathE2E() function are stored in the CSV file
/results/Modelname/Variantname/sorted_parameter_elementary_effects-*.csv 
where * represents the model run identifier (model.ident) text embedded in the R-list object created by the read_model() function.

Optionally, the function can read example data for one of the two North Sea model variants supplied with the package.

Each symbol in the plot represents a single parameter in the model. The parameters are colour-coded to indicate 6 different types - fitted and fixed
parameters of the ecology model, fishing fleet model parameters, fishery harvest ratios, environmental drivers, and physical configuration parameters.

The plot also shows a wedge formed by the two dashed lines. These correspond to +/-2 standard errors of the mean, so for points falling outside of the
wedge there is a significant expectation that the distribution of elementary effects is non-zero. For points falling within the wedge the distribution of
elementary effects is not significantly different from zero

For details of how the Elementary Effect values are derived for each parameter see ?Sensitivity_analysis_StrathE2E
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package :
model <- read_model("North_Sea", "1970-1999")

# Plot the example data for this model variant provided with the package
plot_sensitivity_analysis_results(model, use.example=TRUE)

# To direct the graph output to a file rather than the screen, wrap the plot_sensitivity_analysis_results() function call in a graphical device call:
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=6,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	plot_sensitivity_analysis_results(model, use.example=TRUE)
dev.off()

}
\references{
Morris, M.D. (1991). Factorial sampling plans for preliminary computational experiments. Technometrics, 33, 161-174.
}
\seealso{
\code{\link{read_model}}, \code{\link{Sensitivity_analysis_StrathE2E}}, \code{\link{concatenate_raw_sensitivity_analysis_results}} , \code{\link{process_sensitivity_analysis_results_offline}}
}
