% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_sensitivity_analysis_results_offline.R
\name{process_sensitivity_analysis_results_offline}
\alias{process_sensitivity_analysis_results_offline}
\title{Read and post-process raw data saved as a csv file from the Sensitivity_analysis_StrathE2E() function}
\usage{
process_sensitivity_analysis_results_offline(model, use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Datraframe and csv file of processed output from sensitivity analysis
}
\description{
Reads raw data generated by the function Sensitivity_analysis_StrathE2E() from a saved csv file, and creates a post-processed output file
containing the mean Elementary Effect (EE_mean) and the standard deviation of EE (EE_sd) for each parameter, sorted by the absolute value of EE_mean.
EE_mean is an index of the magnitude of the sensitivity of a parameter, and EE_sd is an index of the extent of interaction with other parameters.
}
\details{
The raw data input is a table of Elementary Effect values for each run of the model. Model runs are orgaanised by trajectories which consist
of a baseline run in which all parameters are perturbed from an initial state by the addition of terms drawn from a random normal of mean zero, plus
a set of runs in which each parameter in turn is perturbed by a fixed amount.

The function reads the file of raw sensitivity analysis data (OAT_results-*.csv, where * refers to the identifier model.ident set in the read_moldel() function) from a /results folder
and performs the post-processing that would ordinarily be done automatically within the Sensitivity_analysis_StrathE2E() or 
concatenate_raw_sensitivity_analysis_results() functions. The function is provided as a backup to mitigate against data loss in the event of some interruption to the normal
automatic data processing since running a sensitivity analysis represents a significant investment of computer time.

Optionally, the function can read example data for one of the two North Sea model variants supplied with the package.

Output from the function is a processed data file named sorted_parameter_elementary_effects-*.csv in the current folder /results/Modelname/Variantname/

For details of how the Elementary Effect values are derived for each parameter see ?Sensitivity_analysis_StrathE2E
}
\examples{
# Load details of the 1970-1999 version of the North Sea model supplied with the package and the text identifier of the raw data file:
model <- read_model("North_Sea", "1970-1999")
# Process the example data for this model variant provided with the package
sens_results <- process_sensitivity_analysis_results_offline(model, use.example=TRUE)
head(sens_results)

}
\references{
Morris, M.D. (1991). Factorial sampling plans for preliminary computational experiments. Technometrics, 33, 161-174.
}
\seealso{
\code{\link{read_model}}, \code{\link{Sensitivity_analysis_StrathE2E}}, , \code{\link{concatenate_raw_sensitivity_analysis_results}}
}
