#
# CredInt_make_network_results.R
#
#' Save current set of fitted parameters to file
#'
#' @param model model object
#' @param networkstore inshore annual flux data
#'
#
CredInt_make_network_results <- function(model, networkstore) {

	resultsdir	<- elt(model, "setup", "resultsdir")
	identifier	<- elt(model, "setup", "model.ident")

	credpath	<- makepath(resultsdir, CREDINT_DIR)



#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


ProcessCredIntFile <- function(Optresults){

Nind<-ncol(Optresults)-2

creds<-c(0.005,0.25,0.5,0.75,0.995)  


ouresults<-data.frame(rep(0,(length(creds)+1)))

rownames(ouresults)<-c("maxlik","lowlimit","lowquart","median","uppquart","upplimit")

for(jj in 2:Nind){
ouresults[,jj]<-rep(0,(length(creds)+1))
}
colnames(ouresults)<-names(Optresults[3:(Nind+2)])
ouresults[1,]<-Optresults[1,3:(Nind+2)]


for(jj in 1:Nind){

Result<-Optresults[,jj+2]

Likelihood<-Optresults[,2]

ouresults[2:(length(creds)+1),jj]<-GetCredInt(Result,Likelihood,creds,var=colnames(ouresults)[jj])

}

return(ouresults)

}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


networkresults<-ProcessCredIntFile(networkstore)

csvfile <- csvname(credpath, "CredInt_processed_networkresults", identifier)
writecsv(networkresults, csvfile)


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


}

