#
# CredInt_make_parameter_results.R
#
#' Save current set of fitted parameters to file
#'
#' @param model model object
#' @param parameterstore inshore annual flux data
#'
#' @importFrom stats quantile sd rnorm
#'
#
CredInt_make_parameter_results <- function(model, parameterstore) {

	resultsdir <- elt(model, "setup", "resultsdir")
	identifier <- elt(model, "setup", "model.ident")

	credpath <- makepath(resultsdir, CREDINT_DIR)


cols2use<-(2:172)


Nind<-length(cols2use)


creds<-c(0.005,0.25,0.5,0.75,0.995)  


O_results<-data.frame(rep(0,(length(creds)+1)))

rownames(O_results)<-c("maxlik","lowlimit","lowquart","median","uppquart","upplimit")

for(jj in 2:Nind){
O_results[,jj]<-rep(0,(length(creds)+1))
}
colnames(O_results)<-names(parameterstore[cols2use])

O_results[1,]<-parameterstore[1,cols2use]


for(jj in 1:Nind){

Result<-parameterstore[,cols2use[jj]]

Likelihood<-parameterstore$likelihood

O_results[2:(length(creds)+1),jj]<-GetCredInt(Result,Likelihood,creds,var=colnames(O_results)[jj])

}


csvfile <- csvname(credpath, "CredInt_processed_parameters", identifier)
writecsv(O_results, csvfile)


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

}

