#
# CredInt_make_target_results.R
#
#' Save current set of fitted parameters to file
#'
#' @param model model object
#' @param optresultsstore inshore annual flux data
#'
#
CredInt_make_target_results <- function(model, optresultsstore) {

	resultsdir <- elt(model, "setup", "resultsdir")
	identifier <- elt(model, "setup", "model.ident")

	credpath <- makepath(resultsdir, CREDINT_DIR)


	Nind<-ncol(optresultsstore)-2

	creds<-c(0.005,0.25,0.5,0.75,0.995)  

	ouresults<-data.frame(rep(0,(length(creds)+1)))

	rownames(ouresults)<-c("maxlik","lowlimit","lowquart","median","uppquart","upplimit")

	for(jj in 2:Nind){
		ouresults[,jj]<-rep(0,(length(creds)+1))
	}
	colnames(ouresults)<-names(optresultsstore[3:(Nind+2)])
	ouresults[1,]<-optresultsstore[1,3:(Nind+2)]

	for(jj in 1:Nind){

		Result<-optresultsstore[,jj+2]

		Likelihood<-optresultsstore[,2]

		ouresults[2:(length(creds)+1),jj]<-GetCredInt(Result,Likelihood,creds,var=colnames(ouresults)[jj])
	}

	csvfile <- csvname(credpath, "CredInt_processed_targetresults", identifier)
	writecsv(ouresults, csvfile)
}

