#
# read_SD_fishing.R
#
#' return list of annealing parameters
#'
#' @param model.path model path
#' @param file fishing control file, default 'annealing_SD_fishing.csv'
#'
#' @return list of annealing parameters for determining scaling factors
#'
#
read_SD_fishing <- function(model.path, file="annealing_SD_fishing.csv") {

	annealing_control_data <- readcsv(model.path, SD_CONTROL_DIR, file)

	# Set the axis min and max for the display plot
	axmin	<- annealing_control_data[1,1]
	axmax	<- annealing_control_data[2,1]

	# sd for jiggling the fishing fleet parameters
	deltaH	<- annealing_control_data[3,1]

	annealing.parms <- list(
		axmin		= axmin,
		axmax		= axmax,
		deltaH		= deltaH
	)
}

