% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Monte_Carlo_StrathE2E.R
\name{Monte_Carlo_StrathE2E}
\alias{Monte_Carlo_StrathE2E}
\title{Runs a Monte Carlo simulation with StrathE2E and derives centiles of credible values of model outputs}
\usage{
Monte_Carlo_StrathE2E(model, nyears = 50, n_iter = 1000)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{nyears}{Number of years to run each instance of the model. Needs to be long enough to allow the model to attain a stationary state (default=50)}

\item{n_iter}{Number of iterations of the model (default=1000)}
}
\value{
Real-time graphical displays during the simulation, and CSV files of output and post-processed data
}
\description{
The Monte Carlo scheme generates an ensemble of model runs by sampling the ecology model parameters from uniform distibutions
centred on a maximum likelihood parameter set. The latter needs to be arrived at by prior application the various simulated
annealing functions in the package to 'fit' the model to a suite of observational data on the state of ecosystem
(target data for fitting are in /Modelname/Variantname/Target_data/annual_target_data_*.csv).
Each iteration in the Monte Carlo scheme then generates a unique time series of model outputs at daily intervals,
together with the overall likelihood of the obervational target data.
}
\details{
The function should be initialised with starting values, parameter and driving data configuration corresponding to a stationary
state with the maximum likelihood of the observational target data. This configuration needs to be loaded by a prior call of the
read_model() function. This represents the baseline for sampling of the ecology model parameters.

The coefficients of variation for jiggling the ecology parameter can be varied in real-time
during the run by editing the file "CredIntSim_SD.csv" in the folder
/Parameters/Parameter_SD_control/ of the model version. However, it is recommended to leave the setting constant for the duration of a run.
A cv of 0.10 to 0.15 is recommended. If comparing the credible intervals for two versions of a model then it is important to use the same cv in both cases.

On completion of all the iterations of the model, for each model output variable in turn, values from the individual runs and
their associated model likelihoods are assembled as a list of paired values. The list is then sorted by ascending values of the model variable,
and the cumulative likelihoods with increasing value of model variable is calculated. Values for the model variable at standard proportions
(0.005, 0.25, 0.5, 0.75, 0.995) of the maximum cumulative likelhood are then extracted by interpolation.
These represent the credible intervals of model output given uncertainty in the ecology model parameters.

Outputs from the Monte_Carlo_StrathE2E() function are stored in csv files in the folder /results/Modelname/Variantname/CredInt/ with an
identifier for the simulation (model.ident) created by the read_model() function. There are two types of output. First is simple an
accumulation of all the standard outputs from StrathE2E on a run-by-run basis. The output of these data is updated every 10 iterations
for security to mitigate against data loss in the event of an unforseen interruption of a simulation. The second type of output is the results
of post-processing the raw data to generate the centile of the distribution of credible values.

The function displays various real-time graphics to show the progress of the simulation. During the StrathE2E-running phase of the
process an x-y graph is updated after each iteration (x-axis=iterations, y-axis=Likelihood of the target data), with a horizontal grey line showing the
baseline (maximum liklihood) result, and black symbols showing the likelihood for each iteration based on the parameter values sampled from the baseline.
The y-axis limits for the graph can be varied in real-time
during the run by editing the file "CredIntSim_SD.csv" in the folder /Parameters/Parameter_SD_control/ of the model version.

During the post-processing phase, an x-y graph of the cumulative
likelihood (y-axis) vs output variable values, is displayed as the code works through all of the output variables.

WARNING - the scheme can take a long time to run (~2 days with the default settings), and generate large output files.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")

# Run the Monte Carlo process and generate the results files
# WARNING: This run will take more than 24h to complete !
Monte_Carlo_StrathE2E(model,nyears=50,n_iter=1000)

# A quick demonstration run:
model <- read_model("North_Sea", "1970-1999", model.ident="Demo")
Monte_Carlo_StrathE2E(model,nyears=5,n_iter=10)

}
\seealso{
\code{\link{read_model}}, \code{\link{plot_final_year_time_series_data_with_credible_intervals}}, \code{\link{plot_final_year_migration_data_with_credible_intervals}} , \code{\link{plot_inshore_vs_offshore_anavmass_with_credible_intervals}}
}
