% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StrathE2E.R
\name{StrathE2E}
\alias{StrathE2E}
\title{Run the StrathE2E model}
\usage{
StrathE2E(model, nyears = 20, quiet = TRUE, csv.output = TRUE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{nyears}{Number of years (integer) to run the model (default=20)}

\item{quiet}{Set to TRUE to quieten status outputs during the model run (default=TRUE)}

\item{csv.output}{Set to FALSE to disable writing of CSV output files (default=TRUE)}
}
\value{
Model outputs as an R-list object and CSV files
}
\description{
Perform a single deterministic run of the StrathE2E model for a configuration
defined by an R-list object compiled by a prior call of the read_model() function.
}
\details{
The function solves a network of Ordinary Differential Equations using the lsoda function
in the R deSolve package. The equations represent a shelf-sea food web and its connections to the physical and chemical environment,
and to a set of fishing fleets.

The outputs from the run are time series (daily intervals) of the masses of each of the state
variables, the fluxes between all state variable, and the fluxes in and out of the model including
fishery landings. In addition, a range of derived quantities are generated for the final year of the
run, including annual averages, maxima and minima of state variables, annual fluxes between state variables, annual landings and
discards of each guild of taxa by each fleet of fishing gears, and a set of
network indices generated by the R NetIndices package.
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "2003-2013")

#Run the model and generate the results object
results <- StrathE2E(model)

# Time series plot of state varaiables over the full length of the run
plot_full_length_timeseries(model, results)
}
\seealso{
\code{\link{list_models}}, \code{\link{read_model}}, \code{\link{copy_model}}
}
