% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_and_whisker_annual_plots.R
\name{box_and_whisker_annual_plots}
\alias{box_and_whisker_annual_plots}
\title{Box-and-whisker plots of observed annual target data on the state of the ecosystem with equivalent properties derived from a StrathE2E run}
\usage{
box_and_whisker_annual_plots(model, results)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{results}{R-list object containing model results generated by the StrathE2E() function}
}
\value{
Graphical display in a new graphics window
}
\description{
Multi-panel plot comparing a range of observational data on the state of the ecosystem with equivalent properties derived from the final year of a model run generated by the StrathE2E() function
}
\details{
The function plots a multi-panel page of box-and-whisker plots showing the medians and variability ranges (quartiles as box-and-whisker) of a range of observational data on properties of an ecosystem
alongside single-value data on equivalent measures derived from the final year of a StrathE2e model run.
Individual panels of the plot represent groups of similar or related ecosystem properties - annual productions, annual fishery landings, annual P:B ratios, annual food consumtion and diet compositions, nutrient concentrations, and inshore : offshore abundanace ratios.

The observational data to be plotted are loaded from the folder Modelname/Variantname/Target_data/annual_target_data_*.csv as part of a read_model() function call and are built into the R-list object generated by read_model().
Column 3 of annual_target_data_* (header "Use1_0") is a flag to set whether any given row is used in calculating the likelihood o fthe observed data given the model setup. Un-used rows of data are omitted from the box and whisker plotting panels

The corresponding measures derived from the final year of a model run generated by the StrathE2E() function call are located in /results/Modelname/Variantname/model_target_annualresults-*.csv, and in the R-list object generated by StrathE2E()

The likelihood of the observed data given the model configuration, driving data and parameters, is located in /results/Modelname/Variantname/model_likelihood_results-base-*.csv, and in the R-list object generated by StrathE2E()
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")
#Run the model and generate the results object
results <- StrathE2E(model,nyears=10)
# Plot the comparison of target data and model  output
box_and_whisker_annual_plots(model, results)

# Plot in a new window leaving any existing windows open
dev.new()
box_and_whisker_annual_plots(model, results)

#Direct the graphics output to a file (Windows OS)... 
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=8,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	box_and_whisker_annual_plots(model, results)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{StrathE2E}}, \code{\link{plot_final_year}} , \code{\link{box_and_whisker_monthly_plots}}
}
