% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/box_and_whisker_annual_plots_with_credible_intervals.R
\name{box_and_whisker_annual_plots_with_credible_intervals}
\alias{box_and_whisker_annual_plots_with_credible_intervals}
\title{Box-and-whisker plots of observed annual target data on the state of the ecosystem with equivalent properties derived from a Monte Carlo StrathE2E run}
\usage{
box_and_whisker_annual_plots_with_credible_intervals(model,
  use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Graphical display in a new graphics window
}
\description{
Creates a multi-panel plot comparing a range of observational data on the state of the ecosystem with the distribution of credible values
of equivalent properties derived from the final year of a model runs generated by the Monte_Carlo_StrathE2E() function
}
\details{
For details of how the distribution of credible output values from StrathE2E are calculated see ?Monte_Carlo_StrathE2E.

The function plots a multi-panel page of box-and-whisker plots showing the medians and variability ranges (quartiles as box-and-whisker) of a range of observational data on properties of an ecosystem
(shown in black), alongside comparable box-and-whisker plots (shown in red) of equivalent measures derived from the final years of an ensemble of model runs generted by a Monte Carlo methodology (Monte_Carlo_StrathE2E() function)

Individual panels of the plot represent groups of similar or related ecosystem properties - annual productions, annual fishery landings, annual P:B ratios, annual food consumtion and diet compositions, nutrient concentrations, and inshore : offshore abundanace ratios.

The observational data to be plotted are loaded from the folder Modelname/Variantname/Target_data/annual_target_data-*.csv as part of a read_model() function call and are built into the R-list object generated by read_model().
Column 3 of annual_target_data_* (header "Use1_0") is a flag to set whether any given row is used in calculating the likelihood of the observed data given the model setup. Un-used rows of data are omitted from the box and whisker plotting panels

Optionally the function can read an example data set for one of the two North Sea model variants supplied with the package.

The corresponding measures derived from the final year of a model run generated by the Monte_Carlo_StrathE2E() function call are located in /results/Modelname/Variantname/CredInt_processed_targetresults-*.csv
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")

# Either run the Monte_Carlo_StrathE2E() to generate some results, or use the internal example data

# Plot the final year comparison of observed and modelled ecosystem state on screen:
box_and_whisker_annual_plots_with_credible_intervals(model, use.example=TRUE)

#Direct the graphics output to a file (Windows OS)... 
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=8,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	box_and_whisker_annual_plots_with_credible_intervals(model, use.example=TRUE)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{Monte_Carlo_StrathE2E}}, \code{\link{box_and_whisker_annual_plots}} , \code{\link{box_and_whisker_monthly_plots_with_credible_intervals}}
}
