% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_and_whisker_monthly_plots.R
\name{box_and_whisker_monthly_plots}
\alias{box_and_whisker_monthly_plots}
\title{Box-and-whisker plots of observed monthly data on the state of the ecosystem with equivalent properties derived from a StrathE2E run}
\usage{
box_and_whisker_monthly_plots(model, results)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{results}{R-list object containing model results generated by the StrathE2E() function}
}
\value{
Graphical display in a new graphics window
}
\description{
Multi-panel plot comparing annual cycles of monthly averaged observational data on nutrinet and plankton concentrations with equivalent data derived from the final year of a model run generated by the StrathE2E() function
}
\details{
The function plots a multi-panel page of box-and-whisker plots showing the medians and variability ranges (quartiles as box-and-whisker) of observational data on nitrate, ammonia, chlorophyll, omnivorous and carnivorous zooplankton, and benthos larvae concentrations
alongside single-value data on equivalent measures derived from the final year of a StrathE2e model run.

The observational data to be plotted are loaded from the folder Modelname/Variantname/Target_data/monthly_target_data_*.csv as part of a read_model() function call and are built into the R-list object generated by read_model().

The corresponding measures derived from the final year of a model run generated by the StrathE2E() function call are located in /results/Modelname/Variantname/model_target_monthlyresults-*.csv, and in the R-list object generated by StrathE2E()
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")
#Run the model and generate the results object
results <- StrathE2E(model,nyears=10)
# Plot the comparison of target data and model output
box_and_whisker_monthly_plots(model, results)

# Plot in a new window leaving any existing windows open
dev.new()
box_and_whisker_monthly_plots(model, results)

#Direct the graphics output to a file (Windows OS)... 
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=8,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	box_and_whisker_monthly_plots(model, results)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{StrathE2E}}, \code{\link{plot_final_year}} , \code{\link{box_and_whisker_annual_plots}}
}
