% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_hr_scale_values.R
\name{calculate_hr_scale_values}
\alias{calculate_hr_scale_values}
\title{Calculate rough values of the scaling parameters for the fishing fleet model which link effort to harvest ratios}
\usage{
calculate_hr_scale_values(model)
}
\arguments{
\item{model}{R-list object generated by the read_model() function which defined the model configuration}
}
\value{
Dataframe of the effort-harvest ratio scaling parameter values for each guild
}
\description{
The scaling parameters convert the effort applied by each gear to each living resource guild in the model, into a harvest ratio (proportion of mass captured per day).
Effort is the product of activity and the relative power of each gear with respect to each guild.
}
\details{
In order to estimate these scaling parameters, data are needed for a 'calibration' time period when activity, catch and harvest ratio are all known.

The function assumes that the relevant model configuration has alreday been loaded using the read_model() function. It is expected that
this has loaded the array of power parameters (catch per unit activity by gear and guild during the calibration period) given in the file /Parameters/fishing_power_parameters_*.csv,
the corresponding activity in the file /Parameters/fishing_activity_parameters_*.csv, and the known harvest ratios of each guild in the file /Target_data/known_regional_harvest_ratios_*.csv

The function returns rough estimates of the scaling parameters. These are only rough because they assume that the effort and resource biomass are distributed uniformly
over the model domain.

The scaling parameters are dispayed on the screen and saved in a dataframe. The values then need to be manually edited
into rows 12-21 (excluding the header row) of the file /Parameters/fishing_fleet_parameters_*.csv
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package and calculate scaling parameter values:
#
model <- read_model("North_Sea", "2003-2013", quite=FALSE)

scale_values <- calculate_hr_scale_values(model)

scale_values
}
\seealso{
\code{\link{list_models}} , \code{\link{read_model}}
}
