% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_two_runs_aam.R
\name{compare_two_runs_aam}
\alias{compare_two_runs_aam}
\title{Create a tornado plot of the differences in annual averaged masses of variable in two model runs}
\usage{
compare_two_runs_aam(model1 = NA, results1, from.csv1 = FALSE,
  model2 = NA, results2, from.csv2 = FALSE, log.pc = "PC",
  zone = "W", bpmin = (-50), bpmax = (+50), maintitle = "")
}
\arguments{
\item{model1}{R-list object defining the model configuration compiled by the read_model() function for the first (baseline) run. Set to NA if argument 'from.csv1'=FALSE. Default = NA}

\item{results1}{R-list object containing the results from the first (baseline) run of the StrathE2E() function. Set to NA if argument 'from.csv1'=TRUE. Default = value expected.}

\item{from.csv1}{TRUE = read baseline data from csv files created by a past model run. FALSE = use baseline data held in memory. Default = FALSE.}

\item{model2}{R-list object defining the model configuration compiled by the read_model() function for the second (scenario) run. Set to NA if argument 'from.csv2'=FALSE. Default = NA}

\item{results2}{R-list object containing the results from the second (scenario) run of the StrathE2E() function. Set to NA if argument 'from.csv1'=TRUE. Default = value expected.}

\item{from.csv2}{TRUE = read scenario data from csv files created by a past model run. FALSE = use scenario data held in memory. Default = FALSE.}

\item{log.pc}{Value="LG" for data to be plotted on a log10 scale, value = "PC" for data to be plotted on a percentage difference scale. Default = "PC".}

\item{zone}{Value = "O" for offshore, "I" for inshore, or "W" for whole model domain (all upper case). Default = "W".}

\item{bpmin}{Axis minimum for plot - i.e. the maximum NEGATIVE value of (scenario-baseline). Default = -50, given log.pc="PC" (percentage differences). Needs to be reset to e.g. -0.3 if log.pc="LG" (log scale).}

\item{bpmax}{Axis maximum for plot - i.e. the maximum POSITIVE value of (scenario-baseline). Default = +50, given log.pc="PC" (percentage differences). Needs to be reset to e.g. +0.3 if log.pc="LG" (log scale).}

\item{maintitle}{A descriptive text field (in quotes) to be added above the plot. Keep to 45 characters including spaces. Default="".}
}
\value{
List object comprising two dataframes changeland and changedisc, graphical display in a new graphics window
}
\description{
Reads final year annual average mass results generated by two StrathE2E() model runs with different inputs, and plot the difference
between the two as tornado diagrams for the water column and seabed components separately.
}
\details{
Annual average mass results from the final year of runs of the StrathE2E() function are held in memory and also stored as CSV files as
/results/Modelname/Variantname/ZONE_model_anav_biomass-*.csv 
where ZONE is INSHORE, OFFSHORE or WHOLEDOMAIN and * represents the model run identifier (model.ident) text embedded in the R-list object created by the read_model() function.

Optionally, the function can read these data from files created by past model runs, or use data still held as results objects from recent runs.

The tornado plots show differences between the runs as horizontal barplots. If the first set of model results is regarded as
a baseline run, and the second as a scenario run (e.g. with different driving data), then scenario values > baseline values are
shown by green bars to the right of 'no difference' (i.e scenario=baseline). Conversely scenario values < baseline values 
are shown by red bars to the left.

The bars can be plotted on a log10 scale or a percentage scale governed by argument settings

The function returns a list object comprising two dataframes (changewater and changeseabed). The first if the proportional difference in water column variables between the scenario run and the baseline 
the second is the proportional difference in seabed variables. The first column in each dataframe is the proportional difference expressed on a log10 scale, the second column as a percentage.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package :
base_model   <- read_model("North_Sea", "1970-1999",model.ident="baseline")
base_results <- StrathE2E(base_model,nyears=5)

# Create a scenario run from 1970-1999 baseline:
scen1_model   <- base_model      # Copies the baseline configuration into a new model object
scen1_model$setup$model.ident <- "scenario1"
scen1_model$data$fleet.model$gear_mult[4] <- 0.5 # Gear 4 (Beam_Trawl_BT1+BT2) activity rate rescaled to 0.5*baseline
scen1_results <- StrathE2E(scen1_model,nyears=30)

#Compare the scenario with the baseline
mdiff_results1<-compare_two_runs_aam(model1=NA,results1=base_results,from.csv1=FALSE,
	        		model2=NA,results2=scen1_results,from.csv2=FALSE,
                     		log.pc="PC", zone="W",
                     		bpmin=(-40),bpmax=(+40),
                     		maintitle="Beam Trawl activity reduced by half")


#Create a second sceanario run
scen2_model   <- base_model     # Copies the baseline configuration into a new model object
scen2_model$setup$model.ident <- "scenario2"
scen2_model$data$fleet.model$gear_mult[1] <- 0.5 # Gear 1 (Pelagic_Trawl+Seine) activity rate rescaled to 0.5*baseline
scen2_results <- StrathE2E(scen2_model,nyears=30)

#Compare the new scenario with the baseline previously saved in a csv files
mdiff_results2<-compare_two_runs_aam(model1=base_model,results1=NA, from.csv1=TRUE,
                     		model2=NA,results2=scen2_results,from.csv2=FALSE,
                     		log.pc="PC", zone="W",
                     		bpmin=(-40),bpmax=(+60),
                     		maintitle="Pelagic Trawl/Seine activity reduced by half")

}
\seealso{
\code{\link{read_model}}, \code{\link{StrathE2E}}, \code{\link{compare_two_runs_catch}}
}
