% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatenate_raw_sensitivity_analysis_results.R
\name{concatenate_raw_sensitivity_analysis_results}
\alias{concatenate_raw_sensitivity_analysis_results}
\title{Combine two or more sets of raw output data from sensitivity analysis runs performed on separate machine/processors}
\usage{
concatenate_raw_sensitivity_analysis_results(model, ident.list,
  combined.ident = "COMBINED", postprocess = TRUE)
}
\arguments{
\item{model}{Model object for the raw data to be combined}

\item{ident.list}{A vector of text variables corresponding to the "model.ident" identifiers for each of the files to concatenated (list must be length 2 or greater)}

\item{combined.ident}{Identifier for the combined set of data, equivalent to the model.ident argument in read_model(). Default ="COMBINED"}

\item{postprocess}{(TRUE or FALSE, default=TRUE) Process the results through to a final sorted list of parameter sensitivies for plotting, or just produce the combined raw results. The reason for NOT processing would be if there are further run results stil to be combined with the set produced by this function.}
}
\value{
CSV files of parameter vectors for each model run, likelihoods and Elementary Effects for each run. If the argument postprocess=TRUE then also a dtaframe and CSV file of the parameter list sorted by EE_mean, from the combination of multiple input data sets
}
\description{
The function Sensitivity_analysis_StrathE2E() is extremely time consuming so it makes sense to share the 
load across multiple processors and combine the results afterwards. This function concatenates the raw outputs from two separate runs
of Sensitivity_analysis_StrathE2E() into single a single file.
}
\details{
Sensitivity_analysis_StrathE2E() generates two output files per run - OAT_results-*.csv, and OAT_parameter_values-*.csv, where * is
an identifying text string set by an argument of the read_model() function, This concatenation function combines both of these types of files.

The files to be combined must be transferred into the same folder, and this is where the new combined file will be placed.
The path to locate the files is set in the read_model() function. If not specified it is assumed that the files are located in the
default /results/Modelname/Variantname folder in the current user workspace.

The list of files to be combined (any number > 1) is defined by a vector of their "model.ident" identifiers ("ident.list" argument). 
The first-named model.ident inthe vector should correspond to a run of the Sensitivity_analysis_StrathE2E() function with the argument coldstart=TRUE. Thus forces the
first trajectory of sensitivity test to be performed on the maximum-likelihood parameter set loaded with the read_model() function. Thus is important
for the post-processing stage of the analysis which needs to be performed on the combined results.

When combining the files, the function creates a seamless sequence of trajectory identifiers through the combined data, beginning from 1 for the first trajectory 
of the first set.

If for any reason there are more than two separate sets of Sensitivity_analysis_StrathE2E() run results to be combined, then 
post-processing of the final combined file can be delayed with the 'postprocess' argument until the last concatenation when all the data have been gathered
together - using the function process_sensitivity_analysis_results_offline().

A separate function plot_sensitivity_analysis_results() produces a graphical representation of the post-processed results of the combined data.
}
\examples{
# The example here assumes that three sets of raw results data have been previously
# generated by runs of the Sensitivity_analysis_StrathE2E() function, with the model.ident values
# assigned as "RUN1", "RUN2" and "RUN3", and that these have been gathered together in the same
# /results/Modelname/Variantname folder.

# Load the model name and version for the data to be combined :
# E.g. ... model <- read_model("North_Sea", "2003-2013")
sens_results <- concatenate_raw_sensitivity_analysis_results(model, ident.list=c("RUN1","RUN2","RUN3"), combined.ident="TESTCOMB", postprocess=TRUE)
head(sens_results)
}
\references{
Morris, M.D. (1991). Factorial sampling plans for preliminary computational experiments. Technometrics, 33, 161-174.
}
\seealso{
\code{\link{read_model}} , \code{\link{Sensitivity_analysis_StrathE2E}} , \code{\link{process_sensitivity_analysis_results_offline}} , \code{\link{plot_sensitivity_analysis_results}}
}
