% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_model.R
\name{copy_model}
\alias{copy_model}
\title{Make a copy of a named model/variant and documentation in a user defined workspace}
\usage{
copy_model(model.name, model.variant, dest.path = "Models",
  user.path = "")
}
\arguments{
\item{model.name}{Name of model to copy}

\item{model.variant}{Name of model variant to copy}

\item{dest.path}{Destination folder to write a copy of model, which will be created if necessary. The default is "Models" in current folder}

\item{user.path}{Path to users top level model folder if copying a user model}
}
\value{
A copy of an entire model/variant and the associated documentation folder in the designated workspace
}
\description{
Make a copy of a named model/variant and documentation in a user defined workspace
}
\examples{
#Copy the 2003-2013 version of the North Sea model supplied with the package into a user workspace (Windows OS):
copy_model("North_Sea", "2003-2013",
           dest.path="C:/Users/username/Documents/Models")

#Copy a user model into a user workspace  (Windows OS):
copy_model("Modelname", "Modelvariant",
           dest.path="C:/Users/username/Documents/Folder2/Models",
           user.path="C:/Users/username/Documents/Folder1/Models")
}
\seealso{
\code{\link{list_models}}, \code{\link{read_model}}
}
