% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/plot_final_year_migration_data_with_credible_intervals.R
\name{plot_final_year_migration_data_with_credible_intervals}
\alias{plot_final_year_migration_data_with_credible_intervals}
\title{Plots of active migration fluxes over the final year of a simulation generated by the Monte_Carlo_StrathE2E() function}
\usage{
plot_final_year_migration_data_with_credible_intervals(model,
  use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Graphical display in a new graphics window
}
\description{
Create a multi-panel plot showing the credible intervals of inshore-offshore net active migration fluxes over the final year of a simulation
generated by the Monte_Carlo_StrathE2E() function.
}
\details{
Daily interval post-processed data from the Monte_Carlo_StrathE2E() function are stored in the file
/results/Modelname/Variantname/CredInt/CredInt_processed_daily_migrations-*.csv, where * represents the model run identifier
(model.ident) text embedded in the R-list object created by the read_model() function.

Optionally the function can read an example data set for one of the two North Sea model variants supplied with the package.

Each panel of the plot shows a time-series of the net flux densities (mMN per m2 sea surface area per day) of one
of the migratory guilds in the model (all three guilds of fish, birds, pinnipeds and cetaceans) between the inshore and offshore zones
of the model, over the final year of a run. These migration fluxes are the dynamic product of gradients in the ratio of food
concentration to predator concentration across the inshore-offshore boundary.

In each plot the x-axis represents day of the year over an annual cycle. The y-axis represents flux density of a migratory guild
(mMN/m2/d). Results from the maximum likelihood model are shown by a red line. The median of the credible values distribution
is shown my a solid black line. A grey-shaded area indicates the 50% credible interval (spanning quartiles of the cumulative likelihood
of simulated values). Black dashed lines span the 99% credible interval.

Positive values of the net migration flux indicate net movement from the offshore to inshore zone. Negative values indicate net
movement from inshore to offshore.

For details of how the distribution of credible output values from StrathE2E are calculated see the help information for the Monte_Carlo_StrathE2E() function.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")

# Either run the Monte_Carlo_StrathE2E() to generate some results, or use the internal example data

# Plot the final year migration flux time series on screen:
plot_final_year_migration_data_with_credible_intervals(model, use.example=TRUE)

# To direct the graph output to a file rather than the screen, wrap the plot_final_year_MIGFLUX_data_with_credible_intervals() function call in a graphical device call:
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=6,height=4)      # or jpeg("plot.jpg"), png("plot.png")
	plot_final_year_migration_data_with_credible_intervals(model, use.example=TRUE)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{Monte_Carlo_StrathE2E}}, \code{\link{plot_final_year_time_series_data_with_credible_intervals}} , \code{\link{plot_inshore_vs_offshore_anavmass_with_credible_intervals}}
}
