% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/plot_final_year_trophic_data_with_credible_intervals.R
\name{plot_final_year_trophic_data_with_credible_intervals}
\alias{plot_final_year_trophic_data_with_credible_intervals}
\title{Plots of credible value distributions mean trophic level and omnivory index generated by the Monte_Carlo_StrathE2E() function}
\usage{
plot_final_year_trophic_data_with_credible_intervals(model,
  use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Graphical display in a new graphics window
}
\description{
Create a two-panel plot showing the credible intervals of whole domain mean trophic level and omnivory index of each food web component over the final year of a simulation
generated by the Monte_Carlo_StrathE2E() function. The trophic indices originate from the NetIndices R- package.
}
\details{
Post-processed data from the Monte_Carlo_StrathE2E() function are stored in the file
/results/Modelname/Variantname/CredInt/CredInt_processed_networkresults-*.csv, where * represents the model run identifier
(model.ident) text embedded in the R-list object created by the read_model() function.

Optionally the function can read an example data set for one of the two North Sea model variants supplied with the package.

The plots shows a set of box and whisker plots of a) mean trophic level, and b) omnivory index derived by the NetIndices package
from the annual flux-matrix for the final year of each model run. In each case the maximum likelihood model is shown by a red bar. The median of
the credible values distribution
is shown by a black bar. The box indicates the 50% credible interval (spanning quartiles of the cumulative likelihood
of simulated values). Whiskers span the 99% credible interval.

Within each panel the box and whisker plots for each food web component are ordered by the maximum likelihood mean trophic level.

NOTE that the NetIndices package assigns detritis and dissolved nutrients as trophic level 1, so that the phytoplankton and macrophytes are assigned trophic level 2.

For details of how the distribution of credible output values from StrathE2E are calculated see the help information for the Monte_Carlo_StrathE2E() function.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")

# Either run the Monte_Carlo_StrathE2E() to generate some results, or use the internal example data

# Plot the final year trophic data on screen:
plot_final_year_trophic_data_with_credible_intervals(model, use.example=TRUE)

# To direct the graph output to a file rather than the screen, wrap the plot_final_year_trophic_data_with_credible_intervals() function call in a graphical device call:
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=4,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	plot_final_year_trophic_data_with_credible_intervals(model, use.example=TRUE)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{Monte_Carlo_StrathE2E}}, \code{\link{plot_final_year_time_series_data_with_credible_intervals}} , \code{\link{plot_inshore_vs_offshore_anavmass_with_credible_intervals}}
}
