% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_for_each_gear_catch_by_guild.R
\name{plot_for_each_gear_catch_by_guild}
\alias{plot_for_each_gear_catch_by_guild}
\title{Plots of annual integrated catch compositions by each gears for the final year of a model run}
\usage{
plot_for_each_gear_catch_by_guild(model, results)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{results}{R-list object containing model results generated by the StrathE2E() function}
}
\value{
Graphical display in a new graphics window
}
\description{
Multi-panel bar-plots of the annual integrated catch compositions by each gears for the final year of a model run generated by the StrathE2E() function
}
\details{
The function plots a multi-panel page of bar-plots of guild compositions of the annual integrated catches
by each of the the gears in the fishing fleet model (up to 12, user defined).

Each panel represesents a single gear. In each panel, the x-axis represents the 10 guilds in the ecology model which are potentially catchable, and the y-axis is the annual integrated catch.
For each guild there are two bars corresponding to the inshore and offshore zones. Each bar is subdivided into landed and discarded components of the catch.
Green and blue sections are offshore and inshore landings respectively; black and grey sections are offshore and inshore discards respectively.

Units for the catch are mMN/m2/year
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "2003-2013")
#Run the model and generate the results object
results <- StrathE2E(model,nyears=10)
# Plot the time series of annual landings and discards
plot_for_each_gear_catch_by_guild(model, results)

# Time series plot of state varaiables in a new window leaving any existing windows open
dev.new()
plot_for_each_gear_catch_by_guild(model, results)

#Direct the graphics output to a file (Windows OS)... 
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=8,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	plot_for_each_gear_catch_by_guild(model, results)
dev.off()

# Read the North Sea/1970-1999 model and set the identifier for output files to "Baseline", run the model and plot the catch composition of the gears
model <- read_model("North_Sea", "1970-1999",model.ident="Baseline")
results <- StrathE2E(model,nyears=10)
plot_for_each_gear_catch_by_guild(model, results)
# Create a new scenario version of the North Sea/1970-1999 model by increasing the activity rate of gear 1 (pelagic trawls and seines) by a factor of 2
model$data$fleet.model$gear_mult[1] <- 2
model$setup$model.ident <- "gear1x2"        # Set a new identifier for the outputs
results <- StrathE2E(model,nyears=10)
dev.new()                                   # Open a new graphics window   
plot_for_each_gear_catch_by_guild(model, results)
}
\seealso{
\code{\link{read_model}}, \code{\link{StrathE2E}}, \code{\link{plot_time_series_annual_land_disc}} , \code{\link{plot_for_each_guild_catch_by_gear}}
}
