% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/plot_inshore_vs_offshore_anavmass_with_credible_intervals.R
\name{plot_inshore_vs_offshore_anavmass_with_credible_intervals}
\alias{plot_inshore_vs_offshore_anavmass_with_credible_intervals}
\title{Plots of annual average inshore and offshore mass densities generated a Monte_Carlo StrathE2E simulation}
\usage{
plot_inshore_vs_offshore_anavmass_with_credible_intervals(model,
  use.example = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{use.example}{(TRUE or FALSE) Option to use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE)}
}
\value{
Graphical display in a new graphics window
}
\description{
Create a plot showing the distribution of credible values of annual average inshore and offshore mass densities over the final year of a simulation generated by the Monte_Carlo_StrathE2E() function.
}
\details{
Daily interval post-processed data from the Monte_Carlo_StrathE2E() function are stored in the files
/results/Modelname/Variantname/CredInt/CredInt_processed_AAMresults_offshore-*.csv and CredInt_processed_AAMresults_inshore-*.csv,
where * represents the model run identifier (model.ident) text embedded in the R-list object created by the read_model() function.

Optionally the function can read an example data set for one of the two North Sea model variants supplied with the package.

The format of the output is a single panel with rows of horizintally orientated box-and-whisker plots. Each row represents a different
state variable in the model (bacteria and detritus, phytoplankton etc etc). Each row consists of two box-and-whiskers, one (red) fof the offshore
zone and the other (blue) for the inshore zone. The data represented are distributions of credible values of the mass densities (mMn/m2) of each variable, averaged
over the final year of a model run. The distribution of credible values is derived from
a Monte Carlo simulation scheme performed by the Monte_Carlo_StrathE2E() function.

In each plot the central tick mark of the box-and-whisker represents the median mass density, the box represents the 50% credible interval (spanning quartiles of the cumulative likelihood
of simulated values) and the whiskers represent the 99% credible intervals.

For details of how the distribution of credible output values from StrathE2E are calculated see ?Monte_Carlo_StrathE2E.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "1970-1999")

# Either run the Monte_Carlo_StrathE2E() to generate some results, or use the internal example data

# Plot the final year time series on screen:
plot_inshore_vs_offshore_anavmass_with_credible_intervals(model, use.example=TRUE)

# To direct the graph output to a file rather than the screen, wrap the plot_inshore_vs_offshore_anavmass_and_credible_intervals() function call in a graphical device call:
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=6,height=4)      # or jpeg("plot.jpg"), png("plot.png")
	plot_inshore_vs_offshore_anavmass_with_credible_intervals(model, use.example=TRUE)
dev.off()
}
\seealso{
\code{\link{read_model}}, \code{\link{Monte_Carlo_StrathE2E}}, \code{\link{plot_final_year_time_series_data_with_credible_intervals}} , \code{\link{plot_final_year_migration_data_with_credible_intervals}}
}
