% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sediment_habitats_final_year.R
\name{plot_sediment_habitats_final_year}
\alias{plot_sediment_habitats_final_year}
\title{Plots of inshore and offshore sediment habitat state variables}
\usage{
plot_sediment_habitats_final_year(model, results)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{results}{R-list object containing model results generated by the StrathE2E() function}
}
\value{
Graphical display in a new graphics window
}
\description{
Multi-panel time series plots of inshore and offshore sediment habitat state variables for the final year of a model run generated by the StrathE2E() function
}
\details{
The function plots a multi-panel page of time series plots of daily values of nutrients and detritus for the various seabed sediment classes in the inshore and offshore zones, for the final year of a model run.

Units of the plotted varaiables are mass concentrations, scaled to sea surface area or layer volume, ie. mMN/m2 or mMN/m3,
except for sediment organic nitrogen content which is expressed as percentage of sediment dry weight to conform with the convention for presenting observational data.
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "2003-2013")
#Run the model and generate the results object
results <- StrathE2E(model,nyears=10)
# Plot the final year of low trophic level outputs
plot_sediment_habitats_final_year(model, results)

# Time series plot of state varaiables in a new window leaving any existing windows open
dev.new()
plot_sediment_habitats_final_year(model, results)

#Direct the graphics output to a file (Windows OS)... 
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=8,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	plot_sediment_habitats_final_year(model, results)
dev.off()

# Read the North Sea/1970-1999 model and set the identifier for output files to "Baseline", run the model and plot the final year sediment haabitat output
model <- read_model("North_Sea", "1970-1999",model.ident="Baseline")
results <- StrathE2E(model,nyears=10)
plot_sediment_habitats_final_year(model, results)
# Create a new scenario version of the North Sea/1970-1999 model by increasing the activity rate of gears 4,5,6,8 and 9 (all sea-bed contact gears) by a factor of 2
model$data$fleet.model$gear_mult[c(4,5,6,8,9)] <- 2
model$setup$model.ident <- "bottomgearsx2"        # Set a new identifier for the outputs
results <- StrathE2E(model,nyears=10)
dev.new()                                   # Open a new graphics window   
plot_sediment_habitats_final_year(model, results)
}
\seealso{
\code{\link{read_model}}, \code{\link{StrathE2E}}, \code{\link{plot_final_year}} , \code{\link{plot_final_year_LTL_inshore_vs_offshore}} , \code{\link{plot_final_year_HTL_inshore_vs_offshore}}
}
