% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_time_series_annual_land_disc.R
\name{plot_time_series_annual_land_disc}
\alias{plot_time_series_annual_land_disc}
\title{Time series plots of annual integrated catches from the inshore and offshore zones}
\usage{
plot_time_series_annual_land_disc(model, results)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the read_model() function}

\item{results}{R-list object containing model results generated by the StrathE2E() function}
}
\value{
Graphical display in a new graphics window
}
\description{
Multi-panel time series bar-plots of annual integrated catch of each living guild in the inshore and offshore zones over the ful length of a model run generated by the StrathE2E() function
}
\details{
The function plots a multi-panel page of time series bar-plots of annual integrated catches
of the potentially catchable guilds in the ecology model:
macrophytes, carnivorous zooplankton, suspension/deposit and carnivore/scavenge feeding benthos, planktivorous, demersal and migratory fish,
birds, pinnipeds and cetaceans.

Each panel represents a single guild. In each plot panel, the x-axis represents the sequence of years of the model run, and the y-axis is the annual integrated catch.
For each year there are two bars corresponding to the inshore and offshore zones. Each bar is subdivided into landed and discarded components ofthe catch.
Green and blue sections are offshore and inshore landings respectively; black and grey sections are offshore and inshore discards respectively.

Units for the catch are mMN/m2/year
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package:
model <- read_model("North_Sea", "2003-2013")
#Run the model and generate the results object
results <- StrathE2E(model,nyears=10)
# Plot the time series of annual landings and discards
plot_time_series_annual_land_disc(model, results)

# Time series plot of state varaiables in a new window leaving any existing windows open
dev.new()
plot_time_series_annual_land_disc(model, results)

#Direct the graphics output to a file (Windows OS)... 
pdf("C:/Users/username/Documents/Foldername/plot.pdf",width=8,height=6)      # or jpeg("plot.jpg"), png("plot.png")
	plot_time_series_annual_land_disc(model, results)
dev.off()

# Read the North Sea/1970-1999 model and set the identifier for output files to "Baseline", run the model and plot the time series of annual landings and discards
model <- read_model("North_Sea", "1970-1999",model.ident="Baseline")
results <- StrathE2E(model,nyears=10)
plot_time_series_annual_land_disc(model, results)
# Create a new scenario version of the North Sea/1970-1999 model by increasing the activity rate of gear 1 (pelagic trawls and seines) by a factor of 2
model$data$fleet.model$gear_mult[1] <- 2
model$setup$model.ident <- "gear1x2"        # Set a new identifier for the outputs
results <- StrathE2E(model,nyears=10)
dev.new()                                   # Open a new graphics window   
plot_time_series_annual_land_disc(model, results)
}
\seealso{
\code{\link{read_model}}, \code{\link{StrathE2E}}, \code{\link{plot_for_each_guild_catch_by_gear}} , \code{\link{plot_for_each_gear_catch_by_guild}}
}
