#
# e2e_get_parmdoc.R
#
#' Get documentation on the parameters in the model.
#'
#' Provides access to documentation on the parameters in the model in the form of a dataframe.
#'
#' The full range of inputs to the model includes both numeric values which are constant over the during a run, and values which vary over time during a run according to an externally provided schedule. We refer to the latter as 'drivers', but they are all parameters nontheless.
#' The constant parameters are divided into categories according to whether they are associated with the ecology model, the fishing fleet model, and whether they are available for optimization or not.
#'
#' This function downloads documentation on the full range of parameters in the form of a dataframe which can be used to form labels in user-generated code. The parameters are identified by a numeric value linked to 6 different classes of parameter.
#'
#' Note that the function does not supply the numeric values of parameters for any given model setup. These are available in the model definition object generated by the function e2e_read().
#'
#' @param id Integer value denoting the class of parameters details to be downloaded. Choose from: 0 = fitted ecology, 1 = fixed ecology, 2 = fishing fleet, 3 = harvest ratios, 4 = environmental drivers, 5 = physical configuration, 9 = all (default = 9).
#'
#' @return dataframe of parameter documentation.
#'
#' @seealso \code{\link{e2e_read}}
#'
#' @export
#'
#' @examples
#' parm_list <- e2e_get_parmdoc(0)       # Get documentation on the fitted ecology parameters       
#' parm_list <- e2e_get_parmdoc(9)       # Get documentation all parameters
#' parm_list <- e2e_get_parmdoc()        # Get documentation all parameters
#'
# ---------------------------------------------------------------------
# |                                                                   |
# | Author: Mike Heath                                                |
# | Department of Mathematics and Statistics                          |
# | University of Strathclyde, Glasgow                                |
# |                                                                   |
# | Date of this version: May 2020                                    |
# |                                                                   |
# ---------------------------------------------------------------------

e2e_get_parmdoc <- function(id=9) {

allowed.list <- c(0,1,2,3,4,5,9)
if(id %in% allowed.list==FALSE){
	cat("The argument 'id' must be one of the following... \n")
	cat("    0 = fitted ecology \n")
	cat("    1 = fixed ecology \n")
	cat("    2 = fishing fleet \n")
	cat("    3 = harvest ratios \n")
	cat("    4 = environmental drivers \n")
	cat("    5 = physical configuration \n")
	cat("    9 = all parameters (default) \n")
	cat("    unrecognised value entered - reverting to the default \n")
        id<-9
}

parameter.details.data.file <- system.file("extdata/Internal.data", "StrathE2E_parameter_list.csv", package="StrathE2E2", mustWork = TRUE)
parameter.details <- read.csv(parameter.details.data.file,header=TRUE)
	
if(id==9) selected_class<-parameter.details

if(id < 9) selected_class<-parameter.details[which(parameter.details$fixfit==id),]

return(selected_class)

}



