% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_extract_start.R
\name{e2e_extract_start}
\alias{e2e_extract_start}
\title{Extract the values of all the state variables at the end of a model run and format for use as new initial conditions.}
\usage{
e2e_extract_start(model, results, csv.output = TRUE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the e2e_read() function.}

\item{results}{R-list object generated by the e2e_run() function.}

\item{csv.output}{Logical. If FALSE then disable writing of csv output files - useful for testing (default=TRUE).}
}
\value{
Table of state variable values from the end of a run formatted as required for input to a new model run as initial conditions. By default these data are also returned as a csv file to the Param folder of the current model, unless this is one of the North Sea model versions within the package.
}
\description{
The function saves the state of the model at the end of a run (using the e2e_run() function) for use as initial conditions in future runs. This enables, 
for example, the model to be run for a long time to attain a stationary state, and then restarted in that state.
}
\details{
Initial conditions for a model run are held in the /Param folder of the Model/Variant path specified in the e2e_read()
function call used to define a run. By default, the function attampts to write the model end-state file back to this /Param folder.
However, the package folders are read-only so if e2e_read() has been specified to load an internally provided Model/Variant then 
the output will revert to the currently specified results folder instead. To fix this, copy the required package model to a user
workspace using the e2e_copy() function and re-run.

The new initial conditions file will have a name initial_values-*.csv, where * is the model.ident text identifier specified in e2e_read()
To source the new initial conditions in a subsequent model run, edit the MODEL_SETUP.csv file in the required /Models/Variant folder
}
\examples{
# Copy the 2003-2013 version of the North Sea model supplied with the package to a
# user workspace (Windows OS):
\dontrun{
ee2_copy("North_Sea", "2003-2013",
           dest.path="C:/Users/username/Documents/Models")
model <- e2e_read("North_Sea", "2003-2013", 
      user.path="C:/Users/username/Documents/Models", model.ident="TEST")
results <- e2e_run(model, nyears=5)
new_initial <- e2e_extract_start(model,results)
}
}
\seealso{
\code{\link{e2e_read}}, \code{\link{e2e_run}}
}
