test_that("test simulated annealing code (HR scaling parameters) produces correct output structure", {

#-----------------------------------------------------------------------------------------------------------------
#
# This test runs the 1970-1999 version of the simullated annealing (HR scaling parameters) function to determine
# whether the ouputs conform to the expected structure.
#
# The test uses the North Sea model which is provide in the package, with the csv.output argument set to FALSE
#
# The returned object should be a list of 3 elements, each of one object.
#
# We test various attributes of the list and its contents to check that they are as expected.
#
#------------------------------------------------------------------------------------------------------------------

# Read the internal 1970-1999 North Sea model
model<-e2e_read(model.name="North_Sea",
                   model.variant="1970-1999",
                   model.ident="TEST")
nyears<-3
n_iter<-10
 test_run<-e2e_optimize_hr(model, nyears=nyears, n_iter=n_iter, start_temperature=0.5, csv.output=FALSE,runtime.plot=FALSE)

#--------------

#Extract some attributes of the returned list object
n_1stlev <- nrow(summary(test_run))  # Number of 1st level objects in the list - should =3

#--------------

#Extract attributes of the first 2 elements of the list
nr_prop<-nrow(test_run$parameter_proposal_history) # number of rows of data in the proposal history - should = n_iter
nr_accp<-nrow(test_run$parameter_accepted_history) # number of rows of data in the proposal history - should = n_iter

proposal_lik <- test_run$parameter_proposal_history$lik  # Likelihoods for proposed parameters on each iteration
accepted_lik <- test_run$parameter_accepted_history$lik  # Likelihoods for accepted parameters on each iteration
dif_lik <- accepted_lik-proposal_lik   # accepted values should never be less than proposed values
nneg<-length(which(dif_lik<0))  # nneg should=0

#--------------

# Find out if the final parameter objects generated by the annealing process match the structure expected for the model inputs
model.path <-   model$setup$model.path
#setupdata  <-	read.model.setup(model.path)			# Models/Model/Variant/MODEL_SETUP.csv

# setupdata[19] = "harvest_ratio_multiplier.csv"

#pf_HRmult<-readcsv(model.path, PARAMETERS_DIR, setupdata[19])
pf_HRmult<- get.model.file(model.path, PARAMETERS_DIR, file.pattern=HARVEST_RATIO_SCALING_VALUES)

#--------------

#new and expected row and column numbers for the preference matrix
nc_new_HRmult <- ncol(test_run$new_parameter_data) # Columns in the new parameter data
nr_new_HRmult <- nrow(test_run$new_parameter_data) # Rows in the new parameter data
nc_exp_HRmult <- ncol(pf_HRmult)  # Columns in the existing parameter file
nr_exp_HRmult <- nrow(pf_HRmult)  # Rows in the existing parameter file

nc_new_HRmult
nc_exp_HRmult
nr_new_HRmult
nr_exp_HRmult

#--------------


#Implement the testthat checks

expect_equal(n_1stlev, 3)
expect_equal(nr_prop, n_iter)
expect_equal(nr_accp, n_iter)
expect_equal(nneg,0)
expect_equal(nc_new_HRmult,nc_exp_HRmult)
expect_equal(nr_new_HRmult,nr_exp_HRmult)

})
