% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_plot_fdrivers.R
\name{e2e_plot_fdrivers}
\alias{e2e_plot_fdrivers}
\title{Plot shaded-grid-cell diagrams of the distributions of fishing-related drivers across gears, guilds and seabed habitats.}
\usage{
e2e_plot_fdrivers(model, selection)
}
\arguments{
\item{model}{R-list object defining the model configuration corresponding to the data to be plotted, compiled by the e2e_read() function.}

\item{selection}{Text string from a list identifying the class of fishing-related driving data to be plotted. Select from: "ACTIVITY", "ABRASION", "HARVESTR", "DISCARDS", "OFFAL". Remember to include the phrase within "" quotes.}
}
\value{
Graphical display in a new graphics window and a list object comprising an array of the data in the plot and the axis labels.
}
\description{
Select from a list of fishing-related drivers of the model (gear activity rates, seabed abrasion rates, harvest ratios, discard rates and offal generation rates), and 
generate a shaded-grid-cell diagram showing the distribution across gears, guilds and seabed habitats.
}
\details{
\strong{Details relating to fishing activity distributions:}

The function plots a matrix of seabed habitats vs fishing gears with each cell shaded to indicate activity density (white = 0, purple = high).

The spatial distribution of fishing gear activity in the model is defined by two input data sets:
\itemize{
  \item Vector of whole domain activity density of each fishing gear (s/d per m2 of whole model domain)
  \item Matrix of the proportional distribution of whole domain activity density of each gear (rows) across seabed habitats (columns)
}

The activity density of each gear in each habitat is then obtained by multiplying the whole domain activity density into the proportional
distribution matrix, and dividing by the area-proportions of habitats in the domain. The units of habitat-specific activity density
are then (s/d/m2).

The vector of area-proportions of each habitat in the model domain is part of the moldel configuration parameter set.

The calculation take account of any activity multipliers set in the csv inputs to be applied to the activity density.

When interpreting patterns of activity density, bear in mind that the impact (harvest ratio, seabed abrasion) per unit activity can vary considerably between gears.

\strong{Details relating to seabed abrasion rate distributions:}

The function plots a matrix of seabed habitats vs fishing gears with each cell shaded to indicate abrasion area ratio (log(10) scaled proportion of habitat area abraded per day; white = 0, purple = high).

The spatial distribution of seabed abrasion in the model is defined by three input data sets:
\itemize{
  \item Vector of whole domain activity density of each fishing gear (s/d per m2 of whole model domain)
  \item Matrix of the proportional distribution of whole domain activity density of each gear (rows) across seabed habitats (columns)
  \item Vector of seabed abrasion rate of each fishing gear (m2/s)
}

The activity density of each gear in each habitat is then obtained by multiplying the whole domain activity density into the proportional
distribution matrix, and dividing by the area-proportions of habitats in the domain. The units of habitat-specific activity density
are then (s/d/m2).

The product of activity density per gear and habitat and gear abrasion rate is then the abrasion area ratio, or abrasion rate (m2/m2/d)

The vector of area-proportions of each habitat in the model domain is part of the moldel configuration parameter set.

The calculation take account of any activity multipliers set in the csv inputs to be applied to the activity density.

\strong{Details relating to harvest ratio distributions:}

The function plots a matrix of the values of harvest ratio (proportion of exploitable biomass of each guild capatured per day) for each guild in the ecology model (columns) arising from the activity of each gear (rows). 
Hence each row represents the selectivity pattern of each gear with respect to guilds.
Cells in the matrix are shaded to indicate log(10) transformed harvest ratio (colour gradient: white = 0, purple = high).

Harvest ratio is calculated by the fishing fleet model and piped into the ecology model. The fleet model takes inputs of activity density by each gear,
and a matrix of fishing power, to calculate effort (effort = activity * power). Harvest ratio is assumed to be lineally related to effort by a scaling
coefficient which is input as a parameter to the fleet model.

Note that the visualization of harvest ratio generated by this function is based on the csv input data to the fleet model (including any multipliers to be applied to
either fishing activity or harvest ratio scaling parameters). However, it does not reflect any effects on harvest ratio arising from discarding scenarios since
these are dynamic and generated at run-time within the ecology model.

\strong{Details relating to discard rate distributions:}

The function plots a matrix of the values of discard rate (proportion by weight of catch discarded at sea prior to any at-sea processing (evisceration)) for each guild in the ecology model (columns) arising from the activity of each gear (rows). 
Cells in the matrix are shaded to indicate discard rate (range 0 - max; colour gradient: white = 0, purple = high) on a linear scale.

It is possible (and allowable) for the discard rate of a gear-guild combination to be set as a positive number in the 'fishing_discards' csv input file, but nevertheless the
the catching power settings in the corresponding 'fishing_power' file to be set to zero - in other words the given gear does not actually catch the given guild. In such cases this
function resets the discard rate to NA for plotting purposes.

Note that the visualization of discard rate generated by this function is based on the csv input data to the fleet model. 
Hence, it does not reflect any effects on discard rate arising from discarding scenarios configured in the fleet model input 
since these are dynamic and generated during run-time within the ecology model.

\strong{Details relating to offal generation rate distributions:}

The function plots a matrix of the values of offal generation rate (i.e. the proportion by weight of total catch which is returned to the sea as viscera after processing) for each guild (columns) by each gear (rows). 
Cells in the matrix are shaded to indicate offal generation rate (range 0 - max; colour gradient: white = 0, purple = high) on a linear scale.

The offal generation rate is a quantity derived from three input variables to the fishing fleet model:
\itemize{
  \item Matrix of the discard rate (proportion of catch weight discarded without being processed) for each guild and gear; (D); (input file '/Param/fishing_discards*.csv')
  \item Matrix of the processing-at-sea rate (proportion of retained catch which is processed) for each guild and gear; (P); (input file '/Param/fishing_processing*.csv')
  \item Proportion by weight of viscera in the retained catch (assumed constant across all guilds); (V); (value in input file '/Param/fishing_fleet_*.csv')
}

The offal generation rate is then given by (1 - D).P.V

It is possible (and allowable) for the discard rate and processing-at-sea rate of a gear-guild combination to be set as positive numbers in the relevant input files, but nevertheless the
the catching power settings in the corresponding 'fishing_power' file to be set to zero - in other words the given gear does not actually catch the given guild. In such cases this
function resets the discard rate and processing-at-sea rate to NA for plotting purposes.

Note that the visualization of offal rate generated by this function is based on the csv input data to the fleet model. 
Hence, it does not reflect any effects on discard rate arising from discarding scenarios configured in the fleet model input 
since these are dynamic and generated during run-time within the ecology model.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package, run, and
# generate a plot:
model <- e2e_read("North_Sea", "2003-2013")
plotted_data<-e2e_plot_fdrivers(model, selection="ACTIVITY")
str(plotted_data,max.level=1)

}
\seealso{
\code{\link{e2e_read}}, \code{\link{e2e_run}}, \code{\link{e2e_plot_edrivers}}
}
