% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_plot_trophic.R
\name{e2e_plot_trophic}
\alias{e2e_plot_trophic}
\title{Plot showing the annual mean trophic level index, and the omnivory index of each guild during the final year of a model run, optionally with credible intervals.}
\usage{
e2e_plot_trophic(model, ci.data = FALSE, use.saved = FALSE,
  use.example = FALSE, results = NULL)
}
\arguments{
\item{model}{R-list object defining the baseline model configuration used to generate the data and compiled by the e2e_read() function.}

\item{ci.data}{Logical. If TRUE plot credible intervals around model results based on Monte Carlo simulation with the e2e_run_mc() function (default=FALSE).}

\item{use.saved}{Logical. If TRUE use data from a prior user-defined run held as csv files data in the current results folder (default=FALSE).}

\item{use.example}{Logical. If TRUE use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE).}

\item{results}{R-list object of model output generated by the e2e_run() function. Only needed if ci.data=FALSE, use.saved=FALSE and use.example=FALSE. (Default=NULL).}
}
\value{
Graphical display in a new graphics window.
}
\description{
Generate a two-panel plot showing: (upper panel) the mean trophic level of each guild in the ecology model, and (lower panel) the omnivory index of each guild. The data are 
generated by the NetIndices package from a flow matrix of nutrient fluxes through, into and out of the ecosystem during the final year of a run. The data are generated
automatically as part of the output from every call of the e2e_run() function. The default is to plot data from a single model run but if available, 
credible intervals of model output from a Monte Carlo analysis can be plotted instead.
}
\details{
If credible intervals are plotted these are displayed as box-and-whiskers. The box spans 50% of the likelihood distribution of values and the whiskers 99%. The median is shown 
by a black tick mark and the maximum likelihhod model by a red tick mark.

Arguments determine the source of model data to be plotted. These can be outputs from a single model run with data held in memory as a list object or in a saved csv file, or from 
a Monte Carlo simulation (using the function e2e_run_mc()) to estimate credible intervals of model outputs. Generation of credible interval data is a long computing task, so 
example data for the North Sea model provided with the package are available as illustration.
}
\examples{
# Load the 1970-1999 version of the North Sea model supplied with the package, run, and
# generate a plot:
model <- e2e_read("North_Sea", "1970-1999")
results <- e2e_run(model, nyears=3)
e2e_plot_trophic(model, results=results)
# Alternatively, plot the same data from a csv file saved by the e2e_run() function:
dev.new()
e2e_plot_trophic(model, use.saved=TRUE)

# For the same model as supplied with the package, plot the example data with credible intervals:
dev.new()
e2e_plot_trophic(model, ci.data=TRUE, use.example=TRUE)

# Direct the graphics output to a file (Windows OS)... 
# or jpeg("plot.jpg"), png("plot.png")
pdf("plot.pdf",width=6,height=8)
e2e_plot_trophic(model, ci.data=TRUE, use.example=TRUE)
dev.off()

}
\seealso{
\code{\link{e2e_read}}, \code{\link{e2e_run}}, \code{\link{e2e_run_mc}}, \code{\link{e2e_plot_migration}}, \code{\link{e2e_plot_catch}}, \code{\link{e2e_plot_eco}}, \code{\link{e2e_plot_biomass}}
}
