% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_process_sens_mc.R
\name{e2e_process_sens_mc}
\alias{e2e_process_sens_mc}
\title{Post-process already-created data from sensitivity or Monte Carlo analysis runs.}
\usage{
e2e_process_sens_mc(model, selection = "", use.example = FALSE,
  csv.output = TRUE)
}
\arguments{
\item{model}{R-list object defining the model configuration and compiled by the e2e_read() function}

\item{selection}{Text string from a list identifying source of data to bed merged. Select from: "SENS", "MC", referring to sensitivity analysis or Monte Carlo analysis. Remember to include the phrase within "" quotes.}

\item{use.example}{Logical. If TRUE use pre-computed example data from the internal North Sea model rather than user-generated data (default=FALSE).}

\item{csv.output}{Logical. If FALSE then disable writing of csv output files - useful for testing (default=TRUE).}
}
\value{
Dataframe (sensitivity analayis) or list object (Monte Carlo analysis) of the processed data. If csv.output=TRUE then CSV files of the processed data.
}
\description{
The functions e2e_run_sens() and e2e_run_mc() are extremely time consuming so it makes sense to share the 
load across multiple processors in parallel and combine the results afterwards using the function e2e_merge_sens_mc(). Both the original
run functions and the merging function have post-processing options in their workflow. Nevertheless, there may be occasions where it is
necessary to simply post-process an already created raw data set. Hence the need for this function.
}
\details{
The model.ident identifier and folder path for input files must be set in a e2e_read() function call. If enabled, output files will be directed to the same folder.

\strong{Details relating to sensitivity analysis processing:}

The function reads a file of raw sensitivity analysis data (OAT_results-*.csv, where * refers to the identifier model.ident set in the e2e_read() function) from a /results folder
and performs the post-processing that would ordinarily be done automatically within the e2e_run_sens() or e2e_merge_sens_mc() functions. 
The output of the processing is a dataframe (and optionaly a csv file) containing the mean Elementary Effect (EE_mean) and the standard deviation of EE (EE_sd) for each parameter, sorted by the absolute value of EE_mean.
EE_mean is an index of the magnitude of the sensitivity of a parameter, and EE_sd is an index of the extent of interaction with other parameters.

csv output from the function is a file named sorted_parameter_elementary_effects-*.csv in the current folder /results/Modelname/Variantname/

Optionally, the function can read example raw sensitivity data for one of the two North Sea model variants supplied with the package.

For details of how the Elementary Effect values are derived for each parameter see help(e2e_run_sens)

\strong{Details relating to Monte Carlo analysis processing:}

The function e2e_run_mc() generates 11 different output files covering the range of data generated by StrathE2E. The post processing reads all of these and generates quantiles of the 
likelihood weighted distributions of all of the outputs and saves these as credible interval files.

By default, the function writes output to csv files, but this can be disabled by a function argument. The function always returns all of the processed data as
a list object. The function takes a few minutes to run as it has a lot of work to do, especially in processing all of the daily output variables.

Although the e2e_run_mc() function generates large raw data files (11 files total 3.2 Mb per iteration), the processed data are much smaller (13 files total ~4 Mb regardless of
the nunber of iterations.
}
\examples{
# Sensitivity analysis processing:
# Load details of the 1970-1999 version of the North Sea model supplied with the package:
model <- e2e_read("North_Sea", "1970-1999")
# Process the example data for this model variant provided with the package
   sens_results <- e2e_process_sens_mc(model, selection="SENS", use.example=TRUE)
   head(sens_results)

\dontrun{
# Monte Carlo analysis processing
# The example here assumes that raw results data have been previously
# generated by a of the e2e_run_mc() function, with the model.ident value
# assigned as "testdata", or that data from parallel runs have been gathered
# together in the same folder with model.ident="testdata".
# Load the model name and version for the data to be processed :
# e.g. ... model <- e2e_read("North_Sea", "2003-2013", model.ident="testdata")
   mc_results <- e2e_process_sens_mc(model, selection="MC", csv.output=TRUE)
   str(mc_results,max.level=1)
}
}
\seealso{
\code{\link{e2e_read}}, \code{\link{e2e_run_sens}}, \code{\link{e2e_run_mc}}, \code{\link{e2e_merge_sens_mc}} , \code{\link{e2e_plot_sens_mc}}
}
