test_that("test simulated annealing code (activity multiplier parameters, harvest ratio target) produces correct output structure", {

#-----------------------------------------------------------------------------------------------------------------
#
# This test runs the 1970-1999 version of the simullated annealing (ACT multipler, ecosystem target) function to determine
# whether the outputs confirm to the expected structure.
#
# The test uses the North Sea model which is provide in the package, with the csv.output argument set to FALSE
#
# The returned object should be a list of 3 elements, each of one object.
#
# We test various attributes of the list and its contents to check that they are as expected.
#
#------------------------------------------------------------------------------------------------------------------

# Read the internal 1970-1999 North Sea model
model<-e2e_read(model.name="North_Sea",
                   model.variant="1970-1999",
                   model.ident="TEST")
n_traj<-5
n_iter<-100
 test_run<-e2e_optimize_act(model, selection="HR", n_iter=n_iter, start_temperature=0.5, csv.output=FALSE, runtime.plot=FALSE, n_traj=n_traj)
#--------------

#Extract some attributes of the returned list object
n_1stlev <- nrow(summary(test_run))  # Number of 1st level objects in the list - should =5

#n_1stlev

#--------------

#Extract attributes of the first 2 elements of the list
nr_GMstats<-nrow(test_run$gear_mult_results) # number of rows of data in the gearmult stats table = n_traj
nr_GMrelstats<-nrow(test_run$gear_mult_rel_initial) # number of rows of data in the gearmult stats table = n_traj
nr_HRstats<-nrow(test_run$harvest_ratio_results) # number of rows of data in the HR stats table = n_traj
nr_HRrelstats<-nrow(test_run$harvest_ratio_rel_target) # number of rows of data in the HR stats table = n_traj

nc_GMstats<-ncol(test_run$gear_mult_results) # number of columns of data in the gearmult stats table  = 13 (number of gears +1)
nc_GMrelstats<-ncol(test_run$gear_mult_rel_initial) # number of columns of data in the gearmult stats table  = 13 (number of gears +1)
nc_HRstats<-ncol(test_run$harvest_ratio_results) # number of columns of data in the HR stats table = 21 (number of groups *2 + 1)
nc_HRrelstats<-ncol(test_run$harvest_ratio_rel_target) # number of columns of data in the HR stats table = 21 (number of groups *2 + 1)

nr_new_ACTmult<-nrow(test_run$new_parameter_data) # number of rows of data in the HR stats table = 12 (number of gears)
nc_new_ACTmult<-ncol(test_run$new_parameter_data) # number of rows of data in the HR stats table = 12 (number of gears)


#nr_GMstats
#nr_HRstats

#nc_GMstats
#nc_HRstats

#--------------

# Find out if the final parameter objects generated by the annealing process match the structure expected for the model inputs
model.path <-   model$setup$model.path
#setupdata  <-	read.model.setup(model.path)			# Models/Model/Variant/MODEL_SETUP.csv

# setupdata[4] = "fishing_gear_multiplier.csv"

#pf_ACTmult<-readcsv(model.path, PARAMETERS_DIR, setupdata[4])
pf_ACTmult<- get.model.file(model.path, PARAMETERS_DIR, file.pattern=FISHING_ACTIVITY_SCALING_VALUES)


#--------------

#new and expected row and column numbers for the preference matrix
nc_exp_ACTmult <- ncol(pf_ACTmult)  # Columns in the existing parameter file
nr_exp_ACTmult <- nrow(pf_ACTmult)  # Rows in the existing parameter file

#nc_new_ACTmult
#nc_exp_ACTmult
#nr_new_ACTmult
#nr_exp_ACTmult

#--------------


#Implement the testthat checks

expect_equal(n_1stlev, 5)
expect_equal(nr_GMstats, n_traj)
expect_equal(nr_HRstats, n_traj)
expect_equal(nc_GMstats, 13)
expect_equal(nc_HRstats, 21)
expect_equal(nc_new_ACTmult,nc_exp_ACTmult)
expect_equal(nr_new_ACTmult,nr_exp_ACTmult)

})
