% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_copy.R
\name{e2e_copy}
\alias{e2e_copy}
\title{Make a copy of a named model/variant and documentation in a user defined workspace}
\usage{
e2e_copy(model.name, model.variant, dest.path = "Models",
  user.path = "")
}
\arguments{
\item{model.name}{Name of model to copy.}

\item{model.variant}{Name of model variant to copy.}

\item{dest.path}{Destination folder to write a copy of the model, which will be created if necessary. The default is "Models" in the current folder.}

\item{user.path}{Source folder of the model to be copied. If the source is one of the North Sea models provided with the package then user.path="".}
}
\value{
A copy of an entire model/variant and the associated documentation folder in the designated workspace.
}
\description{
Make a copy of a named model/variant and documentation in a user defined workspace
}
\examples{
# Copy the 2003-2013 version of the North Sea model supplied with the package into a
# user workspace (Windows OS):
\dontrun{
e2e_copy("North_Sea", "2003-2013",
          dest.path="C:/Users/username/Documents/Models")

#Copy a user model into a user workspace  (Windows OS):
e2e_copy("Modelname", "Modelvariant",
          dest.path="C:/Users/username/Documents/Folder2/Models",
          user.path="C:/Users/username/Documents/Folder1/Models")
}
}
\seealso{
\code{\link{e2e_ls}}, \code{\link{e2e_read}}
}
