% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_extract_hr.R
\name{e2e_extract_hr}
\alias{e2e_extract_hr}
\title{Extract the values of harvest ratios generated by the fleet model.}
\usage{
e2e_extract_hr(model, results, csv.output = TRUE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the e2e_read() function.}

\item{results}{R-list object generated by the e2e_run() function.}

\item{csv.output}{Logical. If FALSE then disable writing of CSV output files - useful for testing (default=TRUE).}
}
\value{
Dataframe of harvest ratio values, rows = guilds, columns = zone
}
\description{
The function extracts the inshore, offshore and whole-domain values of harvest ratio (proportion of biomass captured per day) for each guild, from the results object generated by the e2e_run() function.
}
\examples{
model <- e2e_read("North_Sea", "1970-1999") 
results<-e2e_run(model, nyears=2)
harvest_ratio_data <- e2e_extract_hr(model,results,csv.output=FALSE)
}
\seealso{
\code{\link{e2e_read}}, \code{\link{e2e_run}}
}
