#
# e2e_info_md.R
#
#' List the available models in a designated workspace.
#'
#' @param models.path Relative path from the current working directory to a folder containing a library of model configurations (typically "Folder/Models"). Setting models.path="" is valid. Default models.path=NULL, meaning read a North Sea model setup from the package folder extdata/Models.
#' @param model.name Name of model to read. Setting models.name="" is valid. Default model.path="North_Sea", meaning read the North Sea model info from the package folder extdata/Models.
#'
#' @return A text object containing the MODEL_INFO data associated with the selected model region.
#'
#' @seealso  \code{\link{e2e_ls}} , \code{\link{e2e_copy}}, \code{\link{e2e_read}} , \code{\link{e2e_info_pk}}
#'
#' @export
#'
#' @examples
#' # View the MODEL_INFO file associated with the North Sea model embedded in the package:
#'     e2e_info_md()
#'
#'     model_info <- e2e_info_md()
#'     model_info
#'
#' # Dummy example to illustrate listing the models/variants in a user defined
#' # workspace. REPLACE "Folder/Models" and "Model.Name" with your own models.path and model.name 
#' # remembering that the folder is relative to the current working directory.
#' #    e2e_info_md("Folder/Models","Model.Name")
#'
#
# ---------------------------------------------------------------------
# |                                                                   |
# | Authors: Michael Heath                                            |
# | Department of Mathematics and Statistics                          |
# | University of Strathclyde, Glasgow                                |
# |                                                                   |
# | Date of this version: October 2022                                |
# |                                                                   |
# ---------------------------------------------------------------------

e2e_info_md <- function(models.path=NULL,model.name="North_Sea") {

   oo <- options()
   on.exit(options(oo))

#        if( ! is.null(models.path) ) {
#        message("Current working directory is '",getwd(),"'\n")
#        }

	models.path <- remove.dirsep(models.path)	# remove any trailing '/'

        models.r.path<-models.path   # Keep a record of the relative path

        if( ! is.null(models.path)) {
             models.path<-makepath(getwd(),models.path)
	     if (! dir.exists(models.path)) {
		mesg <- paste0("Error: could not find the model path '", models.path, "' !\n")
	       stop(mesg)
             }
	}

	if (is.null(models.path)) {
		# get path to internal model folder
		full.path <- system.file("extdata/Models", package="StrathE2E2")
	} else {
		full.path <- models.path
	}


# List the models at the chosen folder address

        known.models <- list.files(full.path)
        chosen.model.id<-which(model.name==known.models)

        if(length(chosen.model.id)==0) stop("Could not find ",model.name," in path '", full.path, "' !")

        model.path <- makepath(full.path, model.name)				# path to model dir

        info.file<-makepath(model.path,"MODEL_INFO.txt")

        if (file.exists(info.file)) {
        readLines(con = info.file)
        info.data<-readLines(con = info.file)
        } else {
        message("The ",model.name," model folder does not contain a MODEL_INFO.txt file \n")
        }

        message("Path to the model is: '",(full.path),"'\n")

info.data

return(info.data)

}

