#
# e2e_info_pk.R
#
#' List the version mumber and details of the installed StrathE2E2 package.
#'
#' @param pk	Package name. Default="StrathE2E2"
#'
#' @return An on-screen list of the installed package details.
#'
#' @seealso \code{\link{e2e_copy}}, \code{\link{e2e_ls}} , \code{\link{e2e_info_md}}
#'
#' @export
#'
#' @examples
#' # List the version and details of the package:
#' #    e2e_info_pk()
#'
#
# ---------------------------------------------------------------------
# |                                                                   |
# | Authors: Michael Heath                                            |
# | Department of Mathematics and Statistics                          |
# | University of Strathclyde, Glasgow                                |
# |                                                                   |
# | Date of this version: May 2022                                    |
# |                                                                   |
# ---------------------------------------------------------------------

e2e_info_pk <- function(pk="StrathE2E2") {

   oo <- options()
   on.exit(options(oo))

        packageDescription(pk)

}

