% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StrathE2E2.R
\name{StrathE2E2}
\alias{StrathE2E2}
\title{StrathE2E2 Package}
\description{
StrathE2E2 is a dynamic model of the 'big-picture', whole ecosystem effects of hydrodynamics, temperature, nutrient additions, and fishing on continental shelf marine food webs.
}
\details{
The StrathE2E2 model has two linked parts - a fishing fleet model and an ecology model. The fishing model integrates harvesting, discarding and seabed 
  disturbance rates across a range of gears and passes the results into the ecology model.

The ecology model is a network of coupled ordinary differential equations representing the rates of change in organic detritus, dissolved inorganic 
  nutrient, and coarse guilds of living biomass spanning microbes to megafauna. The equations include representations of feeding, metabolism, reproduction, 
  active migrations, advection and mixing. Environmental driving data include temperature, irradiance, hydrodynamics, and nutrient inputs from rivers, atmosphere and ocean boundaries.

The package includes functions for parameter optimization, global sensitivity analysis, and Monte Carlo estimation of credible intervals for model outputs.

A fully developed and documented implementation for the North Sea is included in the package.
}
\section{Documentation}{


List of all vignettes and documentation supplied with the package: \cr
  \url{../doc/index.html} \cr

CheatSheet - quick-reference guide to StrathE2E2 functions ... \url{../doc/StrathE2E2_CheatSheet.pdf} \cr
  or ... from an R session ... vignette("StrathE2E2_CheatSheet")

\href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_4.0.0_reference_manual.pdf}{Reference Manual (pdf) - compilation of function help pages generated by CRAN-check} \cr

\href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_User_Manual_4.0.0.html}{Package User Manual (html) - guide to developing and running models} \cr

Package website: \url{https://www.marineresourcemodelling.maths.strath.ac.uk/strathe2e/index.html}

Download documentation from the package website: \cr
  \href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_Technical_Manual_4.0.0.pdf}{Technical Manual - documentation on the structure of input and output R-objects and files} \cr
  \href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_Model_origin.pdf}{Origin of the model (previous versions)} \cr
  \href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_Model_overview.pdf}{Overview of the model concepts and design} \cr
  \href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_Ecology_model.pdf}{Ecology model description} \cr
  \href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_Fishing_fleet_model.pdf}{Fishing fleet model description} \cr
  \href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_Optimization_sensitivity_Monte_Carlo_methodology.pdf}{Optimization, sensitivity and Monte Carlo methods} \cr
  \href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/4.0.0/StrathE2E2_North_Sea_model.pdf}{Documentation on the North Sea implementation of StrathE2E2 which is provided with the package} \cr

Repository for contributed models: (\url{https://www.marineresourcemodelling.maths.strath.ac.uk/strathe2e/articles/Implementations.html}) \cr

\href{https://www.marineresourcemodelling.maths.strath.ac.uk/resources/StrathE2E2/documents/publications/StrathE2E_Publications.pdf}{Publications inventory for StrathE2E models and applications} \cr
}

\section{Example data package}{


Example outputs from the more computationally intensive model functions are provided as a supplementary data package.

The data package auto-installs when example data are first invoked. Alternatively, to install manually: \cr 
... from an R session ... install.packages("StrathE2E2examples", repos="https://www.marineresourcemodelling.maths.strath.ac.uk/sran") \cr

Once installed, load the package using   ... library(StrathE2E2examples) \cr
Open documentation on the datasets using ... help(StrathE2E2examples) \cr
}

\seealso{
{Model management:} \cr
\itemize{
  \item \code{\link{e2e_info_pk}}: List version number and details of the installed package.
  \item \code{\link{e2e_ls}}: List the available models in a designated workspace.
  \item \code{\link{e2e_copy}}: Make a copy of a named model/variant in a user defined workspace.
  \item \code{\link{e2e_info_md}}: List details of a selected model and its variants.
  \item \code{\link{e2e_get_parmdoc}}: Download parameter documentation as a dataframe.
}

{Basic model operations:} \cr
\itemize{
  \item \code{\link{e2e_read}}: Load a model setup from a given workspace.
  \item \code{\link{e2e_run}}: Run StrathE2E for a prescribed number of years with a given setup.
  \item \code{\link{e2e_extract_start}}: Create a new initial values file from the end of a model run.
  \item \code{\link{e2e_extract_hr}}: Extract the values of harvest ratios generated by the fishing fleet model.
  \item \code{\link{e2e_plot_ts}}: Time-series plots of model outputs for the full duration of a model run.
}

{Parameter estimation:} \cr
\itemize{
  \item \code{\link{e2e_optimize_eco}}: Maximize the likelihood of observed ecosystem data by optimizing ecology model parameters.
  \item \code{\link{e2e_optimize_hr}}: Maximize the likelihood of observed ecosystem data by optimizing harvest ratio scaling parameters.
  \item \code{\link{e2e_optimize_act}}: Maximize the likelihood of observed ecosystem data or known harvest ratios by optimizing fishing activity parameters.
  \item \code{\link{e2e_plot_opt_diagnostics}}: Plot diagnostic data from optimization runs.
  \item \code{\link{e2e_calculate_hrscale}}: Calculate fishing fleet model parameters which link effort to harvest ratios.
}

{Sensitivity and Monte Carlo analyses:} \cr
\itemize{
  \item \code{\link{e2e_run_sens}}: Run a global parameter sensitivity analysis with a given model setup.
  \item \code{\link{e2e_run_mc}}: Run a Monte Carlo analysis with a given model setup.
  \item \code{\link{e2e_merge_sens_mc}}: Merge parallel processing files from sensitivity or Monte Carlo runs.
  \item \code{\link{e2e_process_sens_mc}}: Process raw output data from sensitivity or Monte Carlo runs.
  \item \code{\link{e2e_plot_sens_mc}}: Plots diagnostic results from sensitivity and Monte Carlo analyses.
  \item \code{\link{e2e_get_senscrit}}: List the model outputs available as the basis for sensitivity analysis.
}

{Compare model runs:} \cr
\itemize{
  \item \code{\link{e2e_compare_obs}}: Box-plot comparisons between observations and model outputs.
  \item \code{\link{e2e_compare_runs_box}}: Box-plot comparisons between two different model runs.
  \item \code{\link{e2e_compare_runs_bar}}: Tornado bar-plot comparisons between two different model runs.
}

{Fishery yield analysis:} \cr
\itemize{
  \item \code{\link{e2e_run_ycurve}}: Perform a set of model runs to generate fishery yield curve data.
  \item \code{\link{e2e_plot_ycurve}}: Plot fishery yield curve data.
}

{Visualize model inputs:} \cr
\itemize{
  \item \code{\link{e2e_plot_edrivers}}: Plot a climatological year of environmental driving data.
  \item \code{\link{e2e_plot_fdrivers}}: Plot distributions of fishery related driving data.
}

{Visualize model outputs:} \cr
\itemize{
  \item \code{\link{e2e_plot_eco}}: Plot annual cycles of ecology model variables in the final year of a run.
  \item \code{\link{e2e_plot_catch}}: Plot annual landings and discards in the final year of a run.
  \item \code{\link{e2e_plot_migration}}: Plot annual cycles of active migration fluxes in the final year of a run.
  \item \code{\link{e2e_plot_trophic}}: Plot annual mean trophic level and omnivory indices.
  \item \code{\link{e2e_plot_biomass}}: Plot zonal distributions of annual average biomass densities.
}
}
