#
# read_biology_scenarios.R
#
#' load additional mortalities and uptake and assimilation rate multipliers needed to define pressure scenarios
#'
#' @param model.path path to model
#'
#' @return list of biology scenario parameters
#'
#' @noRd
#
# ------------------------------------------------------------------------------

read_biology_scenarios <- function(model.path) {

	BIOSCENdata_M <- get.model.file(model.path, PARAMETERS_DIR, file.pattern=ADDITIONAL_MORTALITY)
	# If any of the additional mortality rates are >=100%, then broadcast a warning and stop
	ZItoohigh<-which(BIOSCENdata_M[,2]>100 | BIOSCENdata_M[,2]==100)
	ZOtoohigh<-which(BIOSCENdata_M[,3]>100 | BIOSCENdata_M[,3]==100)
	if(length(ZItoohigh)>0 | length(ZOtoohigh)>0) stop("One or more additional mortality rates in the parameter file additional_mortality.csv is set to >=100%")

	BIOSCENdata_U <- get.model.file(model.path, PARAMETERS_DIR, file.pattern=UPTAKE_MULTIPLIER)

rownamevec<- c("macrophytes",
               "phytoplankton",
               "omnivzooplankton",
               "carnivzooplankton",
               "plankfish_larvae",
               "demfish_larvae",
               "planktivfish",
               "migfish",
               "demfish",
               "suspben_larvae",
               "carnben_larvae",
               "suspbenthos",
               "carnbenthos",
               "birds",
               "pinnipeds",
               "cetaceans")

additional.mortality   <-data.frame(BIOSCENdata_M[,2:3])
uptake.multiplier       <-data.frame(BIOSCENdata_U[,2:3])

row.names(additional.mortality)<-rownamevec
row.names(uptake.multiplier)<-rownamevec

#Column 1 is now the inshore value, 2 is the offshore value

	biology.scenarios <- list(
		additional.mortality	= additional.mortality,
		uptake.multiplier	= uptake.multiplier
	)

	biology.scenarios
}

