% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_info_md.R
\name{e2e_info_md}
\alias{e2e_info_md}
\title{List the available models in a designated workspace.}
\usage{
e2e_info_md(models.path = NULL, model.name = "North_Sea")
}
\arguments{
\item{models.path}{Relative path from the current working directory to a folder containing a library of model configurations (typically "Folder/Models"). Setting models.path="" is valid. Default models.path=NULL, meaning read a North Sea model setup from the package folder extdata/Models.}

\item{model.name}{Name of model to read. Setting models.name="" is valid. Default model.path="North_Sea", meaning read the North Sea model info from the package folder extdata/Models.}
}
\value{
A text object containing the MODEL_INFO data associated with the selected model region.
}
\description{
List the available models in a designated workspace.
}
\examples{
# View the MODEL_INFO file associated with the North Sea model embedded in the package:
    e2e_info_md()

    model_info <- e2e_info_md()
    model_info

# Dummy example to illustrate listing the models/variants in a user defined
# workspace. REPLACE "Folder/Models" and "Model.Name" with your own models.path and model.name 
# remembering that the folder is relative to the current working directory.
#    e2e_info_md("Folder/Models","Model.Name")

}
\seealso{
\code{\link{e2e_ls}} , \code{\link{e2e_copy}}, \code{\link{e2e_read}} , \code{\link{e2e_info_pk}}
}
