#
# interpolate_drivers.R
#
#' Interpolate drivers over time that model is to be run
#' POLAR VERSION 5 JAN 2020
#'
#' @param run model run settings
#' @param drivers model drivers
#'
#' @return model output
#'
#' @importFrom deSolve ode
#'
#' @noRd
#
# ------------------------------------------------------------------------------

interpolate_drivers <- function(run, drivers,physical.parameters) {

	# unpack:
	drtimes <- elt(run, "drtimes")
	sprectimes <- elt(run, "sprectimes")

	driverso_inflow <- elt(drivers, "driverso_inflow")
	driverd_inflow <- elt(drivers, "driverd_inflow")
	driversi_inflow <- elt(drivers, "driversi_inflow")
	driversi_outflow <- elt(drivers, "driversi_outflow")
	driverd_outflow <- elt(drivers, "driverd_outflow")
	drivers_upwell <- elt(drivers, "drivers_upwell")
	driverso_si_flow <- elt(drivers, "driverso_si_flow")
	driversslight <- elt(drivers, "driversslight")
	driverso_logespm <- elt(drivers, "driverso_logespm")
	driversi_logespm <- elt(drivers, "driversi_logespm")
	driverso_temp <- elt(drivers, "driverso_temp")
	driverd_temp <- elt(drivers, "driverd_temp")
	driversi_temp <- elt(drivers, "driversi_temp")
	driverv_dif <- elt(drivers, "driverv_dif")
	driverriver <- elt(drivers, "driverriver")
	driverboundso_det <- elt(drivers, "driverboundso_det")
	driverboundd_det <- elt(drivers, "driverboundd_det")
	driverboundsi_det <- elt(drivers, "driverboundsi_det")
	driverboundso_amm <- elt(drivers, "driverboundso_amm")
	driverboundd_amm <- elt(drivers, "driverboundd_amm")
	driverboundsi_amm <- elt(drivers, "driverboundsi_amm")
	driverboundso_nit <- elt(drivers, "driverboundso_nit")
	driverboundd_nit <- elt(drivers, "driverboundd_nit")
	driverboundsi_nit <- elt(drivers, "driverboundsi_nit")
	driverboundso_phyt <- elt(drivers, "driverboundso_phyt")
	driverboundd_phyt <- elt(drivers, "driverboundd_phyt")
	driverboundsi_phyt <- elt(drivers, "driverboundsi_phyt")
	driverboundriv_amm <- elt(drivers, "driverboundriv_amm")
	driverboundriv_nit <- elt(drivers, "driverboundriv_nit")
	driverboundriv_det <- elt(drivers, "driverboundriv_det")
	driverso_atm_amm <- elt(drivers, "driverso_atm_amm")
	driverso_atm_nit <- elt(drivers, "driverso_atm_nit")
	driversi_atm_amm <- elt(drivers, "driversi_atm_amm")
	driversi_atm_nit <- elt(drivers, "driversi_atm_nit")
	driver_s1_pd <- elt(drivers, "driver_s1_pd")
	driver_s2_pd <- elt(drivers, "driver_s2_pd")
	driver_s3_pd <- elt(drivers, "driver_s3_pd")
	driver_d1_pd <- elt(drivers, "driver_d1_pd")
	driver_d2_pd <- elt(drivers, "driver_d2_pd")
	driver_d3_pd <- elt(drivers, "driver_d3_pd")
	drivers_wave <- elt(drivers, "drivers_wave")

	driverso_icefree <- elt(drivers, "driverso_icefree")
	driversi_icefree <- elt(drivers, "driversi_icefree")
	driverso_icecov <- elt(drivers, "driverso_icecov")
	driversi_icecov <- elt(drivers, "driversi_icecov")
	driverso_icethick <- elt(drivers, "driverso_icethick")
	driversi_icethick <- elt(drivers, "driversi_icethick")
	driverso_snowthick <- elt(drivers, "driverso_snowthick")
	driversi_snowthick <- elt(drivers, "driversi_snowthick")
	driverso_airtemp <- elt(drivers, "driverso_airtemp")
	driversi_airtemp <- elt(drivers, "driversi_airtemp")

	driverpfish_sp <- elt(drivers, "driverpfish_sp")
	driverpfish_rec <- elt(drivers, "driverpfish_rec")
	driverdfish_sp <- elt(drivers, "driverdfish_sp")
	driverdfish_rec <- elt(drivers, "driverdfish_rec")
	driverbs_sp <- elt(drivers, "driverbs_sp")
	driverbs_rec <- elt(drivers, "driverbs_rec")
	driverbc_sp <- elt(drivers, "driverbc_sp")
	driverbc_rec <- elt(drivers, "driverbc_rec")
	driver_migfish_imig <- elt(drivers, "driver_migfish_imig")
	driver_migfish_emig <- elt(drivers, "driver_migfish_emig")

	driver_bird_exit <- elt(drivers, "driver_bird_exit")
	driver_bird_return <- elt(drivers, "driver_bird_return")
	driver_seal_exit <- elt(drivers, "driver_seal_exit")
	driver_seal_return <- elt(drivers, "driver_seal_return")
	driver_ceta_exit <- elt(drivers, "driver_ceta_exit")
	driver_ceta_return <- elt(drivers, "driver_ceta_return")
	driver_bear_exit <- elt(drivers, "driver_bear_exit")
	driver_bear_return <- elt(drivers, "driver_bear_return")

	Poricez <- elt(physical.parameters,"Poricez")
	x_shallowprop <- elt(physical.parameters,"x_shallowprop")

	# _____Interpolate drivers over time that model is to be run_____


	#Need to derive the volume-balancing outflows from the offshore surface and deep, and from inner to outer
	#First, these are the flows we actually know
	fdriverso_inflow	<- matrix(ncol=2,c(drtimes,(driverso_inflow(drtimes))))
	fdriverd_inflow		<- matrix(ncol=2,c(drtimes,(driverd_inflow(drtimes))))
	fdriversi_inflow	<- matrix(ncol=2,c(drtimes,(driversi_inflow(drtimes))))
	fdriversi_outflow	<- matrix(ncol=2,c(drtimes,(driversi_outflow(drtimes))))
	fdriverd_outflow	<- matrix(ncol=2,c(drtimes,(driverd_outflow(drtimes))))
	fdrivers_upwell		<- matrix(ncol=2,c(drtimes,(drivers_upwell(drtimes))))
	fdriverso_si_flow	<- matrix(ncol=2,c(drtimes,(driverso_si_flow(drtimes))))

	#Derived outflow from si to so
	fdriversi_so_flow <- matrix(ncol=2,c(drtimes,rep(NA,length(drtimes))))
	fdriversi_so_flow[,2]<-fdriverso_si_flow[,2] + fdriversi_inflow[,2] - fdriversi_outflow[,2]
	#Volume balance check for the inshore zone
	#   plot(fdriverso_si_flow[1:361,2] + fdriversi_inflow[1:361,2] - fdriversi_outflow[1:361,2]  - fdriversi_so_flow[1:361,2],type="l")
	#   abline(h=0)
	#   sum((fdriverso_si_flow[1:361,2] + fdriversi_inflow[1:361,2] - fdriversi_outflow[1:361,2]  - fdriversi_so_flow[1:361,2]))

	#Derived outflow from so
	fdriverso_outflow <- matrix(ncol=2,c(drtimes,rep(NA,length(drtimes))))
	fdriverso_outflow[,2]<-fdriverso_inflow[,2] + fdrivers_upwell[,2] + fdriversi_so_flow[,2]  -  fdriverso_si_flow[,2]
	#Volume balance check for the offshore surface zone
	#   plot(fdriverso_inflow[,2] + fdrivers_upwell[,2] + fdriversi_so_flow[,2]  -  fdriverso_si_flow[,2] - fdriverso_outflow[,2],type="l")
	#   abline(h=0)
	#   sum((fdriverso_inflow[,2] + fdrivers_upwell[,2] + fdriversi_so_flow[,2]  -  fdriverso_si_flow[,2] - fdriverso_outflow[,2]))


	# Derive ice and snow layer volumes and rates of change - these are needed at daily rather
	# than monthly intervals so use sprectimes rather than drtimes

        # NOTE ice free is the PROPORTION of each zone that is ice free. 

        # NOTE ice cover is the proportion of ICE-AFFECTED-AREA that is covered. So to get the cover of the zone as a whole
        # and hence the volume (m3) of ice in a zone we need to multiply ice cover by (1-icefree)*zonearea

	icefree_o	<- driverso_icefree(sprectimes)
	icefree_i	<- driversi_icefree(sprectimes)
	icecov_o	<- driverso_icecov(sprectimes)
	icecov_i	<- driversi_icecov(sprectimes)
	icethick_o	<- driverso_icethick(sprectimes)
	icethick_i	<- driversi_icethick(sprectimes)
	snowthick_o	<- driverso_snowthick(sprectimes)
	snowthick_i	<- driversi_snowthick(sprectimes)

	# Set the thicknes of porous ice to the minimum of ice thickness and the max thickness of the porous zone
	Poricethick_o	<-  rep(Poricez,length(sprectimes))
	tt		<-  which(icethick_o < Poricez)
	Poricethick_o[tt]<-icethick_o[tt]

	Poricethick_i	<-  rep(Poricez,length(sprectimes))
	tt		<-  which(icethick_i < Poricez)
	Poricethick_i[tt]<-icethick_i[tt]

	# Set the impervious layer thickness to 0 or the bit thats left after substracting the porous zone
	Impicethick_o	<- icethick_o - Poricethick_o
	Impicethick_i	<- icethick_i - Poricethick_i

	# Now, be careful - deriving ice volume from zone area, ice-free proportion, cover in ice affectd area, and ice thickness
	Poricevol_o	<- icecov_o * (1-icefree_o) * (1 - x_shallowprop) * Poricethick_o
	Poricevol_i	<- icecov_i * (1-icefree_i) * x_shallowprop * Poricethick_i

	Impicevol_o	<- icecov_o * (1-icefree_o) * (1 - x_shallowprop) * Impicethick_o
	Impicevol_i	<- icecov_i * (1-icefree_i) * x_shallowprop * Impicethick_i

	Snowvol_o	<-  icecov_o * (1-icefree_o) * (1 - x_shallowprop) * snowthick_o
	Snowvol_i	<-  icecov_i * (1-icefree_i) * x_shallowprop * snowthick_i


	roc_poricevol_o	<-  rep(0,length(sprectimes))
	roc_impicevol_o	<-  rep(0,length(sprectimes))
	roc_snowvol_o	<-  rep(0,length(sprectimes))

	roc_poricevol_i	<-  rep(0,length(sprectimes))
	roc_impicevol_i	<-  rep(0,length(sprectimes))
	roc_snowvol_i	<-  rep(0,length(sprectimes))

	tt	<- Poricevol_o[2:(length(sprectimes))]
	roc_poricevol_o[1:(length(sprectimes)-1)]	<- ( tt - Poricevol_o[1:(length(sprectimes)-1)] )
	roc_poricevol_o[(length(sprectimes))] <- roc_poricevol_o[(length(sprectimes)-1)]

	tt	<- Poricevol_i[2:(length(sprectimes))]
	roc_poricevol_i[1:(length(sprectimes)-1)]	<- ( tt - Poricevol_i[1:(length(sprectimes)-1)] )
	roc_poricevol_i[(length(sprectimes))] <- roc_poricevol_i[(length(sprectimes)-1)]

	tt	<- Impicevol_o[2:(length(sprectimes))]
	roc_impicevol_o[1:(length(sprectimes)-1)]	<- ( tt - Impicevol_o[1:(length(sprectimes)-1)] )
	roc_impicevol_o[(length(sprectimes))] <- roc_impicevol_o[(length(sprectimes)-1)]

	tt	<- Impicevol_i[2:(length(sprectimes))]
	roc_impicevol_i[1:(length(sprectimes)-1)]	<- ( tt - Impicevol_i[1:(length(sprectimes)-1)] )
	roc_impicevol_i[(length(sprectimes))] <- roc_impicevol_i[(length(sprectimes)-1)]

	tt	<- Snowvol_o[2:(length(sprectimes))]
	roc_snowvol_o[1:(length(sprectimes)-1)]	<- ( tt - Snowvol_o[1:(length(sprectimes)-1)] )
	roc_snowvol_o[(length(sprectimes))] <- roc_snowvol_o[(length(sprectimes)-1)]

	tt	<- Snowvol_i[2:(length(sprectimes))]
	roc_snowvol_i[1:(length(sprectimes)-1)]	<- ( tt - Snowvol_i[1:(length(sprectimes)-1)] )
	roc_snowvol_i[(length(sprectimes))] <- roc_snowvol_i[(length(sprectimes)-1)]

	fdriverso_airtemp	<- matrix(ncol=2,c(drtimes,(driverso_airtemp(drtimes))))
	fdriverso_icefree	<- matrix(ncol=2,c(sprectimes,icefree_o))
	fdriverso_icecov	<- matrix(ncol=2,c(sprectimes,icecov_o))
	fdriverso_icethick	<- matrix(ncol=2,c(sprectimes,icethick_o))
	fdriverso_snowthick	<- matrix(ncol=2,c(sprectimes,snowthick_o))
	fdriverso_poricevol	<- matrix(ncol=2,c(sprectimes,Poricevol_o))
	fdriverso_impicevol	<- matrix(ncol=2,c(sprectimes,Impicevol_o))
	fdriverso_snowvol	<- matrix(ncol=2,c(sprectimes,Snowvol_o))
	fdriverso_rocporicevol	<- matrix(ncol=2,c(sprectimes,roc_poricevol_o))
	fdriverso_rocimpicevol	<- matrix(ncol=2,c(sprectimes,roc_impicevol_o))
	fdriverso_rocsnowvol	<- matrix(ncol=2,c(sprectimes,roc_snowvol_o))

	fdriversi_airtemp	<- matrix(ncol=2,c(drtimes,(driversi_airtemp(drtimes))))
	fdriversi_icefree	<- matrix(ncol=2,c(sprectimes,icefree_i))
	fdriversi_icecov	<- matrix(ncol=2,c(sprectimes,icecov_i))
	fdriversi_icethick	<- matrix(ncol=2,c(sprectimes,icethick_i))
	fdriversi_snowthick	<- matrix(ncol=2,c(sprectimes,snowthick_i))
	fdriversi_poricevol	<- matrix(ncol=2,c(sprectimes,Poricevol_i))
	fdriversi_impicevol	<- matrix(ncol=2,c(sprectimes,Impicevol_i))
	fdriversi_snowvol	<- matrix(ncol=2,c(sprectimes,Snowvol_i))
	fdriversi_rocporicevol	<- matrix(ncol=2,c(sprectimes,roc_poricevol_i))
	fdriversi_rocimpicevol	<- matrix(ncol=2,c(sprectimes,roc_impicevol_i))
	fdriversi_rocsnowvol	<- matrix(ncol=2,c(sprectimes,roc_snowvol_i))



	forc <- list(

		fdriversslight		= matrix(ncol=2,c(drtimes,(driversslight(drtimes)))),

		fdriverso_logespm	= matrix(ncol=2,c(drtimes,(driverso_logespm(drtimes)))),
		fdriversi_logespm	= matrix(ncol=2,c(drtimes,(driversi_logespm(drtimes)))),

		fdriverso_temp		= matrix(ncol=2,c(drtimes,(driverso_temp(drtimes)))),
		fdriverd_temp		= matrix(ncol=2,c(drtimes,(driverd_temp(drtimes)))),
		fdriversi_temp		= matrix(ncol=2,c(drtimes,(driversi_temp(drtimes)))),

		fdriverv_dif		= matrix(ncol=2,c(drtimes,(driverv_dif(drtimes)))),

		fdriverso_inflow	= fdriverso_inflow,
		fdriverd_inflow		= fdriverd_inflow,
		fdriversi_inflow	= fdriversi_inflow,

		fdriverso_outflow	= fdriverso_outflow,
		fdriverd_outflow	= fdriverd_outflow,
		fdriversi_outflow	= fdriversi_outflow,

		fdriverso_si_flow	= fdriverso_si_flow,
		fdriversi_so_flow	= fdriversi_so_flow,

		fdrivers_upwell		= fdrivers_upwell,

		fdriverriver		= matrix(ncol=2,c(drtimes,(driverriver(drtimes)))),

		fdriverboundso_det	= matrix(ncol=2,c(drtimes,(driverboundso_det(drtimes)))),
		fdriverboundd_det	= matrix(ncol=2,c(drtimes,(driverboundd_det(drtimes)))),
		fdriverboundsi_det	= matrix(ncol=2,c(drtimes,(driverboundsi_det(drtimes)))),

		fdriverboundso_amm	= matrix(ncol=2,c(drtimes,(driverboundso_amm(drtimes)))),
		fdriverboundd_amm	= matrix(ncol=2,c(drtimes,(driverboundd_amm(drtimes)))),
		fdriverboundsi_amm	= matrix(ncol=2,c(drtimes,(driverboundsi_amm(drtimes)))),

		fdriverboundso_nit	= matrix(ncol=2,c(drtimes,(driverboundso_nit(drtimes)))),
		fdriverboundd_nit	= matrix(ncol=2,c(drtimes,(driverboundd_nit(drtimes)))),
		fdriverboundsi_nit	= matrix(ncol=2,c(drtimes,(driverboundsi_nit(drtimes)))),

		fdriverboundso_phyt	= matrix(ncol=2,c(drtimes,(driverboundso_phyt(drtimes)))),
		fdriverboundd_phyt	= matrix(ncol=2,c(drtimes,(driverboundd_phyt(drtimes)))),
		fdriverboundsi_phyt	= matrix(ncol=2,c(drtimes,(driverboundsi_phyt(drtimes)))),

		fdriverboundriv_amm	= matrix(ncol=2,c(drtimes,(driverboundriv_amm(drtimes)))),
		fdriverboundriv_nit	= matrix(ncol=2,c(drtimes,(driverboundriv_nit(drtimes)))),
		fdriverboundriv_det	= matrix(ncol=2,c(drtimes,(driverboundriv_det(drtimes)))),

		fdriverso_atm_amm	= matrix(ncol=2,c(drtimes,(driverso_atm_amm(drtimes)))),
		fdriverso_atm_nit	= matrix(ncol=2,c(drtimes,(driverso_atm_nit(drtimes)))),
		fdriversi_atm_amm	= matrix(ncol=2,c(drtimes,(driversi_atm_amm(drtimes)))),
		fdriversi_atm_nit	= matrix(ncol=2,c(drtimes,(driversi_atm_nit(drtimes)))),

		fdriver_s1_erosion	= matrix(ncol=2,c(drtimes,(driver_s1_pd(drtimes)))),
		fdriver_s2_erosion	= matrix(ncol=2,c(drtimes,(driver_s2_pd(drtimes)))),
		fdriver_s3_erosion	= matrix(ncol=2,c(drtimes,(driver_s3_pd(drtimes)))),
		fdriver_d1_erosion	= matrix(ncol=2,c(drtimes,(driver_d1_pd(drtimes)))),
		fdriver_d2_erosion	= matrix(ncol=2,c(drtimes,(driver_d2_pd(drtimes)))),
		fdriver_d3_erosion	= matrix(ncol=2,c(drtimes,(driver_d3_pd(drtimes)))),

		fdriver_s_wave		= matrix(ncol=2,c(drtimes,(drivers_wave(drtimes)))),

		fdriverpfish_sp		= matrix(ncol=2,c(sprectimes,(driverpfish_sp(sprectimes)))),
		fdriverpfish_rec	= matrix(ncol=2,c(sprectimes,(driverpfish_rec(sprectimes)))),
		fdriverdfish_sp		= matrix(ncol=2,c(sprectimes,(driverdfish_sp(sprectimes)))),
		fdriverdfish_rec	= matrix(ncol=2,c(sprectimes,(driverdfish_rec(sprectimes)))),


		fdriverbs_sp		= matrix(ncol=2,c(sprectimes,(driverbs_sp(sprectimes)))),
		fdriverbs_rec		= matrix(ncol=2,c(sprectimes,(driverbs_rec(sprectimes)))),
		fdriverbc_sp		= matrix(ncol=2,c(sprectimes,(driverbc_sp(sprectimes)))),
		fdriverbc_rec		= matrix(ncol=2,c(sprectimes,(driverbc_rec(sprectimes)))),

		fdrivermfish_im		= matrix(ncol=2,c(sprectimes,(driver_migfish_imig(sprectimes)))),
		fdrivermfish_em		= matrix(ncol=2,c(sprectimes,(driver_migfish_emig(sprectimes)))),

		fdriverso_airtemp	=  fdriverso_airtemp,
		fdriverso_icefree	=  fdriverso_icefree,
		fdriverso_icecov	=  fdriverso_icecov,
		fdriverso_icethick	=  fdriverso_icethick,
		fdriverso_snowthick	=  fdriverso_snowthick,
		fdriverso_poricevol	=  fdriverso_poricevol,
		fdriverso_impicevol	=  fdriverso_impicevol,
		fdriverso_snowvol	=  fdriverso_snowvol,
		fdriverso_rocporicevol	=  fdriverso_rocporicevol,
		fdriverso_rocimpicevol	=  fdriverso_rocimpicevol,
		fdriverso_rocsnowvol	=  fdriverso_rocsnowvol,

		fdriversi_airtemp	=  fdriversi_airtemp,
		fdriversi_icefree	=  fdriversi_icefree,
		fdriversi_icecov	=  fdriversi_icecov,
		fdriversi_icethick	=  fdriversi_icethick,
		fdriversi_snowthick	=  fdriversi_snowthick,
		fdriversi_poricevol	=  fdriversi_poricevol,
		fdriversi_impicevol	=  fdriversi_impicevol,
		fdriversi_snowvol	=  fdriversi_snowvol,
		fdriversi_rocporicevol	=  fdriversi_rocporicevol,
		fdriversi_rocimpicevol	=  fdriversi_rocimpicevol,
		fdriversi_rocsnowvol	=  fdriversi_rocsnowvol,

		fdriver_bird_exit		= matrix(ncol=2,c(sprectimes,(driver_bird_exit(sprectimes)))),
		fdriver_bird_return		= matrix(ncol=2,c(sprectimes,(driver_bird_return(sprectimes)))),
		fdriver_seal_exit		= matrix(ncol=2,c(sprectimes,(driver_seal_exit(sprectimes)))),
		fdriver_seal_return		= matrix(ncol=2,c(sprectimes,(driver_seal_return(sprectimes)))),
		fdriver_ceta_exit		= matrix(ncol=2,c(sprectimes,(driver_ceta_exit(sprectimes)))),
		fdriver_ceta_return		= matrix(ncol=2,c(sprectimes,(driver_ceta_return(sprectimes)))),
		fdriver_bear_exit		= matrix(ncol=2,c(sprectimes,(driver_bear_exit(sprectimes)))),
		fdriver_bear_return		= matrix(ncol=2,c(sprectimes,(driver_bear_return(sprectimes))))

	)

	forc
}

