% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_plot_biomass.R
\name{e2ep_plot_biomass}
\alias{e2ep_plot_biomass}
\title{Plot showing the annual annual average biomass densities of each guild in the inshore and offshore zones, optionally with credible intervals.}
\usage{
e2ep_plot_biomass(
  model,
  ci.data = FALSE,
  use.saved = FALSE,
  use.example = FALSE,
  results = NULL
)
}
\arguments{
\item{model}{R-list object defining the model configuration used to generate the data and compiled by the e2ep_read() function.}

\item{ci.data}{Logical. If TRUE plot credible intervals around model results based on Monte Carlo simulation with the e2ep_run_mc() function (default=FALSE).}

\item{use.saved}{Logical. If TRUE use data from a prior user-defined run held as csv files data in the current results folder (default=FALSE).}

\item{use.example}{NOT YET ENABLED. In future versions - Logical. If TRUE use pre-computed example data from the internal Barents Sea model rather than user-generated data (default=FALSE).}

\item{results}{R-list object of baseline model output generated by the e2ep_run() function. Only needed if ci.data=FALSE, use.saved=FALSE and use.example=FALSE. (Default=NULL).}
}
\value{
graphical display in a new graphics window.
}
\description{
Generate plots showing the annual average biomass densities of each guild in the ecology model in the inshore and offshore zones during the final year of a run. The default is to plot data from a single model run but if available, 
credible intervals of model output from a Monte Carlo analysis can also be plotted.
}
\details{
Note that in this plot the biomass are expressed as mMN/m2, meaning that the mass in each zone has been scaled to the zonal sea surface area. So the data in
this plot are area densities and not mass.

Arguments determine the source of model data to be plotted. These can be outputs from a single model run with data held in memory as a list object or in a saved csv file, or from 
a Monte Carlo simulation (using the function e2ep_run_mc()) to estimate credible intervals of model outputs. Generation of credible interval data is a long computing task, so 
example data for the Barents Sea model provided with the package are available as example data sets.

If credible intervals are plotted these are displayed as box-and-whiskers. The box spans 50% of the likelihood distribution of values and the whiskers 99%. The median is shown 
by a tick mark.
}
\examples{
# Load the 2011-2019 version of the Barents Sea model supplied with the package, 
# run, and generate a plot:
    model <- e2ep_read("Barents_Sea", "2011-2019")
    results <- e2ep_run(model, nyears=2)
    e2ep_plot_biomass(model, results=results)

# Direct the graphics output to a pdf file ... 
# or jpeg("plot.jpg"), png("plot.png")
    pdf(file.path(tempdir(), "plot.pdf"),width=4,height=6)
    e2ep_plot_biomass(model, results=results)
    dev.off()

\donttest{
# Alternatively, plot the same data from a csv file saved by the e2ep_run() function. Here the
# csv output is directed to a temporary folder since results.path is not set in the e2ep_read()
# function call:
    results <- e2ep_run(model, nyears=2,csv.output=TRUE)
    dev.new()
    e2ep_plot_biomass(model, use.saved=TRUE)
}

# For the same model, plot the example data with credible intervals:
# This example requires the Strathe2E2examples supplementary data package.
if(require(StrathE2E2examples)){
    e2ep_plot_biomass(model, ci.data=TRUE, use.example=TRUE)
}

}
\seealso{
\code{\link{e2ep_read}}, \code{\link{e2ep_run}}, \code{\link{e2ep_plot_migration}}, \code{\link{e2ep_plot_catch}}, \code{\link{e2ep_plot_trophic}}, \code{\link{e2ep_plot_eco}}
}
