% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_copy.R
\name{e2ep_copy}
\alias{e2ep_copy}
\title{Make a copy of a named model/variant and documentation in a user defined workspace}
\usage{
e2ep_copy(model.name, model.variant, source.path = NULL, dest.path = NULL)
}
\arguments{
\item{model.name}{Name of model to copy.}

\item{model.variant}{Name of model variant to copy.}

\item{source.path}{Relative path from the current working directory to the source model to be copied. Setting source.path="" is valid. Default source.path=NULL, meaning read a Barents Sea model setup from the package folder extdata/Models.}

\item{dest.path}{Relative path from the current working directory to a destination address in which to create a 'Models' folder if necessary, and then copy the model files. Setting dest.path="" is valid. Default dest.path=NULL in which case the Models folder will be created in a temporary directory.}
}
\value{
A copy of an entire model/variant and the associated documentation folder in the designated workspace.
}
\description{
Make a copy of a named model/variant and documentation in a user defined workspace
}
\examples{
# Copy the 2011-2019 version of the Barents Sea model supplied with the package into a
# temporary folder: 
    e2ep_copy("Barents_Sea", "2011-2019")

# Dummy example illustrating copy the 2011-2019 version of the Barents Sea model 
# supplied with the package into a user-defined folder (edit "Folder/Models to 
# your own relative path): 
#   e2ep_copy("Barents_Sea", "2011-2019",dest.path="Folder/Models")

# Dummy example illustrating copying a user model into a user workspace:
# Replace "Folder1/Models" and "Folder2/Models" with your own source.path and dest.path
# remembering that these are relative to the current working directory.
# e.g.... e2ep_copy("Modelname", "Modelvariant",
#         source.path="Folder1/Models",
#         dest.path="Folder2/Models")

}
\seealso{
\code{\link{e2ep_ls}}, \code{\link{e2ep_read}}
}
