% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_extract_hr.R
\name{e2ep_extract_hr}
\alias{e2ep_extract_hr}
\title{Extract the values of harvest ratios generated by the fleet model.}
\usage{
e2ep_extract_hr(model, results, csv.output = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the e2e_read() function.}

\item{results}{R-list object generated by the e2e_run() function.}

\item{csv.output}{Logical. If TRUE then enable writing of CSV output files (default=FALSE).}
}
\value{
Dataframe of harvest ratio values, rows = guilds, columns = zone
}
\description{
The function extracts the inshore, offshore and whole-domain values of harvest ratio (proportion of biomass captured per day) for each guild, from the results object generated by the e2e_run() function.
}
\examples{
    model <- e2ep_read("Barents_Sea", "2011-2019") 
    results<-e2ep_run(model, nyears=2,csv.output=FALSE)
    harvest_ratio_data <- e2ep_extract_hr(model,results,csv.output=FALSE)
}
\seealso{
\code{\link{e2ep_read}}, \code{\link{e2ep_run}}
}
