% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_plot_edrivers.R
\name{e2ep_plot_edrivers}
\alias{e2ep_plot_edrivers}
\title{Plot climatological year of environmental driving data.}
\usage{
e2ep_plot_edrivers(model, selection = "INTERNAL")
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the e2ep_read() function.}

\item{selection}{Text string from a list identifying whether internal or boundary driving data are to be plotted. Select from: "INTERNAL", "BOUNDARY", default = "INTERNAL". Remember to include the phrase within "" quotes.}
}
\value{
Graphical display in a new graphics window. Does not return any data object since the data plotted are all available as input csv files.
}
\description{
Multi-panel time series plots of climatological annual cycles of driving data as provided in the input csv files.
}
\details{
The function plots a multi-panel page of time series plots of monthly values of the environmental driving data for the model.

Units for the plotted variables are as follows:

Internal drivers (i.e. properties applied within the model domain)
\itemize{
  \item Sea surface irradiance: uE/m2/d
  \item Sea temperature: deg-C
  \item Air temperature: deg-C
  \item Vertical diffusivity gradient: m/d (derived from the vertical diffusivity (m2/s) and mixing length scale (m))
  \item Inshore significant wave height: m
  \item Proportion of seabed disturbed: /d (aggregated over the three sediment classes in each zone)
  \item Suspended particulate matter: g/m3
  \item Ice-free area: priortion of model domain (i.e. ice cover * zonal area)
  \item Ice-free %: % of each zone ice free
  \item Ice cover %: Percent sea surface covered by ice in ice-affected areas
  \item Ice thickness: m
  \item Snow thickness: m
}

Boundary drivers (i.e. properties applied at the boundaries of the model domain)
\itemize{
  \item External inflows: m3 per m2 sea surface of model domain (derived from proportion input per layer volume, layer thicknesses and areas)
  \item River discharge: m3 per m2 sea surface of model domain (derived from proportion input to inshore volume, and inshore layer thickness and area)
  \item External boundary nitrate concentration: mMN/m3
  \item External boundary ammonia concentration: mMN/m3
  \item External boundary phytoplankton concentration: mMN/m3
  \item External boundary detritus concentration: mMN/m3
  \item River nitrate concentration: mMN/m3
  \item River ammonia concentration: mMN/m3
  \item River labile detritus concentration: mMN/m3
  \item Atmospheric nitrate deposition flux: mMN/m2/d
  \item Atmospheric ammonia deposition flux: mMN/m2/d
}
}
\examples{
# Load the 2011-2019 version of the Barents Sea model supplied with the package:
    model <- e2ep_read("Barents_Sea", "2011-2019")
# Plot the annual cyles of internal driving data
    e2ep_plot_edrivers(model,selection="INTERNAL")
# Plot the annual cyles of boundary driving data
    e2ep_plot_edrivers(model,selection="BOUNDARY")

# Direct the graphics output to a pdf file ... 
# or jpeg("plot.jpg"), png("plot.png")
    pdf(file.path(tempdir(), "plot.pdf"),width=8,height=6)
    e2ep_plot_edrivers(model)
    dev.off()

}
\seealso{
\code{\link{e2ep_read}}, \code{\link{e2ep_run}}, \code{\link{e2ep_plot_fdrivers}}
}
