#
# CredInt_make_daily_results.R
#
#' Save current set of fitted parameters to file
#'
#' @param model model object
#' @param lastyearstore inshore annual flux data
#' @param csv.output (TRUE or FALSE, default=TRUE) Set to FALSE to disable writing of CSV output files - useful for testing
#'
#' @noRd
#
# ------------------------------------------------------------------------------

CredInt_make_daily_results <- function(model, lastyearstore,csv.output) {

	pkg.env$csv.output <- csv.output	# controls writing of CSV files

	resultsdir <- elt(model, "setup", "resultsdir")
	identifier <- elt(model, "setup", "model.ident")

	credpath <- makepath(resultsdir, CREDINT_DIR)



lastyearstore$dummy<-1


# names(lastyearstore)
#   [1] "time"                       "detritus_so"                "detritus_d"                
#   [4] "x_detritus_s1"              "x_detritus_s2"              "x_detritus_s3"             
#   [7] "x_detritus_d1"              "x_detritus_d2"              "x_detritus_d3"             
#  [10] "xR_detritus_s1"             "xR_detritus_s2"             "xR_detritus_s3"            
#  [13] "xR_detritus_d1"             "xR_detritus_d2"             "xR_detritus_d3"            
#  [16] "discard_o"                  "corpse_s1"                  "corpse_s2"                 
#  [19] "corpse_s3"                  "corpse_d1"                  "corpse_d2"                 
#  [22] "corpse_d3"                  "ammonia_so"                 "ammonia_d"                 
#  [25] "x_ammonia_s1"               "x_ammonia_s2"               "x_ammonia_s3"              
#  [28] "x_ammonia_d1"               "x_ammonia_d2"               "x_ammonia_d3"              
#  [31] "nitrate_so"                 "nitrate_d"                  "x_nitrate_s1"              
#  [34] "x_nitrate_s2"               "x_nitrate_s3"               "x_nitrate_d1"              
#  [37] "x_nitrate_d2"               "x_nitrate_d3"               "phyt_so"                   
#  [40] "phyt_d"                     "omni_o"                     "carn_o"                    
#  [43] "benthslar_o"                "benths_o"                   "benthclar_o"               
#  [46] "benthc_o"                   "fishp_o"                    "fishplar_o"                
#  [49] "fishd_o"                    "fishdlar_o"                 "fishm_o"                   
#  [52] "bird_o"                     "detritus_si"                "ammonia_si"                
#  [55] "nitrate_si"                 "phyt_si"                    "benthslar_i"               
#  [58] "benthclar_i"                "benths_i"                   "benthc_i"                  
#  [61] "discard_i"                  "omni_i"                     "carn_i"                    
#  [64] "fishplar_i"                 "fishdlar_i"                 "fishp_i"                   
#  [67] "fishm_i"                    "fishd_i"                    "bird_i"                    
#  [70] "seal_o"                     "seal_i"                     "ceta_o"                    
#  [73] "ceta_i"                     "corpse_s0"                  "corpse_d0"                 
#  [76] "kelpC"                      "kelpN"                      "kelpdebris"                
#  [79] "snow_ammonia_o"             "snow_nitrate_o"             "ice_ammonia_o"             
#  [82] "ice_nitrate_o"              "ice_detritus_o"             "ice_algae_o"               
#  [85] "snow_ammonia_i"             "snow_nitrate_i"             "ice_ammonia_i"             
#  [88] "ice_nitrate_i"              "ice_detritus_i"             "ice_algae_i"               
#  [91] "bear_o"                     "bear_i"                     "htlcorp_o"                 
#  [94] "htlcorp_i"                  "wintering_bird_o"           "wintering_bird_i"          
#  [97] "wintering_seal_o"           "wintering_seal_i"           "wintering_ceta_o"          
# [100] "wintering_ceta_i"           "wintering_bear_o"           "wintering_bear_i"          
# [103] "netpprod_o"                 "netpprod_i"                 "PNP_o"                     
# [106] "PNP_i"                      "phytgrossprod_o"            "phytgrossprod_i"           
# [109] "kelpCprod_i"                "kelpCexud_i"                "kelpNprod_i"               
# [112] "omnigrossprod_o"            "omnigrossprod_i"            "carngrossprod_o"           
# [115] "carngrossprod_i"            "pfishlargrossprod_o"        "pfishlargrossprod_i"       
# [118] "dfishlargrossprod_o"        "dfishlargrossprod_i"        "pfishgrossprod_o"          
# [121] "pfishgrossprod_i"           "mfishgrossprod_o"           "mfishgrossprod_i"          
# [124] "dfishgrossprod_o"           "dfishgrossprod_i"           "benthslargrossprod_o"      
# [127] "benthslargrossprod_i"       "benthclargrossprod_o"       "benthclargrossprod_i"      
# [130] "benthsgrossprod_o"          "benthsgrossprod_i"          "benthcgrossprod_o"         
# [133] "benthcgrossprod_i"          "birdgrossprod_o"            "birdgrossprod_i"           
# [136] "sealgrossprod_o"            "sealgrossprod_i"            "cetagrossprod_o"           
# [139] "cetagrossprod_i"            "beargrossprod_o"            "beargrossprod_i"           
# [142] "wcdenitrif_o"               "wcdenitrif_i"               "seddenitrif_o"             
# [145] "seddenitrif_i"              "fluxsedamm_wcamm"           "fluxwcdet_wcamm"           
# [148] "fluxomni_wcamm"             "fluxcarn_wcamm"             "fluxpfishlar_wcamm"        
# [151] "fluxdfishlar_wcamm"         "fluxpfish_wcamm"            "fluxmfish_wcamm"           
# [154] "fluxdfish_wcamm"            "fluxbenthslar_wcamm"        "fluxbenthclar_wcamm"       
# [157] "fluxbenths_wcamm"           "fluxbenthc_wcamm"           "fluxbird_wcamm"            
# [160] "fluxseal_wcamm"             "fluxceta_wcamm"             "fluxbear_wcamm"            
# [163] "fluxxdet_sedamm"            "fluxxRdet_sedamm"           "fluxwcamm_wcnit"           
# [166] "fluxsednit_wcnit"           "fluxsedamm_sednit"          "fluxxdet_wcdet"            
# [169] "fluxkelpdebris_wcdet"       "fluxcorp_wcdet"             "fluxphyt_wcdet"            
# [172] "fluxomni_wcdet"             "fluxcarn_wcdet"             "fluxpfishlar_wcdet"        
# [175] "fluxdfishlar_wcdet"         "fluxpfish_wcdet"            "fluxmfish_wcdet"           
# [178] "fluxdfish_wcdet"            "fluxbenthslar_wcdet"        "fluxbenthclar_wcdet"       
# [181] "fluxbenths_wcdet"           "fluxbenthc_wcdet"           "fluxbird_wcdet"            
# [184] "fluxseal_wcdet"             "fluxceta_wcdet"             "fluxbear_wcdet"            
# [187] "fluxwcdet_xdet"             "fluxcorp_xdet"              "fluxbenths_xdet"           
# [190] "fluxbenthc_xdet"            "fluxxdet_xRdet"             "fluxkelpdebris_xRdet"      
# [193] "fluxcorp_xRdet"             "fluxkelp_kelpdebris"        "fluxdisc_corp"             
# [196] "fluxpfish_corp"             "fluxmfish_corp"             "fluxdfish_corp"            
# [199] "fluxbenths_corp"            "fluxbenthc_corp"            "fluxbird_corp"             
# [202] "fluxseal_corp"              "fluxceta_corp"              "fluxbear_corp"             
# [205] "fluxwcamm_kelp"             "fluxwcnit_kelp"             "fluxwcamm_phyt_o"          
# [208] "fluxwcamm_phyt_i"           "fluxwcnit_phyt_o"           "fluxwcnit_phyt_i"          
# [211] "fluxwcdet_omni"             "fluxphyt_omni"              "fluxbenthslar_omni"        
# [214] "fluxbenthclar_omni"         "fluxomni_carn"              "fluxpfishlar_carn"         
# [217] "fluxdfishlar_carn"          "fluxbenthslar_carn"         "fluxbenthclar_carn"        
# [220] "fluxomni_pfishlar"          "fluxbenthslar_pfishlar"     "fluxbenthclar_pfishlar"    
# [223] "fluxomni_dfishlar"          "fluxbenthslar_dfishlar"     "fluxbenthclar_dfishlar"    
# [226] "fluxomni_pfish"             "fluxcarn_pfish"             "fluxpfishlar_pfish"        
# [229] "fluxdfishlar_pfish"         "fluxbenthslar_pfish"        "fluxbenthclar_pfish"       
# [232] "fluxomni_mfish"             "fluxcarn_mfish"             "fluxpfishlar_mfish"        
# [235] "fluxdfishlar_mfish"         "fluxbenthslar_mfish"        "fluxbenthclar_mfish"       
# [238] "fluxcorp_dfish"             "fluxdisc_dfish"             "fluxcarn_dfish"            
# [241] "fluxpfishlar_dfish"         "fluxdfishlar_dfish"         "fluxpfish_dfish"           
# [244] "fluxmfish_dfish"            "fluxdfish_dfish"            "fluxbenths_dfish"          
# [247] "fluxbenthc_dfish"           "fluxwcdet_benthslar"        "fluxphyt_benthslar"        
# [250] "fluxwcdet_benthclar"        "fluxphyt_benthclar"         "fluxwcdet_benths"          
# [253] "fluxxdet_benths"            "fluxxRdet_benths"           "fluxphyt_benths"           
# [256] "fluxkelp_benthc"            "fluxkelpdebris_benthc"      "fluxcorp_benthc"           
# [259] "fluxbenths_benthc"          "fluxcorp_bird"              "fluxdisc_bird"             
# [262] "fluxcarn_bird"              "fluxpfish_bird"             "fluxmfish_bird"            
# [265] "fluxdfish_bird"             "fluxbenths_bird"            "fluxbenthc_bird"           
# [268] "fluxcorp_seal"              "fluxdisc_seal"              "fluxcarn_seal"             
# [271] "fluxpfish_seal"             "fluxmfish_seal"             "fluxdfish_seal"            
# [274] "fluxbenths_seal"            "fluxbenthc_seal"            "fluxbird_seal"             
# [277] "fluxdisc_ceta"              "fluxomni_ceta"              "fluxcarn_ceta"             
# [280] "fluxpfish_ceta"             "fluxmfish_ceta"             "fluxdfish_ceta"            
# [283] "fluxbenths_ceta"            "fluxbenthc_ceta"            "fluxbird_ceta"             
# [286] "fluxseal_ceta"              "fluxcorp_bear"              "fluxbird_bear"             
# [289] "fluxseal_bear"              "fluxceta_bear"              "Bs_spawn"                  
# [292] "Bs_recruit"                 "Bc_spawn"                   "Bc_recruit"                
# [295] "Pfish_spawn"                "Pfish_recruit"              "Dfish_spawn"               
# [298] "Dfish_recruit"              "fluxwcnit_Ngas"             "fluxsednit_Ngas"           
# [301] "fluxkelpdebris_beachexport" "fluxAMMoutflow_o"           "fluxNIToutflow_o"          
# [304] "fluxAMMoutflow_i"           "fluxNIToutflow_i"           "fluxPHYToutflow_o"         
# [307] "fluxDEToutflow_o"           "fluxPHYToutflow_i"          "fluxDEToutflow_i"          
# [310] "mfish_emigration"           "fluxsedboundary_o"          "fluxsedboundary_i"         
# [313] "fluxAMMinflow_o"            "fluxNITinflow_o"            "fluxAMMinflow_i"           
# [316] "fluxNITinflow_i"            "fluxPHYTinflow_o"           "fluxDETinflow_o"           
# [319] "fluxPHYTinflow_i"           "fluxDETinflow_i"            "mfish_imigration"          
# [322] "atmosAMMinput_o"            "atmosNITinput_o"            "atmosAMMinput_i"           
# [325] "atmosNITinput_i"            "rivAMMinflow"               "rivNITinflow"              
# [328] "rivPARTinflow"              "DINflux_i_o"                "DINflux_o_i"               
# [331] "PARTflux_i_o"               "PARTflux_o_i"               "activemigpelfish_i_o"      
# [334] "activemigmigfish_i_o"       "activemigdemfish_i_o"       "activemigbird_i_o"         
# [337] "activemigseal_i_o"          "activemigceta_i_o"          "activemigbear_i_o"         
# [340] "activemigpelfish_o_i"       "activemigmigfish_o_i"       "activemigdemfish_o_i"      
# [343] "activemigbird_o_i"          "activemigseal_o_i"          "activemigceta_o_i"         
# [346] "activemigbear_o_i"          "vertnitflux"                "horiznitflux"              
# [349] "landp_o"                    "landd_quota_o"              "landd_nonquota_o"          
# [352] "landm_o"                    "landsb_o"                   "landcb_o"                  
# [355] "landcz_o"                   "landbd_o"                   "landsl_o"                  
# [358] "landct_o"                   "discpel_o"                  "discdem_quota_o"           
# [361] "discdem_nonquota_o"         "discmig_o"                  "discsb_o"                  
# [364] "disccb_o"                   "disccz_o"                   "discbd_o"                  
# [367] "discsl_o"                   "discct_o"                   "landp_i"                   
# [370] "landd_quota_i"              "landd_nonquota_i"           "landm_i"                   
# [373] "landsb_i"                   "landcb_i"                   "landcz_i"                  
# [376] "landbd_i"                   "landsl_i"                   "landct_i"                  
# [379] "landkp_i"                   "discpel_i"                  "discdem_quota_i"           
# [382] "discdem_nonquota_i"         "discmig_i"                  "discsb_i"                  
# [385] "disccb_i"                   "disccz_i"                   "discbd_i"                  
# [388] "discsl_i"                   "discct_i"                   "disckp_i"                  
# [391] "offalpel_o"                 "offaldem_quota_o"           "offaldem_nonquota_o"       
# [394] "offalmig_o"                 "offalsb_o"                  "offalcb_o"                 
# [397] "offalcz_o"                  "offalbd_o"                  "offalsl_o"                 
# [400] "offalct_o"                  "offalpel_i"                 "offaldem_quota_i"          
# [403] "offaldem_nonquota_i"        "offalmig_i"                 "offalsb_i"                 
# [406] "offalcb_i"                  "offalcz_i"                  "offalbd_i"                 
# [409] "offalsl_i"                  "offalct_i"                  "offalkp_i"                 
# [412] "omninetprod_o"              "omninetprod_i"              "carnnetprod_o"             
# [415] "carnnetprod_i"              "pfishlarnetprod_o"          "pfishlarnetprod_i"         
# [418] "dfishlarnetprod_o"          "dfishlarnetprod_i"          "pfishnetprod_o"            
# [421] "pfishnetprod_i"             "mfishnetprod_o"             "mfishnetprod_i"            
# [424] "dfishnetprod_o"             "dfishnetprod_i"             "benthslarnetprod_o"        
# [427] "benthslarnetprod_i"         "benthclarnetprod_o"         "benthclarnetprod_i"        
# [430] "benthsnetprod_o"            "benthsnetprod_i"            "benthcnetprod_o"           
# [433] "benthcnetprod_i"            "birdnetprod_o"              "birdnetprod_i"             
# [436] "sealnetprod_o"              "sealnetprod_i"              "cetanetprod_o"             
# [439] "cetanetprod_i"              "bearnetprod_o"              "bearnetprod_i"             
# [442] "neticealgprod_o"            "neticealgprod_i"            "icealggrossprod_o"         
# [445] "icealggrossprod_i"          "fluxwcamm_icealg_o"         "fluxwcamm_icealg_i"        
# [448] "fluxwcnit_icealg_o"         "fluxwcnit_icealg_i"         "icesnowdenitrif_o"         
# [451] "icesnowdenitrif_i"          "atmosAMMinputsnow_o"        "atmosNITinputsnow_o"       
# [454] "atmosAMMinputsnow_i"        "atmosNITinputsnow_i"        "atmosAMMinputwater_o"      
# [457] "atmosNITinputwater_o"       "atmosAMMinputwater_i"       "atmosNITinputwater_i"      
# [460] "fluxsnowamm_wcamm"          "fluxsnowamm_snownit"        "fluxiceamm_wcamm"          
# [463] "fluxiceamm_icenit"          "fluxwcamm_iceamm"           "fluxwcamm_icealg"          
# [466] "fluxsnownit_wcnit"          "fluxsnownit_atmos"          "fluxicenit_wcnit"          
# [469] "fluxicenit_atmos"           "fluxwcnit_icenit"           "fluxwcnit_icealg"          
# [472] "fluxicedet_wcamm"           "fluxicedet_wcdet"           "fluxicedet_omni"           
# [475] "fluxwcdet_icedet"           "fluxicealg_icedet"          "fluxicealg_wcdet"          
# [478] "fluxicealg_omni"            "fluxicealg_phyt"            "fluxphyt_icealg"           
# [481] "fluxatmos_snowamm"          "fluxatmos_snownit"          "fluxatmos_wateramm"        
# [484] "fluxatmos_waternit"         "fluxbird_im_o"              "fluxseal_im_o"             
# [487] "fluxceta_im_o"              "fluxbear_im_o"              "fluxbird_im_i"             
# [490] "fluxseal_im_i"              "fluxceta_im_i"              "fluxbear_im_i"             
# [493] "fluxbird_em_o"              "fluxseal_em_o"              "fluxceta_em_o"             
# [496] "fluxbear_em_o"              "fluxbird_em_i"              "fluxseal_em_i"             
# [499] "fluxceta_em_i"              "fluxbear_em_i"              "totalN"                    
# [502] "totalN_o"                   "totalN_i"                   "x_detritus"                
# [505] "x_detritus_o"               "x_detritus_i"               "corpse"                    
# [508] "corpse_o"                   "corpse_i"                   "x_ammonia"                 
# [511] "x_ammonia_o"                "x_ammonia_i"                "x_nitrate"                 
# [514] "x_nitrate_o"                "x_nitrate_i"                "snow_ammonia"              
# [517] "snow_nitrate"               "ice_ammonia"                "ice_nitrate"               
# [520] "ice_detritus"               "s_detritus"                 "s_ammonia"                 
# [523] "s_nitrate"                  "ice_algae"                  "s_phyt"                    
# [526] "benthslar"                  "benthclar"                  "benths"                    
# [529] "benthc"                     "discard"                    "omni"                      
# [532] "carn"                       "fishp"                      "fishd"                     
# [535] "fishm"                      "bird"                       "seal"                      
# [538] "ceta"                       "bear"                       "fishplar"                  
# [541] "fishdlar"                   "PNP"                        "neticealgprod"             
# [544] "netpprod"                   "fluxwcamm_icealg.1"         "fluxwcnit_icealg.1"        
# [547] "fluxwcamm_phyt"             "fluxwcnit_phyt"             "icealggrossprod"           
# [550] "phytgrossprod"              "omnigrossprod"              "carngrossprod"             
# [553] "pfishlargrossprod"          "dfishlargrossprod"          "pfishgrossprod"            
# [556] "mfishgrossprod"             "dfishgrossprod"             "benthslargrossprod"        
# [559] "benthclargrossprod"         "benthsgrossprod"            "benthcgrossprod"           
# [562] "birdgrossprod"              "sealgrossprod"              "cetagrossprod"             
# [565] "beargrossprod"              "omninetprod"                "carnnetprod"               
# [568] "pfishlarnetprod"            "dfishlarnetprod"            "pfishnetprod"              
# [571] "mfishnetprod"               "dfishnetprod"               "benthslarnetprod"          
# [574] "benthclarnetprod"           "benthsnetprod"              "benthcnetprod"             
# [577] "birdnetprod"                "sealnetprod"                "cetanetprod"               
# [580] "bearnetprod"                "icesnowdenitrif"            "wcdenitrif"                
# [583] "seddenitrif"                "fluxsedboundary"            "DIN_NET_flux_o_i"          
# [586] "PART_NET_flux_o_i"          "NET_activemigpelfish_o_i"   "NET_activemigmigfish_o_i"  
# [589] "NET_activemigdemfish_o_i"   "NET_activemigbird_o_i"      "NET_activemigseal_o_i"     
# [592] "NET_activemigceta_o_i"      "NET_activemigbear_o_i"      "NET_mfish_ext_o"           
# [595] "fluxDINinflow"              "fluxDINoutflow"             "fluxPARTinflow"            
# [598] "fluxPARToutflow"            "atmosDINinput"              "rivDINinflow"              
# [601] "landp"                      "landd"                      "landd_o"                   
# [604] "landd_i"                    "landd_quota"                "landd_nonquota"            
# [607] "landm"                      "landsb"                     "landcb"                    
# [610] "landcz"                     "landbd"                     "landsl"                    
# [613] "landct"                     "discpel"                    "discdem"                   
# [616] "discdem_o"                  "discdem_i"                  "discdem_quota"             
# [619] "discdem_nonquota"           "discmig"                    "discsb"                    
# [622] "disccb"                     "disccz"                     "discbd"                    
# [625] "discsl"                     "discct"                     "offalpel"                  
# [628] "offaldem"                   "offaldem_o"                 "offaldem_i"                
# [631] "offaldem_quota"             "offaldem_nonquota"          "offalmig"                  
# [634] "offalsb"                    "offalcb"                    "offalcz"                   
# [637] "offalbd"                    "offalsl"                    "offalct"                   
# [640] "icealg_conc_m2ice_o"        "icealg_conc_m2ice_i"        "icedet_conc_m2ice_o"       
# [643] "icedet_conc_m2ice_i"        "iceassociated_nit_o"        "icenit_conc_m3ice_o"       
# [646] "iceassociated_nit_i"        "icenit_conc_m3ice_i"        "iceassociated_amm_o"       
# [649] "iceamm_conc_m3ice_o"        "iceassociated_amm_i"        "iceamm_conc_m3ice_i"       
# [652] "snownit_conc_m3snow_o"      "snownit_conc_m3snow_i"      "snowamm_conc_m3snow_o"     
# [655] "snowamm_conc_m3snow_i"      "x_poros"                    "x_depth"                   
# [658] "x_poros_o"                  "x_poros_i"                  "x_depth_o"                 
# [661] "x_depth_i"                  "poricevol"                  "impicevol"                 
# [664] "snowvol"                    "shallowprop"                "depth_si"                  
# [667] "depth_so"                   "depth_d"                    "area_s0"                   
# [670] "area_s1"                    "area_s2"                    "area_s3"                   
# [673] "area_d0"                    "area_d1"                    "area_d2"                   
# [676] "area_d3"                    "depth_s1"                   "depth_s2"                  
# [679] "depth_s3"                   "depth_d1"                   "depth_d2"                  
# [682] "depth_d3"                   "poros_s1"                   "poros_s2"                  
# [685] "poros_s3"                   "poros_d1"                   "poros_d2"                  
# [688] "poros_d3"                   "poricevol_o"                "poricevol_i"               
# [691] "impicevol_o"                "impicevol_i"                "snowvol_o"                 
# [694] "snowvol_i"                  "iteration"                  "likelihood"    


#creds<-c(0.1,0.5,0.9)  # This can be any lenth of vector in anu order. All values must be between 0 and 1
creds<-c(0.005,0.25,0.5,0.75,0.995)

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Build_Cred_Timeseries<-function(VtoPid,areaid,thikid,io,creds,varname){
rownamesvec<-rep(NA,(length(creds)+1))
for(kkk in 1:(length(creds)+1)){
if(kkk==1) rownamesvec[kkk]<-paste(varname,"-maxlik",sep="")
if(kkk>1)  rownamesvec[kkk]<-paste(varname,"-",creds[kkk-1],sep="")
}

Resultdata<-data.frame(rep(NA,(length(creds)+1)))
for(kkk in 1:360){
Resultdata[,kkk+1]<-(rep(NA,(length(creds)+1)))
}
names(Resultdata)<-seq(0,360)
row.names(Resultdata)<-rownamesvec

template<-data.frame(lastyearstore$time)
names(template)<-"time"
if( (sum(lastyearstore[,areaid]) == length(lastyearstore[,areaid])) == FALSE){
if(io==1) template$VtoP<-lastyearstore[,VtoPid]/(lastyearstore[,areaid]*lastyearstore[,thikid])
if(io==0) template$VtoP<-lastyearstore[,VtoPid]/((1-lastyearstore[,areaid])*lastyearstore[,thikid])
} else {
if(io==1) template$VtoP<-lastyearstore[,VtoPid]
if(io==0) template$VtoP<-lastyearstore[,VtoPid]
}
template$iteration<-lastyearstore$iteration
template$likelihood<-lastyearstore$likelihood

for(ii in 0:360){
Resultdata[1,ii+1]<-template$VtoP[which(template$time==ii&template$iteration==1)]
modresvector<-template$VtoP[which(template$time==ii)]
likevector<-template$likelihood[which(template$time==ii)]
credvals<-GetCredInt(modresvector,likevector,creds,var=varname,plotgraph=FALSE)
Resultdata[2:(length(credvals)+1),ii+1]<-credvals
}

return(Resultdata)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Build_Cred_Timeseries_Sediments<-function(VtoP1id,VtoP2id,areaid,thikid,porosid,creds,varname){
rownamesvec<-rep(NA,(length(creds)+1))
for(kkk in 1:(length(creds)+1)){
if(kkk==1) rownamesvec[kkk]<-paste(varname,"-maxlik",sep="")
if(kkk>1)  rownamesvec[kkk]<-paste(varname,"-",creds[kkk-1],sep="")
}

Resultdata<-data.frame(rep(NA,(length(creds)+1)))
for(kkk in 1:360){
Resultdata[,kkk+1]<-(rep(NA,(length(creds)+1)))
}
names(Resultdata)<-seq(0,360)
row.names(Resultdata)<-rownamesvec

#Add together the fas and slow detritus and convert to %N by weight of sediment
template<-data.frame(lastyearstore$time)
names(template)<-"time"
template$VtoP<-100*((lastyearstore[,VtoP1id]+lastyearstore[,VtoP2id])*14/1000)/((1-lastyearstore[,porosid])*lastyearstore[,areaid]*lastyearstore[,thikid]*(2650*1000))
template$iteration<-lastyearstore$iteration
template$likelihood<-lastyearstore$likelihood

for(ii in 0:360){
Resultdata[1,ii+1]<-template$VtoP[which(template$time==ii&template$iteration==1)]
modresvector<-template$VtoP[which(template$time==ii)]
likevector<-template$likelihood[which(template$time==ii)]
credvals<-GetCredInt(modresvector,likevector,creds,var=varname,plotgraph=FALSE)
Resultdata[2:(length(credvals)+1),ii+1]<-credvals
}

return(Resultdata)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Build_Cred_Timeseries_Porewater<-function(VtoPid,areaid,thikid,porosid,creds,varname){
rownamesvec<-rep(NA,(length(creds)+1))
for(kkk in 1:(length(creds)+1)){
if(kkk==1) rownamesvec[kkk]<-paste(varname,"-maxlik",sep="")
if(kkk>1)  rownamesvec[kkk]<-paste(varname,"-",creds[kkk-1],sep="")
}

Resultdata<-data.frame(rep(NA,(length(creds)+1)))
for(kkk in 1:360){
Resultdata[,kkk+1]<-(rep(NA,(length(creds)+1)))
}
names(Resultdata)<-seq(0,360)
row.names(Resultdata)<-rownamesvec

template<-data.frame(lastyearstore$time)
names(template)<-"time"
template$VtoP<-lastyearstore[,VtoPid]/(lastyearstore[,porosid]*lastyearstore[,areaid]*lastyearstore[,thikid])
template$iteration<-lastyearstore$iteration
template$likelihood<-lastyearstore$likelihood

for(ii in 0:360){
Resultdata[1,ii+1]<-template$VtoP[which(template$time==ii&template$iteration==1)]
modresvector<-template$VtoP[which(template$time==ii)]
likevector<-template$likelihood[which(template$time==ii)]
credvals<-GetCredInt(modresvector,likevector,creds,var=varname,plotgraph=FALSE)
Resultdata[2:(length(credvals)+1),ii+1]<-credvals
}

return(Resultdata)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~







#Surface detritus offshore
VtoPid<-which(names(lastyearstore)=="detritus_so")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_so")
io<-0  #offshore
varname<-"Surface_detritus_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-Result_data


#Deep detritus offshore
VtoPid<-which(names(lastyearstore)=="detritus_d")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_d")
io<-0  #offshore
varname<-"Deep_detritus_offshore"
#message("\n","Processing ",varname," data                        ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Surface detritus inshore
VtoPid<-which(names(lastyearstore)=="detritus_si")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_si")
io<-1  #inshore
varname<-"Surface_detritus_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Surface nitrate offshore
VtoPid<-which(names(lastyearstore)=="nitrate_so")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_so")
io<-0  #offshore
varname<-"Surface_nitrate_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Deep nitrate offshore
VtoPid<-which(names(lastyearstore)=="nitrate_d")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_d")
io<-0  #offshore
varname<-"Deep_nitrate_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Surface nitrate inshore
VtoPid<-which(names(lastyearstore)=="nitrate_si")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_si")
io<-1  #inshore
varname<-"Surface_nitrate_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Surface ammonia offshore
VtoPid<-which(names(lastyearstore)=="ammonia_so")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_so")
io<-0  #offshore
varname<-"Surface_ammonia_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Deep ammonia offshore
VtoPid<-which(names(lastyearstore)=="ammonia_d")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_d")
io<-0  #offshore
varname<-"Deep_ammonia_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Surface ammonia inshore
VtoPid<-which(names(lastyearstore)=="ammonia_si")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_si")
io<-1  #inshore
varname<-"Surface_ammonia_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Surface phyt offshore
VtoPid<-which(names(lastyearstore)=="phyt_so")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_so")
io<-0  #offshore
varname<-"Surface_phytoplankton_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Deep phyt offshore
VtoPid<-which(names(lastyearstore)=="phyt_d")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_d")
io<-0  #offshore
varname<-"Deep_phytoplankton_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Surface phyt inshore
VtoPid<-which(names(lastyearstore)=="phyt_si")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="depth_si")
io<-1  #inshore
varname<-"Surface_phytoplankton_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Kelp inshore
VtoPid<-which(names(lastyearstore)=="kelpN")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Macrophytes_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Kelp debris inshore
VtoPid<-which(names(lastyearstore)=="kelpdebris")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Macrophyte_debris_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Offshore omnizoo
VtoPid<-which(names(lastyearstore)=="omni_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Omnivorous_zooplankton_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore omnizoo
VtoPid<-which(names(lastyearstore)=="omni_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Omnivorous_zooplankton_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Offshore carnzoo
VtoPid<-which(names(lastyearstore)=="carn_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Carnivorous_zooplankton_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore carnzoo
VtoPid<-which(names(lastyearstore)=="carn_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Carnivorous_zooplankton_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Offshore plankfish
VtoPid<-which(names(lastyearstore)=="fishp_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Planktivorous_fish_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore plankfish
VtoPid<-which(names(lastyearstore)=="fishp_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Planktivorous_fish_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Offshore demfish
VtoPid<-which(names(lastyearstore)=="fishd_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Demersal_fish_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore demfish
VtoPid<-which(names(lastyearstore)=="fishd_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Demersal_fish_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Offshore migfish
VtoPid<-which(names(lastyearstore)=="fishm_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Migratory_fish_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore migfish
VtoPid<-which(names(lastyearstore)=="fishm_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Migratory_fish_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Offshore birds
VtoPid<-which(names(lastyearstore)=="bird_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Birds_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore birds
VtoPid<-which(names(lastyearstore)=="bird_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Birds_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Offshore seals
VtoPid<-which(names(lastyearstore)=="seal_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Pinnipeds_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore seals
VtoPid<-which(names(lastyearstore)=="seal_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Pinnipeds_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Offshore cetaceans
VtoPid<-which(names(lastyearstore)=="ceta_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Cetaceans_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore cetaceans
VtoPid<-which(names(lastyearstore)=="ceta_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Cetaceans_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Offshore maritime mammals
VtoPid<-which(names(lastyearstore)=="bear_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Maritime_mammals_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore maritime mammals
VtoPid<-which(names(lastyearstore)=="bear_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Maritime_mammals_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Offshore pelfishlar
VtoPid<-which(names(lastyearstore)=="fishplar_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Planktivorous_fish_larvae_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore pelfishlar
VtoPid<-which(names(lastyearstore)=="fishplar_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Planktivorous_fish_larvae_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore demfishlar
VtoPid<-which(names(lastyearstore)=="fishdlar_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Demersal_fish_larvae_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore demfishlar
VtoPid<-which(names(lastyearstore)=="fishdlar_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Demersal_fish_larvae_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore sdbenthlar
VtoPid<-which(names(lastyearstore)=="benthslar_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Suspension_deposit_benthos_larvae_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore sdbenthlar
VtoPid<-which(names(lastyearstore)=="benthslar_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Suspension_deposit_benthos_larvae_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore csbenthlar
VtoPid<-which(names(lastyearstore)=="benthclar_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Carnivore_scavenge_benthos_larvae_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore csbenthlar
VtoPid<-which(names(lastyearstore)=="benthclar_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Carnivore_scavenge_benthos_larvae_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore sdbenth
VtoPid<-which(names(lastyearstore)=="benths_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Suspension_deposit_benthos_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore sdbenth
VtoPid<-which(names(lastyearstore)=="benths_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Suspension_deposit_benthos_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore csbenth
VtoPid<-which(names(lastyearstore)=="benthc_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Carnivore_scavenge_benthos_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore csbenth
VtoPid<-which(names(lastyearstore)=="benthc_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Carnivore_scavenge_benthos_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore mud detritus
VtoP1id<-which(names(lastyearstore)=="x_detritus_d1")
VtoP2id<-which(names(lastyearstore)=="xR_detritus_d1")
areaid<-which(names(lastyearstore)=="area_d1")
thikid<-which(names(lastyearstore)=="depth_d1")
porosid<-which(names(lastyearstore)=="poros_d1") 
varname<-"Sediment_detritus_N%_by_weight_offshore_mud"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Sediments(VtoP1id,VtoP2id,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore mud detritus
VtoP1id<-which(names(lastyearstore)=="x_detritus_s1")
VtoP2id<-which(names(lastyearstore)=="xR_detritus_s1")
areaid<-which(names(lastyearstore)=="area_s1")
thikid<-which(names(lastyearstore)=="depth_s1")
porosid<-which(names(lastyearstore)=="poros_s1") 
varname<-"Sediment_detritus_N%_by_weight_inshore_mud"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Sediments(VtoP1id,VtoP2id,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore sand detritus
VtoP1id<-which(names(lastyearstore)=="x_detritus_d2")
VtoP2id<-which(names(lastyearstore)=="xR_detritus_d2")
areaid<-which(names(lastyearstore)=="area_d2")
thikid<-which(names(lastyearstore)=="depth_d2")
porosid<-which(names(lastyearstore)=="poros_d2") 
varname<-"Sediment_detritus_N%_by_weight_offshore_sand"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Sediments(VtoP1id,VtoP2id,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore sand detritus
VtoP1id<-which(names(lastyearstore)=="x_detritus_s2")
VtoP2id<-which(names(lastyearstore)=="xR_detritus_s2")
areaid<-which(names(lastyearstore)=="area_s2")
thikid<-which(names(lastyearstore)=="depth_s2")
porosid<-which(names(lastyearstore)=="poros_s2") 
varname<-"Sediment_detritus_N%_by_weight_inshore_sand"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Sediments(VtoP1id,VtoP2id,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#offshore gravel detritus
VtoP1id<-which(names(lastyearstore)=="x_detritus_d3")
VtoP2id<-which(names(lastyearstore)=="xR_detritus_d3")
areaid<-which(names(lastyearstore)=="area_d3")
thikid<-which(names(lastyearstore)=="depth_d3")
porosid<-which(names(lastyearstore)=="poros_d3") 
varname<-"Sediment_detritus_N%_by_weight_offshore_gravel"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Sediments(VtoP1id,VtoP2id,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore gravel detritus
VtoP1id<-which(names(lastyearstore)=="x_detritus_s3")
VtoP2id<-which(names(lastyearstore)=="xR_detritus_s3")
areaid<-which(names(lastyearstore)=="area_s3")
thikid<-which(names(lastyearstore)=="depth_s3")
porosid<-which(names(lastyearstore)=="poros_s3") 
varname<-"Sediment_detritus_N%_by_weight_inshore_gravel"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Sediments(VtoP1id,VtoP2id,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)



#offshore mud nitrate
VtoPid<-which(names(lastyearstore)=="x_nitrate_d1")
areaid<-which(names(lastyearstore)=="area_d1")
thikid<-which(names(lastyearstore)=="depth_d1")
porosid<-which(names(lastyearstore)=="poros_d1") 
varname<-"Porewater_nitrate_offshore_mud"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore mud nitrate
VtoPid<-which(names(lastyearstore)=="x_nitrate_s1")
areaid<-which(names(lastyearstore)=="area_s1")
thikid<-which(names(lastyearstore)=="depth_s1")
porosid<-which(names(lastyearstore)=="poros_s1") 
varname<-"Porewater_nitrate_inshore_mud"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore sand nitrate
VtoPid<-which(names(lastyearstore)=="x_nitrate_d2")
areaid<-which(names(lastyearstore)=="area_d2")
thikid<-which(names(lastyearstore)=="depth_d2")
porosid<-which(names(lastyearstore)=="poros_d2") 
varname<-"Porewater_nitrate_offshore_sand"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore sand nitrate
VtoPid<-which(names(lastyearstore)=="x_nitrate_s2")
areaid<-which(names(lastyearstore)=="area_s2")
thikid<-which(names(lastyearstore)=="depth_s2")
porosid<-which(names(lastyearstore)=="poros_s2") 
varname<-"Porewater_nitrate_inshore_sand"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore gravel nitrate
VtoPid<-which(names(lastyearstore)=="x_nitrate_d3")
areaid<-which(names(lastyearstore)=="area_d3")
thikid<-which(names(lastyearstore)=="depth_d3")
porosid<-which(names(lastyearstore)=="poros_d3") 
varname<-"Porewater_nitrate_offshore_gravel"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore gravel nitrate
VtoPid<-which(names(lastyearstore)=="x_nitrate_s3")
areaid<-which(names(lastyearstore)=="area_s3")
thikid<-which(names(lastyearstore)=="depth_s3")
porosid<-which(names(lastyearstore)=="poros_s3") 
varname<-"Porewater_nitrate_inshore_gravel"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#offshhore mud ammonia
VtoPid<-which(names(lastyearstore)=="x_ammonia_d1")
areaid<-which(names(lastyearstore)=="area_d1")
thikid<-which(names(lastyearstore)=="depth_d1")
porosid<-which(names(lastyearstore)=="poros_d1") 
varname<-"Porewater_ammonia_offshore_mud"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore mud ammonia
VtoPid<-which(names(lastyearstore)=="x_ammonia_s1")
areaid<-which(names(lastyearstore)=="area_s1")
thikid<-which(names(lastyearstore)=="depth_s1")
porosid<-which(names(lastyearstore)=="poros_s1") 
varname<-"Porewater_ammonia_inshore_mud"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#offshore sand ammonia
VtoPid<-which(names(lastyearstore)=="x_ammonia_d2")
areaid<-which(names(lastyearstore)=="area_d2")
thikid<-which(names(lastyearstore)=="depth_d2")
porosid<-which(names(lastyearstore)=="poros_d2") 
varname<-"Porewater_ammonia_offshore_sand"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore sand ammonia
VtoPid<-which(names(lastyearstore)=="x_ammonia_s2")
areaid<-which(names(lastyearstore)=="area_s2")
thikid<-which(names(lastyearstore)=="depth_s2")
porosid<-which(names(lastyearstore)=="poros_s2") 
varname<-"Porewater_ammonia_inshore_sand"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#offshore gravel ammonia
VtoPid<-which(names(lastyearstore)=="x_ammonia_d3")
areaid<-which(names(lastyearstore)=="area_d3")
thikid<-which(names(lastyearstore)=="depth_d3")
porosid<-which(names(lastyearstore)=="poros_d3") 
varname<-"Porewater_ammonia_offshore_gravel"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore gravel ammonia
VtoPid<-which(names(lastyearstore)=="x_ammonia_s3")
areaid<-which(names(lastyearstore)=="area_s3")
thikid<-which(names(lastyearstore)=="depth_s3")
porosid<-which(names(lastyearstore)=="poros_s3") 
varname<-"Porewater_ammonia_inshore_gravel"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries_Porewater(VtoPid,areaid,thikid,porosid,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Offshore corpses
VtoPid<-which(names(lastyearstore)=="corpse_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Corpses_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore corpses
VtoPid<-which(names(lastyearstore)=="corpse_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Corpses_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Offshore discards
VtoPid<-which(names(lastyearstore)=="discard_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Discards_offshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#inshore discards
VtoPid<-which(names(lastyearstore)=="discard_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Discards_inshore"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice detritus density per m2 zonal area offshore
VtoPid<-which(names(lastyearstore)=="ice_detritus_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_detritus_offshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice detritus density per m2 zonal area inshore
VtoPid<-which(names(lastyearstore)=="ice_detritus_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_detritus_inshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice algae density per m2 zonal area offshore
VtoPid<-which(names(lastyearstore)=="ice_algae_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_algae_offshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice algae density per m2 zonal area inshore
VtoPid<-which(names(lastyearstore)=="ice_algae_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_algae_inshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Ice-associated nitrate density per m2 zonal area offshore
VtoPid<-which(names(lastyearstore)=="iceassociated_nit_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_nitrate_offshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice nitrate density per m2 zonal area inshore
VtoPid<-which(names(lastyearstore)=="iceassociated_nit_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_nitrate_inshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Ice-associated ammonia density per m2 zonal area offshore
VtoPid<-which(names(lastyearstore)=="iceassociated_amm_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_ammonia_offshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice-associated ammonia density per m2 zonal area inshore
VtoPid<-which(names(lastyearstore)=="iceassociated_amm_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_ammonia_inshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Snow nitrate density per m2 zonal area offshore
VtoPid<-which(names(lastyearstore)=="snow_nitrate_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Snow_nitrate_offshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Snow nitrate density per m2 zonal area inshore
VtoPid<-which(names(lastyearstore)=="snow_nitrate_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Snow_nitrate_inshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Snow ammonia density per m2 zonal area offshore
VtoPid<-which(names(lastyearstore)=="snow_ammonia_o")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Snow_ammonia_offshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Snow ammonia density per m2 zonal area inshore
VtoPid<-which(names(lastyearstore)=="snow_ammonia_i")
areaid<-which(names(lastyearstore)=="shallowprop")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Snow_ammonia_inshore.m2"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Ice detritus density per m2 ice area - offshore
VtoPid<-which(names(lastyearstore)=="icedet_conc_m2ice_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_detritus_offshore.m2.icearea"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice detritus density per m2 ice area - inshore
VtoPid<-which(names(lastyearstore)=="icedet_conc_m2ice_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_detritus_inshore.m2.icearea"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)




#Ice algae density per m2 ice area - offshore
VtoPid<-which(names(lastyearstore)=="icealg_conc_m2ice_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_algae_offshore.m2.icearea"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice algae density per m2 ice area - inshore
VtoPid<-which(names(lastyearstore)=="icealg_conc_m2ice_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_algae_inshore.m2.icearea"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)




#Ice nitrate concentration per m3 ice volume - offshore
VtoPid<-which(names(lastyearstore)=="icenit_conc_m3ice_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_nitrate_offshore.m3.icevol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice nitrate concentration per m3 ice volume - inshore
VtoPid<-which(names(lastyearstore)=="icenit_conc_m3ice_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_nitrate_inshore.m3.icevol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)




#Ice ammonia concentration per m3 ice volume - offshore
VtoPid<-which(names(lastyearstore)=="iceamm_conc_m3ice_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Ice_ammonia_offshore.m3.icevol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ice ammonia concentration per m3 ice volume - inshore
VtoPid<-which(names(lastyearstore)=="iceamm_conc_m3ice_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Ice_ammonia_inshore.m3.icevol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)




#Snow nitrate concentration per m3 snow volume - offshore
VtoPid<-which(names(lastyearstore)=="snownit_conc_m3snow_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Snow_nitrate_offshore.m3.snowvol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Snow nitrate concentration per m3 snow volume - inshore
VtoPid<-which(names(lastyearstore)=="snownit_conc_m3snow_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Snow_nitrate_inshore.m3.snowvol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)





#Snow ammonia concentration per m3 snow volume - offshore
VtoPid<-which(names(lastyearstore)=="snowamm_conc_m3snow_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-0  #offshore
varname<-"Snow_ammonia_offshore.m3.snowvol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Snow ammonia concentration per m3 snow volume - inshore
VtoPid<-which(names(lastyearstore)=="snowamm_conc_m3snow_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-1  #inshore
varname<-"Snow_ammonia_inshore.m3.snowvol"
#message("\n","Processing ",varname," data                          ")
Result_data<-Build_Cred_Timeseries(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


csvfile <- csvname(credpath, "CredInt_processed_daily_mass", identifier)
writecsv(Result_data_store, csvfile)

Result_data_store

}

