#
# perturb_parameters_fixed.R
#
#' perturb the fixed parameters a bit
#'
#' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' Subroutine to load and set the fixed parameter values to be used in the model run
#'
#' Fixed parameters are
#' loaded from a csv file 
#'
#' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#'
#' In this bit of code the parameters can be varied by a random value drawn from a uniform distribution. The range of the
#' distribution is constant across groups of parameters.
#' Intended for use in MCMC
#'
#' VECTORS BUILT UP:
#'	prefstore	~ 67 pars
#'	ustore		~ 13 pars
#'	hstore		~ 14 pars
#'	biogeostore	~ 18 pars
#'	mortstore	~ 14 pars
#'	reststore	~ 14 pars
#'
#'      fixed           ~ 65 pars
#'
#' @param datastore parameters to be perturbed
#' @param annealing.parms annealing parameters
#'
#' @return perturbed parameter vector
#'
#' @noRd
#
# ------------------------------------------------------------------------------

perturb_parameters_fixed <- function(fixed.datastore, annealing.parms) {

	#Set the SDs for the parameters
        fixedsd         <- elt(annealing.parms, "fixedsd")	# fixed parameters sd
#fixedsd<-0.15

perturbed.fixed <- fixed.datastore    # Make a copy of the original set of parameters as the template for the output

for(zz in 1:(length(fixed.datastore)-1)){

# The bird seal ceta and bear icesens values must be > 1  
if(names(fixed.datastore[zz])=="icesensbird" || names(fixed.datastore[zz])=="icesensseal" || names(fixed.datastore[zz])=="icesensceta" || names(fixed.datastore[zz])=="icesensbear" ){
perturbed.fixed[zz]  <- max(1,runif(1,(1-fixedsd)*as.numeric(fixed.datastore[zz]),(1+fixedsd)*as.numeric(fixed.datastore[zz])))
} else {
perturbed.fixed[zz]  <- max(0,runif(1,(1-fixedsd)*as.numeric(fixed.datastore[zz]),(1+fixedsd)*as.numeric(fixed.datastore[zz])))
}

}

return(perturbed.fixed)

}

