% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_compare_runs_box.R
\name{e2ep_compare_runs_box}
\alias{e2ep_compare_runs_box}
\title{Box and whisker plots comparing annual or monthly outputs from single or Monte Carlo baseline and scenario model runs.}
\usage{
e2ep_compare_runs_box(
  selection = "ANNUAL",
  model1,
  ci.data1 = FALSE,
  use.saved1 = FALSE,
  use.example1 = FALSE,
  results1 = NULL,
  model2,
  ci.data2 = FALSE,
  use.saved2 = FALSE,
  use.example2 = FALSE,
  results2 = NULL
)
}
\arguments{
\item{selection}{Text string from a list to select comparison with annual or monthly observations. Select from: "ANNUAL", "MONTHLY". Remember to include the phrase within "" quotes.}

\item{model1}{R-list object defining the baseline model configuration compiled by the e2ep_read() function.}

\item{ci.data1}{Logical. If TRUE plot credible intervals around baseline model results based on Monte Carlo simulation with the e2ep_run_mc() function (default=FALSE).}

\item{use.saved1}{Logical. If TRUE use baseline data from a prior user-defined run held as csv files data in the current results folder (default=FALSE).}

\item{use.example1}{NOT YET ENABLED. In future versions - Logical. If TRUE use pre-computed example data from the internal Barents Sea model as the baseline rather than user-generated data (default=FALSE).}

\item{results1}{R-list object of baseline model output generated by the e2ep_run() function. Only needed if ci.data1=FALSE, use.saved1=FALSE and use.example1=FALSE. (Default=NULL).}

\item{model2}{R-list object defining the scenario model configuration compiled by the e2ep_read() function.}

\item{ci.data2}{Logical. If TRUE plot credible intervals around scenario model results based on Monte Carlo simulation with the e2ep_run_mc() function (default=FALSE).}

\item{use.saved2}{Logical. If TRUE use scenario data from a prior user-defined run held as csv files data in the current results folder (default=FALSE).}

\item{use.example2}{NOT YET ENABLED. In future versions - Logical. If TRUE use pre-computed example data from the internal Barents Sea model as the scenario rather than user-generated data (default=FALSE).}

\item{results2}{R-list object of baseline model output generated by the e2ep_run() function. Only needed if ci.data2=FALSE, use.saved2=FALSE and use.example2=FALSE. (Default=NULL).}
}
\value{
Graphical display in a new graphics window.
}
\description{
Generate a multi-panel set of box and whisker diagrams comparing annual or monthly averaged or integrated model outputs
from single or Monte Carlo baseline (black) and scenario (red) model runs. Each panel of annual data displays a different category of model data; each panel of monthly data shows a different nutrient or plankton guild.
}
\details{
Arguments determine the source of model data for comparison. These can be outputs from 
a Monte Carlo simulations (using the function e2ep_run_mc()) to estimate credible intervals of model outputs, or from single model runs using e2ep_run(). Generation of credible interval data is a long computing task, so 
example data for the Barents Sea model provided with the package are available as an illustration.

In each plot panel, where credible intervals of model outputs (from Monte Carlo analysis) have been selected 
the box spans 50% of the lielihood distribution of data, whiskers span 99%, and the median is indicated by tick mark). Baseline model results are 
always shown in black, scenario results in red.
}
\examples{
# Load the 2011-2019 version of the internal Barents Sea model and run for 1 year
    m1 <- e2ep_read("Barents_Sea", "2011-2019",model.ident="11-19")
    r1 <-e2ep_run(m1,nyears=1)

# Load the 2011-2019 version of the internal Barents Sea model, modify and run for 1 year
    m2 <- e2ep_read("Barents_Sea", "2011-2019",model.ident="plus1C")
    m2$data$physics.drivers$so_temp<-m2$data$physics.drivers$so_temp+1
# 1-degC added to offshore zone upper layer temperatures
    r2 <-e2ep_run(m2,nyears=1)

# Compare annual results from 2011-2019 as baseline with "plus1C" as scenario:
    e2ep_compare_runs_box(selection="ANNUAL", model1=m1, ci.data1=FALSE, results1=r1,
                                             model2=m2, ci.data2=FALSE, results2=r2)
# Compare monthly results from 2011-2019 as baseline with 2003-2013 as scenario:
    dev.new()
    e2ep_compare_runs_box(selection="MONTHLY", model1=m1, ci.data1=FALSE, results1=r1,
                                          model2=m2, ci.data2=FALSE, results2=r2)

# This example requires the StrathE2EPolarexamples supplementrary data package.
# Compare 2011-2019 as baseline (from single model run), with 2003-2013
# as scenario (from example data with credible interval results):
if(require(StrathE2EPolarexamples)){
    e2ep_compare_runs_box(selection="ANNUAL", model1=m1, ci.data1=FALSE, results1=r1,
                                             model2=m2, ci.data2=TRUE, use.example2=TRUE)
    dev.new()
    e2ep_compare_runs_box(selection="MONTHLY", model1=m1, ci.data1=FALSE, results1=r1,
                                             model2=m2, ci.data2=TRUE, use.example2=TRUE)
}

# This example requires the StrathE2EPolarexamples supplementrary data package.
# Compare 2011-2019 as baseline (from example data with cred.int.), with 2003-2013
# as scenario (from example data with credible interval results):
if(require(StrathE2EPolarexamples)){
    e2ep_compare_runs_box(selection="ANNUAL", model1=m1, ci.data1=TRUE, use.example1=TRUE,
                                             model2=m2, ci.data2=TRUE, use.example2=TRUE)
    dev.new()
    e2ep_compare_runs_box(selection="MONTHLY", model1=m1, ci.data1=TRUE, use.example1=TRUE,
                                              model2=m2, ci.data2=TRUE, use.example2=TRUE)
}

}
\seealso{
\code{\link{e2ep_read}}, \code{\link{e2ep_run}}, \code{\link{e2ep_run_mc}}, \code{\link{e2ep_compare_runs_bar}}, \code{\link{e2ep_compare_obs}}
}
